/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.OptimizationData;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.PointValuePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.linear.LinearOptimizer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.linear.NoFeasibleSolutionException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.linear.PivotSelectionRule;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.linear.SimplexTableau;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.linear.SolutionCallback;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.linear.UnboundedSolutionException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.io.Serializable;
import java.util.ArrayList;

public class SimplexSolver
extends LinearOptimizer {
    static final int DEFAULT_ULPS = 10;
    static final double DEFAULT_CUT_OFF = 1.0E-10;
    private static final double DEFAULT_EPSILON = 1.0E-6;
    private final double epsilon;
    private final int maxUlps;
    private final double cutOff;
    private PivotSelectionRule pivotSelection;
    private SolutionCallback solutionCallback;

    public SimplexSolver() {
        this(1.0E-6, 10, 1.0E-10);
    }

    public SimplexSolver(double d2) {
        this(d2, 10, 1.0E-10);
    }

    public SimplexSolver(double d2, int n) {
        this(d2, n, 1.0E-10);
    }

    public SimplexSolver(double d2, int n, double d3) {
        this.epsilon = d2;
        this.maxUlps = n;
        this.cutOff = d3;
        this.pivotSelection = PivotSelectionRule.DANTZIG;
    }

    public PointValuePair optimize(OptimizationData ... optimizationDataArray) {
        return super.optimize(optimizationDataArray);
    }

    protected void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        super.parseOptimizationData(optimizationDataArray);
        this.solutionCallback = null;
        for (OptimizationData optimizationData : optimizationDataArray) {
            if (optimizationData instanceof SolutionCallback) {
                this.solutionCallback = (SolutionCallback)optimizationData;
                continue;
            }
            if (!(optimizationData instanceof PivotSelectionRule)) continue;
            this.pivotSelection = (PivotSelectionRule)optimizationData;
        }
    }

    private Integer getPivotColumn(SimplexTableau simplexTableau) {
        double d2 = 0.0;
        Integer n = null;
        for (int i2 = simplexTableau.getNumObjectiveFunctions(); i2 < simplexTableau.getWidth() - 1; ++i2) {
            double d3;
            double d4 = simplexTableau.getEntry(0, i2);
            if (!(d3 < d2)) continue;
            d2 = d4;
            n = i2;
            if (this.pivotSelection == PivotSelectionRule.BLAND && this.isValidPivotColumn(simplexTableau, i2)) break;
        }
        return n;
    }

    private boolean isValidPivotColumn(SimplexTableau simplexTableau, int n) {
        for (int i2 = simplexTableau.getNumObjectiveFunctions(); i2 < simplexTableau.getHeight(); ++i2) {
            double d2 = simplexTableau.getEntry(i2, n);
            if (Precision.compareTo(d2, 0.0, this.cutOff) <= 0) continue;
            return true;
        }
        return false;
    }

    private Integer getPivotRow(SimplexTableau simplexTableau, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        double d2 = Double.MAX_VALUE;
        for (int i2 = simplexTableau.getNumObjectiveFunctions(); i2 < simplexTableau.getHeight(); ++i2) {
            double d3 = simplexTableau.getEntry(i2, simplexTableau.getWidth() - 1);
            double d4 = simplexTableau.getEntry(i2, n);
            if (Precision.compareTo(d4, 0.0, this.cutOff) <= 0) continue;
            double d5 = FastMath.abs(d3 / d4);
            int n2 = Double.compare(d5, d2);
            if (n2 == 0) {
                arrayList.add(i2);
                continue;
            }
            if (n2 >= 0) continue;
            d2 = d5;
            arrayList.clear();
            arrayList.add(i2);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() > 1) {
            if (simplexTableau.getNumArtificialVariables() > 0) {
                for (Integer n3 : arrayList) {
                    for (int i3 = 0; i3 < simplexTableau.getNumArtificialVariables(); ++i3) {
                        int n4 = i3 + simplexTableau.getArtificialVariableOffset();
                        double d6 = simplexTableau.getEntry(n3, n4);
                        if (!Precision.equals(d6, 1.0, this.maxUlps) || !n3.equals(simplexTableau.getBasicRow(n4))) continue;
                        return n3;
                    }
                }
            }
            Integer n5 = null;
            int n6 = simplexTableau.getWidth();
            for (Integer n7 : arrayList) {
                int n8 = simplexTableau.getBasicVariable(n7);
                if (n8 >= n6) continue;
                n6 = n8;
                n5 = n7;
            }
            return n5;
        }
        return (Integer)arrayList.get(0);
    }

    protected void doIteration(SimplexTableau simplexTableau) {
        this.incrementIterationCount();
        Integer n = this.getPivotColumn(simplexTableau);
        Integer n2 = this.getPivotRow(simplexTableau, n);
        if (n2 == null) {
            throw new UnboundedSolutionException();
        }
        simplexTableau.performRowOperations(n, n2);
    }

    protected void solvePhase1(SimplexTableau simplexTableau) {
        if (simplexTableau.getNumArtificialVariables() == 0) {
            return;
        }
        while (!simplexTableau.isOptimal()) {
            this.doIteration(simplexTableau);
        }
        if (!Precision.equals(simplexTableau.getEntry(0, simplexTableau.getRhsOffset()), 0.0, this.epsilon)) {
            throw new NoFeasibleSolutionException();
        }
    }

    public PointValuePair doOptimize() {
        if (this.solutionCallback != null) {
            this.solutionCallback.setTableau(null);
        }
        Serializable serializable = new SimplexTableau(this.getFunction(), this.getConstraints(), this.getGoalType(), this.isRestrictedToNonNegative(), this.epsilon, this.maxUlps);
        this.solvePhase1((SimplexTableau)serializable);
        ((SimplexTableau)serializable).dropPhase1Objective();
        if (this.solutionCallback != null) {
            this.solutionCallback.setTableau((SimplexTableau)serializable);
        }
        while (!((SimplexTableau)serializable).isOptimal()) {
            this.doIteration((SimplexTableau)serializable);
        }
        serializable = ((SimplexTableau)serializable).getSolution();
        if (this.isRestrictedToNonNegative()) {
            double[] dArray = ((PointValuePair)serializable).getPoint();
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                if (Precision.compareTo(dArray[i2], 0.0, this.epsilon) >= 0) continue;
                throw new NoFeasibleSolutionException();
            }
        }
        return serializable;
    }
}

