/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.ConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.OptimizationData;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.PointValuePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.linear.LinearConstraint;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.linear.LinearConstraintSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.linear.NonNegativeConstraint;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.MultivariateOptimizer;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LinearOptimizer
extends MultivariateOptimizer {
    private LinearObjectiveFunction function;
    private Collection<LinearConstraint> linearConstraints;
    private boolean nonNegative;

    protected LinearOptimizer() {
        super((ConvergenceChecker<PointValuePair>)null);
    }

    protected boolean isRestrictedToNonNegative() {
        return this.nonNegative;
    }

    protected LinearObjectiveFunction getFunction() {
        return this.function;
    }

    protected Collection<LinearConstraint> getConstraints() {
        return Collections.unmodifiableCollection(this.linearConstraints);
    }

    @Override
    public PointValuePair optimize(OptimizationData ... optimizationDataArray) {
        return super.optimize(optimizationDataArray);
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        super.parseOptimizationData(optimizationDataArray);
        for (OptimizationData optimizationData : optimizationDataArray) {
            if (optimizationData instanceof LinearObjectiveFunction) {
                this.function = (LinearObjectiveFunction)optimizationData;
                continue;
            }
            if (optimizationData instanceof LinearConstraintSet) {
                this.linearConstraints = ((LinearConstraintSet)optimizationData).getConstraints();
                continue;
            }
            if (!(optimizationData instanceof NonNegativeConstraint)) continue;
            this.nonNegative = ((NonNegativeConstraint)optimizationData).isRestrictedToNonNegative();
        }
    }
}

