/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.AbstractConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.PointVectorValuePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleVectorValueChecker
extends AbstractConvergenceChecker<PointVectorValuePair> {
    private static final int ITERATION_CHECK_DISABLED = -1;
    private final int maxIterationCount;

    public SimpleVectorValueChecker(double d2, double d3) {
        super(d2, d3);
        this.maxIterationCount = -1;
    }

    public SimpleVectorValueChecker(double d2, double d3, int n) {
        super(d2, d3);
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        this.maxIterationCount = n;
    }

    @Override
    public boolean converged(int n, PointVectorValuePair object, PointVectorValuePair pointVectorValuePair) {
        if (this.maxIterationCount != -1 && n >= this.maxIterationCount) {
            return true;
        }
        double[] dArray = ((PointVectorValuePair)object).getValueRef();
        object = pointVectorValuePair.getValueRef();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d2;
            double d3 = dArray[i2];
            Object object2 = object[i2];
            double d4 = FastMath.abs(d3 - object2);
            if (!(d4 > (d2 = FastMath.max(FastMath.abs(d3), FastMath.abs((double)object2))) * this.getRelativeThreshold()) || !(d4 > this.getAbsoluteThreshold())) continue;
            return false;
        }
        return true;
    }
}

