/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.AbstractConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.PointValuePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleValueChecker
extends AbstractConvergenceChecker<PointValuePair> {
    private static final int ITERATION_CHECK_DISABLED = -1;
    private final int maxIterationCount;

    public SimpleValueChecker(double d2, double d3) {
        super(d2, d3);
        this.maxIterationCount = -1;
    }

    public SimpleValueChecker(double d2, double d3, int n) {
        super(d2, d3);
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        this.maxIterationCount = n;
    }

    @Override
    public boolean converged(int n, PointValuePair pointValuePair, PointValuePair pointValuePair2) {
        double d2;
        double d3;
        if (this.maxIterationCount != -1 && n >= this.maxIterationCount) {
            return true;
        }
        double d4 = (Double)pointValuePair.getValue();
        double d5 = FastMath.abs(d4 - (d3 = ((Double)pointValuePair2.getValue()).doubleValue()));
        return d5 <= (d2 = FastMath.max(FastMath.abs(d4), FastMath.abs(d3))) * this.getRelativeThreshold() || d5 <= this.getAbsoluteThreshold();
    }
}

