/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.AbstractConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePointChecker<PAIR extends Pair<double[], ? extends Object>>
extends AbstractConvergenceChecker<PAIR> {
    private static final int ITERATION_CHECK_DISABLED = -1;
    private final int maxIterationCount;

    public SimplePointChecker(double d2, double d3) {
        super(d2, d3);
        this.maxIterationCount = -1;
    }

    public SimplePointChecker(double d2, double d3, int n) {
        super(d2, d3);
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        this.maxIterationCount = n;
    }

    @Override
    public boolean converged(int n, PAIR object, PAIR PAIR) {
        if (this.maxIterationCount != -1 && n >= this.maxIterationCount) {
            return true;
        }
        double[] dArray = (double[])((Pair)object).getKey();
        object = (double[])((Pair)PAIR).getKey();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d2;
            double d3 = dArray[i2];
            PAIR PAIR2 = object[i2];
            double d4 = FastMath.abs(d3 - PAIR2);
            if (!(d4 > (d2 = FastMath.max(FastMath.abs(d3), FastMath.abs(PAIR2))) * this.getRelativeThreshold()) || !(d4 > this.getAbsoluteThreshold())) continue;
            return false;
        }
        return true;
    }
}

