/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.BaseOptimizer$MaxEvalCallback;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.BaseOptimizer$MaxIterCallback;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.ConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.MaxEval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.MaxIter;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.OptimizationData;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Incrementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseOptimizer<PAIR> {
    protected final Incrementor evaluations;
    protected final Incrementor iterations;
    private final ConvergenceChecker<PAIR> checker;

    protected BaseOptimizer(ConvergenceChecker<PAIR> convergenceChecker) {
        this(convergenceChecker, 0, Integer.MAX_VALUE);
    }

    protected BaseOptimizer(ConvergenceChecker<PAIR> convergenceChecker, int n, int n2) {
        this.checker = convergenceChecker;
        this.evaluations = new Incrementor(n, new BaseOptimizer$MaxEvalCallback(null));
        this.iterations = new Incrementor(n2, new BaseOptimizer$MaxIterCallback(null));
    }

    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    public int getMaxIterations() {
        return this.iterations.getMaximalCount();
    }

    public int getIterations() {
        return this.iterations.getCount();
    }

    public ConvergenceChecker<PAIR> getConvergenceChecker() {
        return this.checker;
    }

    public PAIR optimize(OptimizationData ... optimizationDataArray) {
        this.parseOptimizationData(optimizationDataArray);
        this.evaluations.resetCount();
        this.iterations.resetCount();
        return this.doOptimize();
    }

    public PAIR optimize() {
        this.evaluations.resetCount();
        this.iterations.resetCount();
        return this.doOptimize();
    }

    protected abstract PAIR doOptimize();

    protected void incrementEvaluationCount() {
        this.evaluations.incrementCount();
    }

    protected void incrementIterationCount() {
        this.iterations.incrementCount();
    }

    protected void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        for (OptimizationData optimizationData : optimizationDataArray) {
            if (optimizationData instanceof MaxEval) {
                this.evaluations.setMaximalCount(((MaxEval)optimizationData).getMaxEval());
                continue;
            }
            if (!(optimizationData instanceof MaxIter)) continue;
            this.iterations.setMaximalCount(((MaxIter)optimizationData).getMaxIter());
        }
    }
}

