/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.BaseOptimizer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.ConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.InitialGuess;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.OptimizationData;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.SimpleBounds;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMultivariateOptimizer<PAIR>
extends BaseOptimizer<PAIR> {
    private double[] start;
    private double[] lowerBound;
    private double[] upperBound;

    protected BaseMultivariateOptimizer(ConvergenceChecker<PAIR> convergenceChecker) {
        super(convergenceChecker);
    }

    @Override
    public PAIR optimize(OptimizationData ... optimizationDataArray) {
        return super.optimize(optimizationDataArray);
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        super.parseOptimizationData(optimizationDataArray);
        for (OptimizationData optimizationData : optimizationDataArray) {
            if (optimizationData instanceof InitialGuess) {
                this.start = ((InitialGuess)optimizationData).getInitialGuess();
                continue;
            }
            if (!(optimizationData instanceof SimpleBounds)) continue;
            optimizationData = (SimpleBounds)optimizationData;
            this.lowerBound = ((SimpleBounds)optimizationData).getLower();
            this.upperBound = ((SimpleBounds)optimizationData).getUpper();
        }
        this.checkParameters();
    }

    public double[] getStartPoint() {
        if (this.start == null) {
            return null;
        }
        return (double[])this.start.clone();
    }

    public double[] getLowerBound() {
        if (this.lowerBound == null) {
            return null;
        }
        return (double[])this.lowerBound.clone();
    }

    public double[] getUpperBound() {
        if (this.upperBound == null) {
            return null;
        }
        return (double[])this.upperBound.clone();
    }

    private void checkParameters() {
        if (this.start != null) {
            double d2;
            double d3;
            int n;
            int n2 = this.start.length;
            if (this.lowerBound != null) {
                if (this.lowerBound.length != n2) {
                    throw new DimensionMismatchException(this.lowerBound.length, n2);
                }
                for (n = 0; n < n2; ++n) {
                    d3 = this.start[n];
                    d2 = this.lowerBound[n];
                    if (!(d3 < d2)) continue;
                    throw new NumberIsTooSmallException(d3, (Number)d2, true);
                }
            }
            if (this.upperBound != null) {
                if (this.upperBound.length != n2) {
                    throw new DimensionMismatchException(this.upperBound.length, n2);
                }
                for (n = 0; n < n2; ++n) {
                    d3 = this.start[n];
                    d2 = this.upperBound[n];
                    if (!(d3 > d2)) continue;
                    throw new NumberIsTooLargeException(d3, (Number)d2, true);
                }
            }
        }
    }
}

