/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.TooManyEvaluationsException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.BaseMultivariateOptimizer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.BaseOptimizer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.InitialGuess;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.MaxEval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.OptimizationData;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomVectorGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMultiStartMultivariateOptimizer<PAIR>
extends BaseMultivariateOptimizer<PAIR> {
    private final BaseMultivariateOptimizer<PAIR> optimizer;
    private int totalEvaluations;
    private int starts;
    private RandomVectorGenerator generator;
    private OptimizationData[] optimData;
    private int maxEvalIndex = -1;
    private int initialGuessIndex = -1;

    public BaseMultiStartMultivariateOptimizer(BaseMultivariateOptimizer<PAIR> baseMultivariateOptimizer, int n, RandomVectorGenerator randomVectorGenerator) {
        super(baseMultivariateOptimizer.getConvergenceChecker());
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        this.optimizer = baseMultivariateOptimizer;
        this.starts = n;
        this.generator = randomVectorGenerator;
    }

    @Override
    public int getEvaluations() {
        return this.totalEvaluations;
    }

    public abstract PAIR[] getOptima();

    @Override
    public PAIR optimize(OptimizationData ... optimizationDataArray) {
        this.optimData = optimizationDataArray;
        return super.optimize(optimizationDataArray);
    }

    @Override
    protected PAIR doOptimize() {
        for (int i2 = 0; i2 < this.optimData.length; ++i2) {
            if (this.optimData[i2] instanceof MaxEval) {
                this.optimData[i2] = null;
                this.maxEvalIndex = i2;
            }
            if (!(this.optimData[i2] instanceof InitialGuess)) continue;
            this.optimData[i2] = null;
            this.initialGuessIndex = i2;
        }
        if (this.maxEvalIndex == -1) {
            throw new MathIllegalStateException();
        }
        if (this.initialGuessIndex == -1) {
            throw new MathIllegalStateException();
        }
        RuntimeException runtimeException = null;
        this.totalEvaluations = 0;
        this.clear();
        int n = this.getMaxEvaluations();
        double[] dArray = this.getLowerBound();
        double[] dArray2 = this.getUpperBound();
        double[] dArray3 = this.getStartPoint();
        for (int i3 = 0; i3 < this.starts; ++i3) {
            Object object;
            try {
                this.optimData[this.maxEvalIndex] = new MaxEval(n - this.totalEvaluations);
                object = null;
                if (i3 == 0) {
                    object = dArray3;
                } else {
                    int n2 = 0;
                    while (object == null) {
                        if (n2++ >= this.getMaxEvaluations()) {
                            throw new TooManyEvaluationsException(this.getMaxEvaluations());
                        }
                        object = this.generator.nextVector();
                        for (int i4 = 0; object != null && i4 < ((Object)object).length; ++i4) {
                            if (!(dArray != null && object[i4] < dArray[i4]) && (dArray2 == null || !(object[i4] > dArray2[i4]))) continue;
                            object = null;
                        }
                    }
                }
                this.optimData[this.initialGuessIndex] = new InitialGuess((double[])object);
                Object PAIR = ((BaseOptimizer)this.optimizer).optimize(this.optimData);
                this.store(PAIR);
            }
            catch (RuntimeException runtimeException2) {
                object = runtimeException2;
                runtimeException = runtimeException2;
            }
            this.totalEvaluations += this.optimizer.getEvaluations();
        }
        PAIR[] PAIRArray = this.getOptima();
        if (PAIRArray.length == 0) {
            throw runtimeException;
        }
        return PAIRArray[0];
    }

    protected abstract void store(PAIR var1);

    protected abstract void clear();
}

