/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.FixedStepHandler;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.StepHandler;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.StepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.StepNormalizerBounds;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.StepNormalizerMode;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;

public class StepNormalizer
implements StepHandler {
    private double h;
    private final FixedStepHandler handler;
    private double firstTime;
    private double lastTime;
    private double[] lastState;
    private double[] lastDerivatives;
    private boolean forward;
    private final StepNormalizerBounds bounds;
    private final StepNormalizerMode mode;

    public StepNormalizer(double d2, FixedStepHandler fixedStepHandler) {
        this(d2, fixedStepHandler, StepNormalizerMode.INCREMENT, StepNormalizerBounds.FIRST);
    }

    public StepNormalizer(double d2, FixedStepHandler fixedStepHandler, StepNormalizerMode stepNormalizerMode) {
        this(d2, fixedStepHandler, stepNormalizerMode, StepNormalizerBounds.FIRST);
    }

    public StepNormalizer(double d2, FixedStepHandler fixedStepHandler, StepNormalizerBounds stepNormalizerBounds) {
        this(d2, fixedStepHandler, StepNormalizerMode.INCREMENT, stepNormalizerBounds);
    }

    public StepNormalizer(double d2, FixedStepHandler fixedStepHandler, StepNormalizerMode stepNormalizerMode, StepNormalizerBounds stepNormalizerBounds) {
        this.h = FastMath.abs(d2);
        this.handler = fixedStepHandler;
        this.mode = stepNormalizerMode;
        this.bounds = stepNormalizerBounds;
        this.firstTime = Double.NaN;
        this.lastTime = Double.NaN;
        this.lastState = null;
        this.lastDerivatives = null;
        this.forward = true;
    }

    public void init(double d2, double[] dArray, double d3) {
        this.firstTime = Double.NaN;
        this.lastTime = Double.NaN;
        this.lastState = null;
        this.lastDerivatives = null;
        this.forward = true;
        this.handler.init(d2, dArray, d3);
    }

    public void handleStep(StepInterpolator stepInterpolator, boolean bl) {
        boolean bl2;
        double d2;
        if (this.lastState == null) {
            this.firstTime = stepInterpolator.getPreviousTime();
            this.lastTime = stepInterpolator.getPreviousTime();
            stepInterpolator.setInterpolatedTime(this.lastTime);
            this.lastState = (double[])stepInterpolator.getInterpolatedState().clone();
            this.lastDerivatives = (double[])stepInterpolator.getInterpolatedDerivatives().clone();
            boolean bl3 = this.forward = stepInterpolator.getCurrentTime() >= this.lastTime;
            if (!this.forward) {
                this.h = -this.h;
            }
        }
        double d3 = d2 = this.mode == StepNormalizerMode.INCREMENT ? this.lastTime + this.h : (FastMath.floor(this.lastTime / this.h) + 1.0) * this.h;
        if (this.mode == StepNormalizerMode.MULTIPLES && Precision.equals(d2, this.lastTime, 1)) {
            d2 += this.h;
        }
        while (bl2 = this.isNextInStep(d2, stepInterpolator)) {
            this.doNormalizedStep(false);
            this.storeStep(stepInterpolator, d2);
            d2 += this.h;
        }
        if (bl) {
            bl = this.bounds.lastIncluded() && this.lastTime != stepInterpolator.getCurrentTime();
            this.doNormalizedStep(!bl);
            if (bl) {
                StepInterpolator stepInterpolator2 = stepInterpolator;
                this.storeStep(stepInterpolator2, stepInterpolator2.getCurrentTime());
                this.doNormalizedStep(true);
            }
        }
    }

    private boolean isNextInStep(double d2, StepInterpolator stepInterpolator) {
        if (this.forward) {
            return d2 <= stepInterpolator.getCurrentTime();
        }
        return d2 >= stepInterpolator.getCurrentTime();
    }

    private void doNormalizedStep(boolean bl) {
        if (!this.bounds.firstIncluded() && this.firstTime == this.lastTime) {
            return;
        }
        this.handler.handleStep(this.lastTime, this.lastState, this.lastDerivatives, bl);
    }

    private void storeStep(StepInterpolator stepInterpolator, double d2) {
        this.lastTime = d2;
        stepInterpolator.setInterpolatedTime(this.lastTime);
        System.arraycopy(stepInterpolator.getInterpolatedState(), 0, this.lastState, 0, this.lastState.length);
        System.arraycopy(stepInterpolator.getInterpolatedDerivatives(), 0, this.lastDerivatives, 0, this.lastDerivatives.length);
    }
}

