/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.EquationsMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.AbstractStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.StepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

public class NordsieckStepInterpolator
extends AbstractStepInterpolator {
    private static final long serialVersionUID = -7179861704951334960L;
    protected double[] stateVariation;
    private double scalingH;
    private double referenceTime;
    private double[] scaled;
    private Array2DRowRealMatrix nordsieck;

    public NordsieckStepInterpolator() {
    }

    public NordsieckStepInterpolator(NordsieckStepInterpolator nordsieckStepInterpolator) {
        super(nordsieckStepInterpolator);
        this.scalingH = nordsieckStepInterpolator.scalingH;
        this.referenceTime = nordsieckStepInterpolator.referenceTime;
        if (nordsieckStepInterpolator.scaled != null) {
            this.scaled = (double[])nordsieckStepInterpolator.scaled.clone();
        }
        if (nordsieckStepInterpolator.nordsieck != null) {
            this.nordsieck = new Array2DRowRealMatrix(nordsieckStepInterpolator.nordsieck.getDataRef(), true);
        }
        if (nordsieckStepInterpolator.stateVariation != null) {
            this.stateVariation = (double[])nordsieckStepInterpolator.stateVariation.clone();
        }
    }

    protected StepInterpolator doCopy() {
        return new NordsieckStepInterpolator(this);
    }

    public void reinitialize(double[] dArray, boolean bl, EquationsMapper equationsMapper, EquationsMapper[] equationsMapperArray) {
        super.reinitialize(dArray, bl, equationsMapper, equationsMapperArray);
        this.stateVariation = new double[dArray.length];
    }

    public void reinitialize(double d2, double d3, double[] dArray, Array2DRowRealMatrix array2DRowRealMatrix) {
        this.referenceTime = d2;
        this.scalingH = d3;
        this.scaled = dArray;
        this.nordsieck = array2DRowRealMatrix;
        NordsieckStepInterpolator nordsieckStepInterpolator = this;
        nordsieckStepInterpolator.setInterpolatedTime(nordsieckStepInterpolator.getInterpolatedTime());
    }

    public void rescale(double d2) {
        double d3 = d2 / this.scalingH;
        int n = 0;
        while (n < this.scaled.length) {
            int n2 = n++;
            this.scaled[n2] = this.scaled[n2] * d3;
        }
        double[][] dArray = this.nordsieck.getDataRef();
        double d4 = d3;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d4 *= d3;
            double[] dArray2 = dArray[i2];
            int n3 = 0;
            while (n3 < dArray2.length) {
                int n4 = n3++;
                dArray2[n4] = dArray2[n4] * d4;
            }
        }
        this.scalingH = d2;
    }

    public double[] getInterpolatedStateVariation() {
        this.getInterpolatedState();
        return this.stateVariation;
    }

    protected void computeInterpolatedStateAndDerivatives(double d2, double d3) {
        int n;
        double d4 = this.interpolatedTime - this.referenceTime;
        double d5 = d4 / this.scalingH;
        Arrays.fill(this.stateVariation, 0.0);
        Arrays.fill(this.interpolatedDerivatives, 0.0);
        double[][] dArray = this.nordsieck.getDataRef();
        for (n = dArray.length - 1; n >= 0; --n) {
            int n2 = n + 2;
            double[] dArray2 = dArray[n];
            double d6 = FastMath.pow(d5, n2);
            int n3 = 0;
            while (n3 < dArray2.length) {
                double d7 = dArray2[n3] * d6;
                int n4 = n3;
                this.stateVariation[n4] = this.stateVariation[n4] + d7;
                int n5 = n3++;
                this.interpolatedDerivatives[n5] = this.interpolatedDerivatives[n5] + (double)n2 * d7;
            }
        }
        for (n = 0; n < this.currentState.length; ++n) {
            int n6 = n;
            this.stateVariation[n6] = this.stateVariation[n6] + this.scaled[n] * d5;
            this.interpolatedState[n] = this.currentState[n] + this.stateVariation[n];
            this.interpolatedDerivatives[n] = (this.interpolatedDerivatives[n] + this.scaled[n] * d5) / d4;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) {
        int n;
        this.writeBaseExternal(objectOutput);
        objectOutput.writeDouble(this.scalingH);
        objectOutput.writeDouble(this.referenceTime);
        int n2 = n = this.currentState == null ? -1 : this.currentState.length;
        if (this.scaled == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            for (int i2 = 0; i2 < n; ++i2) {
                objectOutput.writeDouble(this.scaled[i2]);
            }
        }
        if (this.nordsieck == null) {
            objectOutput.writeBoolean(false);
            return;
        }
        objectOutput.writeBoolean(true);
        objectOutput.writeObject(this.nordsieck);
    }

    public void readExternal(ObjectInput objectInput) {
        int n;
        double d2 = this.readBaseExternal(objectInput);
        this.scalingH = objectInput.readDouble();
        this.referenceTime = objectInput.readDouble();
        int n2 = this.currentState == null ? -1 : this.currentState.length;
        boolean bl = objectInput.readBoolean();
        if (bl) {
            this.scaled = new double[n2];
            for (n = 0; n < n2; ++n) {
                this.scaled[n] = objectInput.readDouble();
            }
        } else {
            this.scaled = null;
        }
        this.nordsieck = (n = objectInput.readBoolean()) != 0 ? (Array2DRowRealMatrix)objectInput.readObject() : null;
        if (bl && n != 0) {
            this.stateVariation = new double[n2];
            this.setInterpolatedTime(d2);
            return;
        }
        this.stateVariation = null;
    }
}

