/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEStateAndDerivative;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.FieldFixedStepHandler;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.FieldStepHandler;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.FieldStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.StepNormalizerBounds;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.StepNormalizerMode;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldStepNormalizer<T extends RealFieldElement<T>>
implements FieldStepHandler<T> {
    private double h;
    private final FieldFixedStepHandler<T> handler;
    private FieldODEStateAndDerivative<T> first;
    private FieldODEStateAndDerivative<T> last;
    private boolean forward;
    private final StepNormalizerBounds bounds;
    private final StepNormalizerMode mode;

    public FieldStepNormalizer(double d2, FieldFixedStepHandler<T> fieldFixedStepHandler) {
        this(d2, fieldFixedStepHandler, StepNormalizerMode.INCREMENT, StepNormalizerBounds.FIRST);
    }

    public FieldStepNormalizer(double d2, FieldFixedStepHandler<T> fieldFixedStepHandler, StepNormalizerMode stepNormalizerMode) {
        this(d2, fieldFixedStepHandler, stepNormalizerMode, StepNormalizerBounds.FIRST);
    }

    public FieldStepNormalizer(double d2, FieldFixedStepHandler<T> fieldFixedStepHandler, StepNormalizerBounds stepNormalizerBounds) {
        this(d2, fieldFixedStepHandler, StepNormalizerMode.INCREMENT, stepNormalizerBounds);
    }

    public FieldStepNormalizer(double d2, FieldFixedStepHandler<T> fieldFixedStepHandler, StepNormalizerMode stepNormalizerMode, StepNormalizerBounds stepNormalizerBounds) {
        this.h = FastMath.abs(d2);
        this.handler = fieldFixedStepHandler;
        this.mode = stepNormalizerMode;
        this.bounds = stepNormalizerBounds;
        this.first = null;
        this.last = null;
        this.forward = true;
    }

    @Override
    public void init(FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, T t) {
        this.first = null;
        this.last = null;
        this.forward = true;
        this.handler.init(fieldODEStateAndDerivative, t);
    }

    @Override
    public void handleStep(FieldStepInterpolator<T> fieldStepInterpolator, boolean bl) {
        boolean bl2;
        RealFieldElement realFieldElement;
        if (this.last == null) {
            this.first = fieldStepInterpolator.getPreviousState();
            this.last = this.first;
            this.forward = fieldStepInterpolator.isForward();
            if (!this.forward) {
                this.h = -this.h;
            }
        }
        RealFieldElement realFieldElement2 = realFieldElement = this.mode == StepNormalizerMode.INCREMENT ? (RealFieldElement)this.last.getTime().add(this.h) : (RealFieldElement)((RealFieldElement)this.last.getTime().getField().getZero()).add((FastMath.floor(this.last.getTime().getReal() / this.h) + 1.0) * this.h);
        if (this.mode == StepNormalizerMode.MULTIPLES && Precision.equals(realFieldElement.getReal(), this.last.getTime().getReal(), 1)) {
            realFieldElement = (RealFieldElement)realFieldElement.add(this.h);
        }
        while (bl2 = this.isNextInStep(realFieldElement, fieldStepInterpolator)) {
            this.doNormalizedStep(false);
            this.last = fieldStepInterpolator.getInterpolatedState(realFieldElement);
            realFieldElement = (RealFieldElement)realFieldElement.add(this.h);
        }
        if (bl) {
            bl = this.bounds.lastIncluded() && this.last.getTime().getReal() != fieldStepInterpolator.getCurrentState().getTime().getReal();
            this.doNormalizedStep(!bl);
            if (bl) {
                this.last = fieldStepInterpolator.getCurrentState();
                this.doNormalizedStep(true);
            }
        }
    }

    private boolean isNextInStep(T t, FieldStepInterpolator<T> fieldStepInterpolator) {
        if (this.forward) {
            return t.getReal() <= fieldStepInterpolator.getCurrentState().getTime().getReal();
        }
        return t.getReal() >= fieldStepInterpolator.getCurrentState().getTime().getReal();
    }

    private void doNormalizedStep(boolean bl) {
        if (!this.bounds.firstIncluded() && this.first.getTime().getReal() == this.last.getTime().getReal()) {
            return;
        }
        this.handler.handleStep(this.last, bl);
    }
}

