/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MaxCountExceededException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.EquationsMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.StepInterpolator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AbstractStepInterpolator
implements StepInterpolator {
    protected double h;
    protected double[] currentState;
    protected double interpolatedTime;
    protected double[] interpolatedState;
    protected double[] interpolatedDerivatives;
    protected double[] interpolatedPrimaryState;
    protected double[] interpolatedPrimaryDerivatives;
    protected double[][] interpolatedSecondaryState;
    protected double[][] interpolatedSecondaryDerivatives;
    private double globalPreviousTime;
    private double globalCurrentTime;
    private double softPreviousTime;
    private double softCurrentTime;
    private boolean finalized;
    private boolean forward;
    private boolean dirtyState;
    private EquationsMapper primaryMapper;
    private EquationsMapper[] secondaryMappers;

    protected AbstractStepInterpolator() {
        this.globalPreviousTime = Double.NaN;
        this.globalCurrentTime = Double.NaN;
        this.softPreviousTime = Double.NaN;
        this.softCurrentTime = Double.NaN;
        this.h = Double.NaN;
        this.interpolatedTime = Double.NaN;
        this.currentState = null;
        this.finalized = false;
        this.forward = true;
        this.dirtyState = true;
        this.primaryMapper = null;
        this.secondaryMappers = null;
        this.allocateInterpolatedArrays(-1);
    }

    protected AbstractStepInterpolator(double[] dArray, boolean bl, EquationsMapper equationsMapper, EquationsMapper[] equationsMapperArray) {
        this.globalPreviousTime = Double.NaN;
        this.globalCurrentTime = Double.NaN;
        this.softPreviousTime = Double.NaN;
        this.softCurrentTime = Double.NaN;
        this.h = Double.NaN;
        this.interpolatedTime = Double.NaN;
        this.currentState = dArray;
        this.finalized = false;
        this.forward = bl;
        this.dirtyState = true;
        this.primaryMapper = equationsMapper;
        this.secondaryMappers = equationsMapperArray == null ? null : (EquationsMapper[])equationsMapperArray.clone();
        this.allocateInterpolatedArrays(dArray.length);
    }

    protected AbstractStepInterpolator(AbstractStepInterpolator abstractStepInterpolator) {
        this.globalPreviousTime = abstractStepInterpolator.globalPreviousTime;
        this.globalCurrentTime = abstractStepInterpolator.globalCurrentTime;
        this.softPreviousTime = abstractStepInterpolator.softPreviousTime;
        this.softCurrentTime = abstractStepInterpolator.softCurrentTime;
        this.h = abstractStepInterpolator.h;
        this.interpolatedTime = abstractStepInterpolator.interpolatedTime;
        if (abstractStepInterpolator.currentState == null) {
            this.currentState = null;
            this.primaryMapper = null;
            this.secondaryMappers = null;
            this.allocateInterpolatedArrays(-1);
        } else {
            this.currentState = (double[])abstractStepInterpolator.currentState.clone();
            this.interpolatedState = (double[])abstractStepInterpolator.interpolatedState.clone();
            this.interpolatedDerivatives = (double[])abstractStepInterpolator.interpolatedDerivatives.clone();
            this.interpolatedPrimaryState = (double[])abstractStepInterpolator.interpolatedPrimaryState.clone();
            this.interpolatedPrimaryDerivatives = (double[])abstractStepInterpolator.interpolatedPrimaryDerivatives.clone();
            this.interpolatedSecondaryState = new double[abstractStepInterpolator.interpolatedSecondaryState.length][];
            this.interpolatedSecondaryDerivatives = new double[abstractStepInterpolator.interpolatedSecondaryDerivatives.length][];
            for (int i2 = 0; i2 < this.interpolatedSecondaryState.length; ++i2) {
                this.interpolatedSecondaryState[i2] = (double[])abstractStepInterpolator.interpolatedSecondaryState[i2].clone();
                this.interpolatedSecondaryDerivatives[i2] = (double[])abstractStepInterpolator.interpolatedSecondaryDerivatives[i2].clone();
            }
        }
        this.finalized = abstractStepInterpolator.finalized;
        this.forward = abstractStepInterpolator.forward;
        this.dirtyState = abstractStepInterpolator.dirtyState;
        this.primaryMapper = abstractStepInterpolator.primaryMapper;
        this.secondaryMappers = abstractStepInterpolator.secondaryMappers == null ? null : (EquationsMapper[])abstractStepInterpolator.secondaryMappers.clone();
    }

    private void allocateInterpolatedArrays(int n) {
        if (n < 0) {
            this.interpolatedState = null;
            this.interpolatedDerivatives = null;
            this.interpolatedPrimaryState = null;
            this.interpolatedPrimaryDerivatives = null;
            this.interpolatedSecondaryState = null;
            this.interpolatedSecondaryDerivatives = null;
            return;
        }
        this.interpolatedState = new double[n];
        this.interpolatedDerivatives = new double[n];
        this.interpolatedPrimaryState = new double[this.primaryMapper.getDimension()];
        this.interpolatedPrimaryDerivatives = new double[this.primaryMapper.getDimension()];
        if (this.secondaryMappers == null) {
            this.interpolatedSecondaryState = null;
            this.interpolatedSecondaryDerivatives = null;
            return;
        }
        this.interpolatedSecondaryState = new double[this.secondaryMappers.length][];
        this.interpolatedSecondaryDerivatives = new double[this.secondaryMappers.length][];
        for (n = 0; n < this.secondaryMappers.length; ++n) {
            this.interpolatedSecondaryState[n] = new double[this.secondaryMappers[n].getDimension()];
            this.interpolatedSecondaryDerivatives[n] = new double[this.secondaryMappers[n].getDimension()];
        }
    }

    protected void reinitialize(double[] dArray, boolean bl, EquationsMapper equationsMapper, EquationsMapper[] equationsMapperArray) {
        this.globalPreviousTime = Double.NaN;
        this.globalCurrentTime = Double.NaN;
        this.softPreviousTime = Double.NaN;
        this.softCurrentTime = Double.NaN;
        this.h = Double.NaN;
        this.interpolatedTime = Double.NaN;
        this.currentState = dArray;
        this.finalized = false;
        this.forward = bl;
        this.dirtyState = true;
        this.primaryMapper = equationsMapper;
        this.secondaryMappers = (EquationsMapper[])equationsMapperArray.clone();
        this.allocateInterpolatedArrays(dArray.length);
    }

    public StepInterpolator copy() {
        this.finalizeStep();
        return this.doCopy();
    }

    protected abstract StepInterpolator doCopy();

    public void shift() {
        this.softPreviousTime = this.globalPreviousTime = this.globalCurrentTime;
        this.softCurrentTime = this.globalCurrentTime;
    }

    public void storeTime(double d2) {
        this.softCurrentTime = this.globalCurrentTime = d2;
        this.h = this.globalCurrentTime - this.globalPreviousTime;
        this.setInterpolatedTime(d2);
        this.finalized = false;
    }

    public void setSoftPreviousTime(double d2) {
        this.softPreviousTime = d2;
    }

    public void setSoftCurrentTime(double d2) {
        this.softCurrentTime = d2;
    }

    public double getGlobalPreviousTime() {
        return this.globalPreviousTime;
    }

    public double getGlobalCurrentTime() {
        return this.globalCurrentTime;
    }

    public double getPreviousTime() {
        return this.softPreviousTime;
    }

    public double getCurrentTime() {
        return this.softCurrentTime;
    }

    public double getInterpolatedTime() {
        return this.interpolatedTime;
    }

    public void setInterpolatedTime(double d2) {
        this.interpolatedTime = d2;
        this.dirtyState = true;
    }

    public boolean isForward() {
        return this.forward;
    }

    protected abstract void computeInterpolatedStateAndDerivatives(double var1, double var3);

    private void evaluateCompleteInterpolatedState() {
        if (this.dirtyState) {
            double d2 = this.globalCurrentTime - this.interpolatedTime;
            double d3 = this.h == 0.0 ? 0.0 : (this.h - d2) / this.h;
            this.computeInterpolatedStateAndDerivatives(d3, d2);
            this.dirtyState = false;
        }
    }

    public double[] getInterpolatedState() {
        this.evaluateCompleteInterpolatedState();
        this.primaryMapper.extractEquationData(this.interpolatedState, this.interpolatedPrimaryState);
        return this.interpolatedPrimaryState;
    }

    public double[] getInterpolatedDerivatives() {
        this.evaluateCompleteInterpolatedState();
        this.primaryMapper.extractEquationData(this.interpolatedDerivatives, this.interpolatedPrimaryDerivatives);
        return this.interpolatedPrimaryDerivatives;
    }

    public double[] getInterpolatedSecondaryState(int n) {
        this.evaluateCompleteInterpolatedState();
        this.secondaryMappers[n].extractEquationData(this.interpolatedState, this.interpolatedSecondaryState[n]);
        return this.interpolatedSecondaryState[n];
    }

    public double[] getInterpolatedSecondaryDerivatives(int n) {
        this.evaluateCompleteInterpolatedState();
        this.secondaryMappers[n].extractEquationData(this.interpolatedDerivatives, this.interpolatedSecondaryDerivatives[n]);
        return this.interpolatedSecondaryDerivatives[n];
    }

    public final void finalizeStep() {
        if (!this.finalized) {
            this.doFinalize();
            this.finalized = true;
        }
    }

    protected void doFinalize() {
    }

    public abstract void writeExternal(ObjectOutput var1);

    public abstract void readExternal(ObjectInput var1);

    protected void writeBaseExternal(ObjectOutput objectOutput) {
        if (this.currentState == null) {
            objectOutput.writeInt(-1);
        } else {
            objectOutput.writeInt(this.currentState.length);
        }
        objectOutput.writeDouble(this.globalPreviousTime);
        objectOutput.writeDouble(this.globalCurrentTime);
        objectOutput.writeDouble(this.softPreviousTime);
        objectOutput.writeDouble(this.softCurrentTime);
        objectOutput.writeDouble(this.h);
        objectOutput.writeBoolean(this.forward);
        objectOutput.writeObject(this.primaryMapper);
        objectOutput.write(this.secondaryMappers.length);
        EquationsMapper[] equationsMapperArray = this.secondaryMappers;
        int n = this.secondaryMappers.length;
        for (int i2 = 0; i2 < n; ++i2) {
            EquationsMapper equationsMapper = equationsMapperArray[i2];
            objectOutput.writeObject(equationsMapper);
        }
        if (this.currentState != null) {
            for (int i3 = 0; i3 < this.currentState.length; ++i3) {
                objectOutput.writeDouble(this.currentState[i3]);
            }
        }
        objectOutput.writeDouble(this.interpolatedTime);
        try {
            this.finalizeStep();
            return;
        }
        catch (MaxCountExceededException maxCountExceededException) {
            IOException iOException = new IOException(maxCountExceededException.getLocalizedMessage());
            iOException.initCause(maxCountExceededException);
            throw iOException;
        }
    }

    protected double readBaseExternal(ObjectInput objectInput) {
        int n;
        int n2 = objectInput.readInt();
        this.globalPreviousTime = objectInput.readDouble();
        this.globalCurrentTime = objectInput.readDouble();
        this.softPreviousTime = objectInput.readDouble();
        this.softCurrentTime = objectInput.readDouble();
        this.h = objectInput.readDouble();
        this.forward = objectInput.readBoolean();
        this.primaryMapper = (EquationsMapper)objectInput.readObject();
        this.secondaryMappers = new EquationsMapper[objectInput.read()];
        for (n = 0; n < this.secondaryMappers.length; ++n) {
            this.secondaryMappers[n] = (EquationsMapper)objectInput.readObject();
        }
        this.dirtyState = true;
        if (n2 < 0) {
            this.currentState = null;
        } else {
            this.currentState = new double[n2];
            for (n = 0; n < this.currentState.length; ++n) {
                this.currentState[n] = objectInput.readDouble();
            }
        }
        this.interpolatedTime = Double.NaN;
        this.allocateInterpolatedArrays(n2);
        this.finalized = true;
        return objectInput.readDouble();
    }
}

