/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldEquationsMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEStateAndDerivative;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.FieldStepInterpolator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFieldStepInterpolator<T extends RealFieldElement<T>>
implements FieldStepInterpolator<T> {
    private final FieldODEStateAndDerivative<T> globalPreviousState;
    private final FieldODEStateAndDerivative<T> globalCurrentState;
    private final FieldODEStateAndDerivative<T> softPreviousState;
    private final FieldODEStateAndDerivative<T> softCurrentState;
    private final boolean forward;
    private FieldEquationsMapper<T> mapper;

    protected AbstractFieldStepInterpolator(boolean bl, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative3, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative4, FieldEquationsMapper<T> fieldEquationsMapper) {
        this.forward = bl;
        this.globalPreviousState = fieldODEStateAndDerivative;
        this.globalCurrentState = fieldODEStateAndDerivative2;
        this.softPreviousState = fieldODEStateAndDerivative3;
        this.softCurrentState = fieldODEStateAndDerivative4;
        this.mapper = fieldEquationsMapper;
    }

    public AbstractFieldStepInterpolator<T> restrictStep(FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2) {
        AbstractFieldStepInterpolator abstractFieldStepInterpolator = this;
        return abstractFieldStepInterpolator.create(abstractFieldStepInterpolator.forward, this.globalPreviousState, this.globalCurrentState, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, this.mapper);
    }

    protected abstract AbstractFieldStepInterpolator<T> create(boolean var1, FieldODEStateAndDerivative<T> var2, FieldODEStateAndDerivative<T> var3, FieldODEStateAndDerivative<T> var4, FieldODEStateAndDerivative<T> var5, FieldEquationsMapper<T> var6);

    public FieldODEStateAndDerivative<T> getGlobalPreviousState() {
        return this.globalPreviousState;
    }

    public FieldODEStateAndDerivative<T> getGlobalCurrentState() {
        return this.globalCurrentState;
    }

    @Override
    public FieldODEStateAndDerivative<T> getPreviousState() {
        return this.softPreviousState;
    }

    @Override
    public FieldODEStateAndDerivative<T> getCurrentState() {
        return this.softCurrentState;
    }

    @Override
    public FieldODEStateAndDerivative<T> getInterpolatedState(T t) {
        RealFieldElement realFieldElement = (RealFieldElement)t.subtract(this.globalPreviousState.getTime());
        RealFieldElement realFieldElement2 = (RealFieldElement)this.globalCurrentState.getTime().subtract(t);
        RealFieldElement realFieldElement3 = (RealFieldElement)realFieldElement.divide(this.globalCurrentState.getTime().subtract(this.globalPreviousState.getTime()));
        AbstractFieldStepInterpolator abstractFieldStepInterpolator = this;
        return abstractFieldStepInterpolator.computeInterpolatedStateAndDerivatives(abstractFieldStepInterpolator.mapper, t, realFieldElement3, realFieldElement, realFieldElement2);
    }

    @Override
    public boolean isForward() {
        return this.forward;
    }

    protected abstract FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> var1, T var2, T var3, T var4, T var5);
}

