/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.AbstractIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.EquationsMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.AbstractStepInterpolator;
import java.io.ObjectInput;
import java.io.ObjectOutput;

abstract class RungeKuttaStepInterpolator
extends AbstractStepInterpolator {
    protected double[] previousState;
    protected double[][] yDotK;
    protected AbstractIntegrator integrator;

    protected RungeKuttaStepInterpolator() {
        this.previousState = null;
        this.yDotK = null;
        this.integrator = null;
    }

    RungeKuttaStepInterpolator(RungeKuttaStepInterpolator rungeKuttaStepInterpolator) {
        super(rungeKuttaStepInterpolator);
        if (rungeKuttaStepInterpolator.currentState != null) {
            this.previousState = (double[])rungeKuttaStepInterpolator.previousState.clone();
            this.yDotK = new double[rungeKuttaStepInterpolator.yDotK.length][];
            for (int i2 = 0; i2 < rungeKuttaStepInterpolator.yDotK.length; ++i2) {
                this.yDotK[i2] = (double[])rungeKuttaStepInterpolator.yDotK[i2].clone();
            }
        } else {
            this.previousState = null;
            this.yDotK = null;
        }
        this.integrator = null;
    }

    public void reinitialize(AbstractIntegrator abstractIntegrator, double[] dArray, double[][] dArray2, boolean bl, EquationsMapper equationsMapper, EquationsMapper[] equationsMapperArray) {
        this.reinitialize(dArray, bl, equationsMapper, equationsMapperArray);
        this.previousState = null;
        this.yDotK = dArray2;
        this.integrator = abstractIntegrator;
    }

    public void shift() {
        this.previousState = (double[])this.currentState.clone();
        super.shift();
    }

    public void writeExternal(ObjectOutput objectOutput) {
        int n;
        this.writeBaseExternal(objectOutput);
        int n2 = this.currentState == null ? -1 : this.currentState.length;
        for (n = 0; n < n2; ++n) {
            objectOutput.writeDouble(this.previousState[n]);
        }
        n = this.yDotK == null ? -1 : this.yDotK.length;
        objectOutput.writeInt(n);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                objectOutput.writeDouble(this.yDotK[i2][i3]);
            }
        }
    }

    public void readExternal(ObjectInput objectInput) {
        int n;
        double d2 = this.readBaseExternal(objectInput);
        int n2 = this.currentState == null ? -1 : this.currentState.length;
        if (n2 < 0) {
            this.previousState = null;
        } else {
            this.previousState = new double[n2];
            for (n = 0; n < n2; ++n) {
                this.previousState[n] = objectInput.readDouble();
            }
        }
        n = objectInput.readInt();
        this.yDotK = n < 0 ? null : new double[n][];
        for (int i2 = 0; i2 < n; ++i2) {
            this.yDotK[i2] = n2 < 0 ? null : new double[n2];
            for (int i3 = 0; i3 < n2; ++i3) {
                this.yDotK[i2][i3] = objectInput.readDouble();
            }
        }
        this.integrator = null;
        if (this.currentState != null) {
            this.setInterpolatedTime(d2);
            return;
        }
        this.interpolatedTime = d2;
    }
}

