/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.AbstractIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.ExpandableStatefulODE;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.AbstractStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public abstract class RungeKuttaIntegrator
extends AbstractIntegrator {
    private final double[] c;
    private final double[][] a;
    private final double[] b;
    private final RungeKuttaStepInterpolator prototype;
    private final double step;

    protected RungeKuttaIntegrator(String string, double[] dArray, double[][] dArray2, double[] dArray3, RungeKuttaStepInterpolator rungeKuttaStepInterpolator, double d2) {
        super(string);
        this.c = dArray;
        this.a = dArray2;
        this.b = dArray3;
        this.prototype = rungeKuttaStepInterpolator;
        this.step = FastMath.abs(d2);
    }

    public void integrate(ExpandableStatefulODE expandableStatefulODE, double d2) {
        this.sanityChecks(expandableStatefulODE, d2);
        this.setEquations(expandableStatefulODE);
        boolean bl = d2 > expandableStatefulODE.getTime();
        double[] dArray = expandableStatefulODE.getCompleteState();
        double[] dArray2 = (double[])dArray.clone();
        int n = this.c.length + 1;
        double[][] dArrayArray = new double[n][];
        for (int i2 = 0; i2 < n; ++i2) {
            dArrayArray[i2] = new double[dArray.length];
        }
        double[] dArray3 = (double[])dArray.clone();
        double[] dArray4 = new double[dArray.length];
        RungeKuttaStepInterpolator rungeKuttaStepInterpolator = (RungeKuttaStepInterpolator)this.prototype.copy();
        rungeKuttaStepInterpolator.reinitialize(this, dArray3, dArrayArray, bl, expandableStatefulODE.getPrimaryMapper(), expandableStatefulODE.getSecondaryMappers());
        rungeKuttaStepInterpolator.storeTime(expandableStatefulODE.getTime());
        this.stepStart = expandableStatefulODE.getTime();
        this.stepSize = bl ? (this.stepStart + this.step >= d2 ? d2 - this.stepStart : this.step) : (this.stepStart - this.step <= d2 ? d2 - this.stepStart : -this.step);
        this.initIntegration(expandableStatefulODE.getTime(), dArray, d2);
        this.isLastStep = false;
        do {
            boolean bl2;
            int n2;
            ((AbstractStepInterpolator)rungeKuttaStepInterpolator).shift();
            RungeKuttaIntegrator rungeKuttaIntegrator = this;
            rungeKuttaIntegrator.computeDerivatives(rungeKuttaIntegrator.stepStart, dArray2, dArrayArray[0]);
            for (n2 = 1; n2 < n; ++n2) {
                for (int i3 = 0; i3 < dArray.length; ++i3) {
                    double d3 = this.a[n2 - 1][0] * dArrayArray[0][i3];
                    for (int i4 = 1; i4 < n2; ++i4) {
                        d3 += this.a[n2 - 1][i4] * dArrayArray[i4][i3];
                    }
                    dArray3[i3] = dArray2[i3] + this.stepSize * d3;
                }
                RungeKuttaIntegrator rungeKuttaIntegrator2 = this;
                rungeKuttaIntegrator2.computeDerivatives(rungeKuttaIntegrator2.stepStart + this.c[n2 - 1] * this.stepSize, dArray3, dArrayArray[n2]);
            }
            for (n2 = 0; n2 < dArray.length; ++n2) {
                double d4 = this.b[0] * dArrayArray[0][n2];
                for (int i5 = 1; i5 < n; ++i5) {
                    d4 += this.b[i5] * dArrayArray[i5][n2];
                }
                dArray3[n2] = dArray2[n2] + this.stepSize * d4;
            }
            rungeKuttaStepInterpolator.storeTime(this.stepStart + this.stepSize);
            System.arraycopy(dArray3, 0, dArray2, 0, dArray.length);
            System.arraycopy(dArrayArray[n - 1], 0, dArray4, 0, dArray.length);
            this.stepStart = this.acceptStep(rungeKuttaStepInterpolator, dArray2, dArray4, d2);
            if (this.isLastStep) continue;
            rungeKuttaStepInterpolator.storeTime(this.stepStart);
            double d5 = this.stepStart + this.stepSize;
            boolean bl3 = bl ? d5 >= d2 : (bl2 = d5 <= d2);
            if (!bl3) continue;
            this.stepSize = d2 - this.stepStart;
        } while (!this.isLastStep);
        expandableStatefulODE.setTime(this.stepStart);
        expandableStatefulODE.setCompleteState(dArray2);
        this.stepStart = Double.NaN;
        this.stepSize = Double.NaN;
    }

    public double[] singleStep(FirstOrderDifferentialEquations firstOrderDifferentialEquations, double d2, double[] dArray, double d3) {
        int n;
        double[] dArray2 = (double[])dArray.clone();
        int n2 = this.c.length + 1;
        double[][] dArrayArray = new double[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArrayArray[i2] = new double[dArray.length];
        }
        double[] dArray3 = (double[])dArray.clone();
        double d4 = d3 - d2;
        firstOrderDifferentialEquations.computeDerivatives(d2, dArray2, dArrayArray[0]);
        for (n = 1; n < n2; ++n) {
            for (int i3 = 0; i3 < dArray.length; ++i3) {
                double d5 = this.a[n - 1][0] * dArrayArray[0][i3];
                for (int i4 = 1; i4 < n; ++i4) {
                    d5 += this.a[n - 1][i4] * dArrayArray[i4][i3];
                }
                dArray3[i3] = dArray2[i3] + d4 * d5;
            }
            firstOrderDifferentialEquations.computeDerivatives(d2 + this.c[n - 1] * d4, dArray3, dArrayArray[n]);
        }
        n = 0;
        while (n < dArray.length) {
            double d6 = this.b[0] * dArrayArray[0][n];
            for (int i5 = 1; i5 < n2; ++i5) {
                d6 += this.b[i5] * dArrayArray[i5][n];
            }
            int n3 = n++;
            dArray2[n3] = dArray2[n3] + d4 * d6;
        }
        return dArray2;
    }
}

