/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.AbstractFieldIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldEquationsMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldExpandableODE;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEState;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEStateAndDerivative;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FirstOrderFieldDifferentialEquations;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.FieldButcherArrayProvider;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.RungeKuttaFieldStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RungeKuttaFieldIntegrator<T extends RealFieldElement<T>>
extends AbstractFieldIntegrator<T>
implements FieldButcherArrayProvider<T> {
    private final T[] c = this.getC();
    private final T[][] a = this.getA();
    private final T[] b = this.getB();
    private final T step;

    protected RungeKuttaFieldIntegrator(Field<T> field, String string, T t) {
        super(field, string);
        this.step = (RealFieldElement)t.abs();
    }

    protected T fraction(int n, int n2) {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.getField().getZero()).add(n)).divide(n2));
    }

    protected abstract RungeKuttaFieldStepInterpolator<T> createInterpolator(boolean var1, T[][] var2, FieldODEStateAndDerivative<T> var3, FieldODEStateAndDerivative<T> var4, FieldEquationsMapper<T> var5);

    @Override
    public FieldODEStateAndDerivative<T> integrate(FieldExpandableODE<T> fieldExpandableODE, FieldODEState<T> fieldODEState, T t) {
        Object object;
        this.sanityChecks(fieldODEState, t);
        T t2 = fieldODEState.getTime();
        RealFieldElement[] realFieldElementArray = fieldExpandableODE.getMapper().mapState(fieldODEState);
        RungeKuttaFieldIntegrator rungeKuttaFieldIntegrator = this;
        rungeKuttaFieldIntegrator.setStepStart(rungeKuttaFieldIntegrator.initIntegration(fieldExpandableODE, (RealFieldElement)t2, realFieldElementArray, (RealFieldElement)t));
        boolean bl = ((RealFieldElement)t.subtract(fieldODEState.getTime())).getReal() > 0.0;
        int n = this.c.length + 1;
        RealFieldElement[][] realFieldElementArray2 = (RealFieldElement[][])MathArrays.buildArray(this.getField(), n, -1);
        RealFieldElement[] realFieldElementArray3 = (RealFieldElement[])MathArrays.buildArray(this.getField(), realFieldElementArray.length);
        if (bl) {
            if (((RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.step)).subtract(t)).getReal() >= 0.0) {
                this.setStepSize((RealFieldElement)t.subtract(this.getStepStart().getTime()));
            } else {
                RungeKuttaFieldIntegrator rungeKuttaFieldIntegrator2 = this;
                rungeKuttaFieldIntegrator2.setStepSize(rungeKuttaFieldIntegrator2.step);
            }
        } else if (((RealFieldElement)((RealFieldElement)this.getStepStart().getTime().subtract(this.step)).subtract(t)).getReal() <= 0.0) {
            this.setStepSize((RealFieldElement)t.subtract(this.getStepStart().getTime()));
        } else {
            RungeKuttaFieldIntegrator rungeKuttaFieldIntegrator3 = this;
            rungeKuttaFieldIntegrator3.setStepSize((RealFieldElement)rungeKuttaFieldIntegrator3.step.negate());
        }
        this.setIsLastStep(false);
        do {
            boolean bl2;
            Object object2;
            int n2;
            RealFieldElement[] realFieldElementArray4 = fieldExpandableODE.getMapper().mapState(this.getStepStart());
            realFieldElementArray2[0] = fieldExpandableODE.getMapper().mapDerivative(this.getStepStart());
            for (n2 = 1; n2 < n; ++n2) {
                for (int i2 = 0; i2 < realFieldElementArray.length; ++i2) {
                    object2 = (RealFieldElement)realFieldElementArray2[0][i2].multiply(this.a[n2 - 1][0]);
                    for (int i3 = 1; i3 < n2; ++i3) {
                        object2 = (RealFieldElement)object2.add(realFieldElementArray2[i3][i2].multiply(this.a[n2 - 1][i3]));
                    }
                    realFieldElementArray3[i2] = (RealFieldElement)realFieldElementArray4[i2].add(this.getStepSize().multiply((Object)object2));
                }
                RungeKuttaFieldIntegrator rungeKuttaFieldIntegrator4 = this;
                realFieldElementArray2[n2] = rungeKuttaFieldIntegrator4.computeDerivatives((RealFieldElement)rungeKuttaFieldIntegrator4.getStepStart().getTime().add(this.getStepSize().multiply(this.c[n2 - 1])), realFieldElementArray3);
            }
            for (n2 = 0; n2 < realFieldElementArray.length; ++n2) {
                RealFieldElement realFieldElement = (RealFieldElement)realFieldElementArray2[0][n2].multiply(this.b[0]);
                for (int i4 = 1; i4 < n; ++i4) {
                    realFieldElement = (RealFieldElement)realFieldElement.add(realFieldElementArray2[i4][n2].multiply(this.b[i4]));
                }
                realFieldElementArray3[n2] = realFieldElementArray4[n2].add(this.getStepSize().multiply((RealFieldElement)realFieldElement));
            }
            object = (RealFieldElement)this.getStepStart().getTime().add(this.getStepSize());
            RealFieldElement[] realFieldElementArray5 = this.computeDerivatives((RealFieldElement)object, realFieldElementArray3);
            object2 = new FieldODEStateAndDerivative((RealFieldElement)object, realFieldElementArray3, realFieldElementArray5);
            System.arraycopy(realFieldElementArray3, 0, realFieldElementArray4, 0, realFieldElementArray.length);
            RungeKuttaFieldIntegrator rungeKuttaFieldIntegrator5 = this;
            rungeKuttaFieldIntegrator5.setStepStart(rungeKuttaFieldIntegrator5.acceptStep(this.createInterpolator(bl, realFieldElementArray2, this.getStepStart(), (FieldODEStateAndDerivative)object2, fieldExpandableODE.getMapper()), t));
            if (this.isLastStep()) continue;
            RealFieldElement realFieldElement = (RealFieldElement)this.getStepStart().getTime().add(this.getStepSize());
            boolean bl3 = bl ? ((RealFieldElement)realFieldElement.subtract(t)).getReal() >= 0.0 : (bl2 = ((RealFieldElement)realFieldElement.subtract(t)).getReal() <= 0.0);
            if (!bl3) continue;
            this.setStepSize((RealFieldElement)t.subtract(this.getStepStart().getTime()));
        } while (!this.isLastStep());
        object = this.getStepStart();
        this.setStepStart(null);
        this.setStepSize(null);
        return object;
    }

    public T[] singleStep(FirstOrderFieldDifferentialEquations<T> firstOrderFieldDifferentialEquations, T t, T[] TArray, T object) {
        int n;
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])TArray.clone();
        int n2 = this.c.length + 1;
        RealFieldElement[][] realFieldElementArray2 = (RealFieldElement[][])MathArrays.buildArray(this.getField(), n2, -1);
        RealFieldElement[] realFieldElementArray3 = (RealFieldElement[])TArray.clone();
        object = (RealFieldElement)object.subtract(t);
        realFieldElementArray2[0] = firstOrderFieldDifferentialEquations.computeDerivatives((RealFieldElement)t, realFieldElementArray);
        for (n = 1; n < n2; ++n) {
            for (int i2 = 0; i2 < TArray.length; ++i2) {
                RealFieldElement realFieldElement = (RealFieldElement)realFieldElementArray2[0][i2].multiply(this.a[n - 1][0]);
                for (int i3 = 1; i3 < n; ++i3) {
                    realFieldElement = (RealFieldElement)realFieldElement.add(realFieldElementArray2[i3][i2].multiply(this.a[n - 1][i3]));
                }
                realFieldElementArray3[i2] = realFieldElementArray[i2].add(object.multiply(realFieldElement));
            }
            realFieldElementArray2[n] = firstOrderFieldDifferentialEquations.computeDerivatives((RealFieldElement)t.add(object.multiply(this.c[n - 1])), realFieldElementArray3);
        }
        for (n = 0; n < TArray.length; ++n) {
            RealFieldElement realFieldElement = (RealFieldElement)realFieldElementArray2[0][n].multiply(this.b[0]);
            for (int i4 = 1; i4 < n2; ++i4) {
                realFieldElement = (RealFieldElement)realFieldElement.add(realFieldElementArray2[i4][n].multiply(this.b[i4]));
            }
            realFieldElementArray[n] = realFieldElementArray[n].add(object.multiply(realFieldElement));
        }
        return realFieldElementArray;
    }
}

