/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.EmbeddedRungeKuttaIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.HighamHall54StepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class HighamHall54Integrator
extends EmbeddedRungeKuttaIntegrator {
    private static final String METHOD_NAME = "Higham-Hall 5(4)";
    private static final double[] STATIC_C = new double[]{0.2222222222222222, 0.3333333333333333, 0.5, 0.6, 1.0, 1.0};
    private static final double[][] STATIC_A = new double[][]{{0.2222222222222222}, {0.08333333333333333, 0.25}, {0.125, 0.0, 0.375}, {0.182, -0.27, 0.624, 0.064}, {-0.55, 1.35, 2.4, -7.2, 5.0}, {0.08333333333333333, 0.0, 0.84375, -1.3333333333333333, 1.3020833333333333, 0.10416666666666667}};
    private static final double[] STATIC_B = new double[]{0.08333333333333333, 0.0, 0.84375, -1.3333333333333333, 1.3020833333333333, 0.10416666666666667, 0.0};
    private static final double[] STATIC_E = new double[]{-0.05, 0.0, 0.50625, -1.2, 0.78125, 0.0625, -0.1};

    public HighamHall54Integrator(double d2, double d3, double d4, double d5) {
        super(METHOD_NAME, false, STATIC_C, STATIC_A, STATIC_B, (RungeKuttaStepInterpolator)new HighamHall54StepInterpolator(), d2, d3, d4, d5);
    }

    public HighamHall54Integrator(double d2, double d3, double[] dArray, double[] dArray2) {
        super(METHOD_NAME, false, STATIC_C, STATIC_A, STATIC_B, (RungeKuttaStepInterpolator)new HighamHall54StepInterpolator(), d2, d3, dArray, dArray2);
    }

    public int getOrder() {
        return 5;
    }

    protected double estimateError(double[][] dArray, double[] dArray2, double[] dArray3, double d2) {
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.mainSetDimension; ++i2) {
            double d4;
            double d5 = STATIC_E[0] * dArray[0][i2];
            for (int i3 = 1; i3 < STATIC_E.length; ++i3) {
                d5 += STATIC_E[i3] * dArray[i3][i2];
            }
            double d6 = FastMath.max(FastMath.abs(dArray2[i2]), FastMath.abs(dArray3[i2]));
            double d7 = this.vecAbsoluteTolerance == null ? this.scalAbsoluteTolerance + this.scalRelativeTolerance * d6 : this.vecAbsoluteTolerance[i2] + this.vecRelativeTolerance[i2] * d6;
            double d8 = d4 = d2 * d5 / d7;
            d3 += d8 * d8;
        }
        return FastMath.sqrt(d3 / (double)this.mainSetDimension);
    }
}

