/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldEquationsMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEStateAndDerivative;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.EmbeddedRungeKuttaFieldIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.HighamHall54FieldStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighamHall54FieldIntegrator<T extends RealFieldElement<T>>
extends EmbeddedRungeKuttaFieldIntegrator<T> {
    private static final String METHOD_NAME = "Higham-Hall 5(4)";
    private final T[] e;

    public HighamHall54FieldIntegrator(Field<T> field, double d2, double d3, double d4, double d5) {
        super(field, METHOD_NAME, -1, d2, d3, d4, d5);
        this.e = (RealFieldElement[])MathArrays.buildArray(field, 7);
        this.e[0] = this.fraction(-1, 20);
        this.e[1] = (RealFieldElement)field.getZero();
        this.e[2] = this.fraction(81, 160);
        this.e[3] = this.fraction(-6, 5);
        this.e[4] = this.fraction(25, 32);
        this.e[5] = this.fraction(1, 16);
        this.e[6] = this.fraction(-1, 10);
    }

    public HighamHall54FieldIntegrator(Field<T> field, double d2, double d3, double[] dArray, double[] dArray2) {
        super(field, METHOD_NAME, -1, d2, d3, dArray, dArray2);
        this.e = (RealFieldElement[])MathArrays.buildArray(field, 7);
        this.e[0] = this.fraction(-1, 20);
        this.e[1] = (RealFieldElement)field.getZero();
        this.e[2] = this.fraction(81, 160);
        this.e[3] = this.fraction(-6, 5);
        this.e[4] = this.fraction(25, 32);
        this.e[5] = this.fraction(1, 16);
        this.e[6] = this.fraction(-1, 10);
    }

    @Override
    public T[] getC() {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(this.getField(), 6);
        RealFieldElement[] realFieldElementArray2 = realFieldElementArray;
        realFieldElementArray[0] = this.fraction(2, 9);
        realFieldElementArray2[1] = this.fraction(1, 3);
        realFieldElementArray2[2] = this.fraction(1, 2);
        realFieldElementArray2[3] = this.fraction(3, 5);
        realFieldElementArray2[4] = (RealFieldElement)this.getField().getOne();
        realFieldElementArray2[5] = (RealFieldElement)this.getField().getOne();
        return realFieldElementArray2;
    }

    @Override
    public T[][] getA() {
        RealFieldElement[][] realFieldElementArray = (RealFieldElement[][])MathArrays.buildArray(this.getField(), 6, -1);
        for (int i2 = 0; i2 < realFieldElementArray.length; ++i2) {
            realFieldElementArray[i2] = (RealFieldElement[])MathArrays.buildArray(this.getField(), i2 + 1);
        }
        realFieldElementArray[0][0] = this.fraction(2, 9);
        realFieldElementArray[1][0] = this.fraction(1, 12);
        realFieldElementArray[1][1] = this.fraction(1, 4);
        realFieldElementArray[2][0] = this.fraction(1, 8);
        realFieldElementArray[2][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[2][2] = this.fraction(3, 8);
        realFieldElementArray[3][0] = this.fraction(91, 500);
        realFieldElementArray[3][1] = this.fraction(-27, 100);
        realFieldElementArray[3][2] = this.fraction(78, 125);
        realFieldElementArray[3][3] = this.fraction(8, 125);
        realFieldElementArray[4][0] = this.fraction(-11, 20);
        realFieldElementArray[4][1] = this.fraction(27, 20);
        realFieldElementArray[4][2] = this.fraction(12, 5);
        realFieldElementArray[4][3] = this.fraction(-36, 5);
        realFieldElementArray[4][4] = this.fraction(5, 1);
        realFieldElementArray[5][0] = this.fraction(1, 12);
        realFieldElementArray[5][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[5][2] = this.fraction(27, 32);
        realFieldElementArray[5][3] = this.fraction(-4, 3);
        realFieldElementArray[5][4] = this.fraction(125, 96);
        realFieldElementArray[5][5] = this.fraction(5, 48);
        return realFieldElementArray;
    }

    @Override
    public T[] getB() {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(this.getField(), 7);
        RealFieldElement[] realFieldElementArray2 = realFieldElementArray;
        realFieldElementArray[0] = this.fraction(1, 12);
        realFieldElementArray2[1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray2[2] = this.fraction(27, 32);
        realFieldElementArray2[3] = this.fraction(-4, 3);
        realFieldElementArray2[4] = this.fraction(125, 96);
        realFieldElementArray2[5] = this.fraction(5, 48);
        realFieldElementArray2[6] = (RealFieldElement)this.getField().getZero();
        return realFieldElementArray2;
    }

    @Override
    protected HighamHall54FieldStepInterpolator<T> createInterpolator(boolean bl, T[][] TArray, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2, FieldEquationsMapper<T> fieldEquationsMapper) {
        return new HighamHall54FieldStepInterpolator(this.getField(), bl, TArray, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldEquationsMapper);
    }

    @Override
    public int getOrder() {
        return 5;
    }

    @Override
    protected T estimateError(T[][] TArray, T[] TArray2, T[] TArray3, T realFieldElement) {
        RealFieldElement realFieldElement2 = (RealFieldElement)this.getField().getZero();
        for (int i2 = 0; i2 < this.mainSetDimension; ++i2) {
            RealFieldElement realFieldElement3 = (RealFieldElement)TArray[0][i2].multiply(this.e[0]);
            for (int i3 = 1; i3 < this.e.length; ++i3) {
                realFieldElement3 = (RealFieldElement)realFieldElement3.add(TArray[i3][i2].multiply(this.e[i3]));
            }
            RealFieldElement realFieldElement4 = MathUtils.max((RealFieldElement)TArray2[i2].abs(), (RealFieldElement)TArray3[i2].abs());
            realFieldElement4 = this.vecAbsoluteTolerance == null ? (RealFieldElement)((RealFieldElement)realFieldElement4.multiply(this.scalRelativeTolerance)).add(this.scalAbsoluteTolerance) : (RealFieldElement)((RealFieldElement)realFieldElement4.multiply(this.vecRelativeTolerance[i2])).add(this.vecAbsoluteTolerance[i2]);
            RealFieldElement realFieldElement5 = realFieldElement3 = realFieldElement.multiply((RealFieldElement)realFieldElement3).divide(realFieldElement4);
            realFieldElement2 = realFieldElement2.add(realFieldElement5.multiply(realFieldElement5));
        }
        return (T)((RealFieldElement)((RealFieldElement)realFieldElement2.divide(this.mainSetDimension)).sqrt());
    }
}

