/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.EquationsMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.AbstractStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.StepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.io.ObjectInput;
import java.io.ObjectOutput;

class GraggBulirschStoerStepInterpolator
extends AbstractStepInterpolator {
    private static final long serialVersionUID = 20110928L;
    private double[] y0Dot;
    private double[] y1;
    private double[] y1Dot;
    private double[][] yMidDots;
    private double[][] polynomials;
    private double[] errfac;
    private int currentDegree;

    public GraggBulirschStoerStepInterpolator() {
        this.y0Dot = null;
        this.y1 = null;
        this.y1Dot = null;
        this.yMidDots = null;
        this.resetTables(-1);
    }

    GraggBulirschStoerStepInterpolator(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[][] dArray5, boolean bl, EquationsMapper equationsMapper, EquationsMapper[] equationsMapperArray) {
        super(dArray, bl, equationsMapper, equationsMapperArray);
        this.y0Dot = dArray2;
        this.y1 = dArray3;
        this.y1Dot = dArray4;
        this.yMidDots = dArray5;
        this.resetTables(dArray5.length + 4);
    }

    GraggBulirschStoerStepInterpolator(GraggBulirschStoerStepInterpolator graggBulirschStoerStepInterpolator) {
        super(graggBulirschStoerStepInterpolator);
        int n = this.currentState.length;
        this.y0Dot = null;
        this.y1 = null;
        this.y1Dot = null;
        this.yMidDots = null;
        if (graggBulirschStoerStepInterpolator.polynomials == null) {
            this.polynomials = null;
            this.currentDegree = -1;
            return;
        }
        this.resetTables(graggBulirschStoerStepInterpolator.currentDegree);
        for (int i2 = 0; i2 < this.polynomials.length; ++i2) {
            this.polynomials[i2] = new double[n];
            System.arraycopy(graggBulirschStoerStepInterpolator.polynomials[i2], 0, this.polynomials[i2], 0, n);
        }
        this.currentDegree = graggBulirschStoerStepInterpolator.currentDegree;
    }

    private void resetTables(int n) {
        int n2;
        if (n < 0) {
            this.polynomials = null;
            this.errfac = null;
            this.currentDegree = -1;
            return;
        }
        double[][] dArrayArray = new double[n + 1][];
        if (this.polynomials != null) {
            System.arraycopy(this.polynomials, 0, dArrayArray, 0, this.polynomials.length);
            for (n2 = this.polynomials.length; n2 < dArrayArray.length; ++n2) {
                dArrayArray[n2] = new double[this.currentState.length];
            }
        } else {
            for (n2 = 0; n2 < dArrayArray.length; ++n2) {
                dArrayArray[n2] = new double[this.currentState.length];
            }
        }
        this.polynomials = dArrayArray;
        if (n <= 4) {
            this.errfac = null;
        } else {
            this.errfac = new double[n - 4];
            for (n2 = 0; n2 < this.errfac.length; ++n2) {
                int n3 = n = n2 + 5;
                this.errfac[n2] = 1.0 / (double)(n3 * n3);
                double d2 = 0.5 * FastMath.sqrt((double)(n2 + 1) / (double)n);
                for (n = 0; n <= n2; ++n) {
                    int n4 = n2;
                    this.errfac[n4] = this.errfac[n4] * (d2 / (double)(n + 1));
                }
            }
        }
        this.currentDegree = 0;
    }

    protected StepInterpolator doCopy() {
        return new GraggBulirschStoerStepInterpolator(this);
    }

    public void computeCoefficients(int n, double d2) {
        if (this.polynomials == null || this.polynomials.length <= n + 4) {
            this.resetTables(n + 4);
        }
        this.currentDegree = n + 4;
        for (int i2 = 0; i2 < this.currentState.length; ++i2) {
            double d3 = d2 * this.y0Dot[i2];
            double d4 = d2 * this.y1Dot[i2];
            double d5 = this.y1[i2] - this.currentState[i2];
            double d6 = d5 - d4;
            double d7 = d3 - d5;
            this.polynomials[0][i2] = this.currentState[i2];
            this.polynomials[1][i2] = d5;
            this.polynomials[2][i2] = d6;
            this.polynomials[3][i2] = d7;
            if (n < 0) {
                return;
            }
            double d8 = 0.5 * (this.currentState[i2] + this.y1[i2]) + 0.125 * (d6 + d7);
            this.polynomials[4][i2] = 16.0 * (this.yMidDots[0][i2] - d8);
            if (n <= 0) continue;
            double d9 = d5 + 0.25 * (d6 - d7);
            this.polynomials[5][i2] = 16.0 * (this.yMidDots[1][i2] - d9);
            if (n <= 1) continue;
            double d10 = d4 - d3;
            this.polynomials[6][i2] = 16.0 * (this.yMidDots[2][i2] - d10 + this.polynomials[4][i2]);
            if (n <= 2) continue;
            double d11 = 6.0 * (d7 - d6);
            this.polynomials[7][i2] = 16.0 * (this.yMidDots[3][i2] - d11 + 3.0 * this.polynomials[5][i2]);
            for (int i3 = 4; i3 <= n; ++i3) {
                double d12 = 0.5 * (double)i3 * (double)(i3 - 1);
                double d13 = d12 * 2.0 * (double)(i3 - 2) * (double)(i3 - 3);
                this.polynomials[i3 + 4][i2] = 16.0 * (this.yMidDots[i3][i2] + d12 * this.polynomials[i3 + 2][i2] - d13 * this.polynomials[i3][i2]);
            }
        }
    }

    public double estimateError(double[] dArray) {
        double d2 = 0.0;
        if (this.currentDegree >= 5) {
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                double d3;
                double d4 = d3 = this.polynomials[this.currentDegree][i2] / dArray[i2];
                d2 += d4 * d4;
            }
            d2 = FastMath.sqrt(d2 / (double)dArray.length) * this.errfac[this.currentDegree - 5];
        }
        return d2;
    }

    protected void computeInterpolatedStateAndDerivatives(double d2, double d3) {
        int n = this.currentState.length;
        double d4 = 1.0 - d2;
        double d5 = d2 - 0.5;
        double d6 = d2 * d4;
        double d7 = d6 * d6;
        double d8 = d6 * 2.0 * (1.0 - d2 * 2.0);
        double d9 = 1.0 / this.h;
        double d10 = d2 * (2.0 - d2 * 3.0) / this.h;
        double d11 = ((d2 * 3.0 - 4.0) * d2 + 1.0) / this.h;
        for (int i2 = 0; i2 < n; ++i2) {
            double d12 = this.polynomials[0][i2];
            double d13 = this.polynomials[1][i2];
            double d14 = this.polynomials[2][i2];
            double d15 = this.polynomials[3][i2];
            this.interpolatedState[i2] = d12 + d2 * (d13 + d4 * (d14 * d2 + d15 * d4));
            this.interpolatedDerivatives[i2] = d9 * d13 + d10 * d14 + d11 * d15;
            if (this.currentDegree <= 3) continue;
            double d16 = 0.0;
            double d17 = this.polynomials[this.currentDegree][i2];
            for (int i3 = this.currentDegree - 1; i3 > 3; --i3) {
                double d18 = 1.0 / (double)(i3 - 3);
                d16 = d18 * (d5 * d16 + d17);
                d17 = this.polynomials[i3][i2] + d17 * d18 * d5;
            }
            int n2 = i2;
            this.interpolatedState[n2] = this.interpolatedState[n2] + d7 * d17;
            int n3 = i2;
            this.interpolatedDerivatives[n3] = this.interpolatedDerivatives[n3] + (d7 * d16 + d8 * d17) / this.h;
        }
        if (this.h == 0.0) {
            System.arraycopy(this.yMidDots[1], 0, this.interpolatedDerivatives, 0, n);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) {
        int n = this.currentState == null ? -1 : this.currentState.length;
        this.writeBaseExternal(objectOutput);
        objectOutput.writeInt(this.currentDegree);
        for (int i2 = 0; i2 <= this.currentDegree; ++i2) {
            for (int i3 = 0; i3 < n; ++i3) {
                objectOutput.writeDouble(this.polynomials[i2][i3]);
            }
        }
    }

    public void readExternal(ObjectInput objectInput) {
        double d2 = this.readBaseExternal(objectInput);
        int n = this.currentState == null ? -1 : this.currentState.length;
        int n2 = objectInput.readInt();
        this.resetTables(n2);
        this.currentDegree = n2;
        for (n2 = 0; n2 <= this.currentDegree; ++n2) {
            for (int i2 = 0; i2 < n; ++i2) {
                this.polynomials[n2][i2] = objectInput.readDouble();
            }
        }
        this.setInterpolatedTime(d2);
    }
}

