/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.UnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.ExpandableStatefulODE;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events.EventHandler;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.AdaptiveStepsizeIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.GraggBulirschStoerStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.StepHandler;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class GraggBulirschStoerIntegrator
extends AdaptiveStepsizeIntegrator {
    private static final String METHOD_NAME = "Gragg-Bulirsch-Stoer";
    private int maxOrder;
    private int[] sequence;
    private int[] costPerStep;
    private double[] costPerTimeUnit;
    private double[] optimalStep;
    private double[][] coeff;
    private boolean performTest;
    private int maxChecks;
    private int maxIter;
    private double stabilityReduction;
    private double stepControl1;
    private double stepControl2;
    private double stepControl3;
    private double stepControl4;
    private double orderControl1;
    private double orderControl2;
    private boolean useInterpolationError;
    private int mudif;

    public GraggBulirschStoerIntegrator(double d2, double d3, double d4, double d5) {
        super(METHOD_NAME, d2, d3, d4, d5);
        this.setStabilityCheck(true, -1, -1, -1.0);
        this.setControlFactors(-1.0, -1.0, -1.0, -1.0);
        this.setOrderControl(-1, -1.0, -1.0);
        this.setInterpolationControl(true, -1);
    }

    public GraggBulirschStoerIntegrator(double d2, double d3, double[] dArray, double[] dArray2) {
        super(METHOD_NAME, d2, d3, dArray, dArray2);
        this.setStabilityCheck(true, -1, -1, -1.0);
        this.setControlFactors(-1.0, -1.0, -1.0, -1.0);
        this.setOrderControl(-1, -1.0, -1.0);
        this.setInterpolationControl(true, -1);
    }

    public void setStabilityCheck(boolean bl, int n, int n2, double d2) {
        this.performTest = bl;
        this.maxIter = n <= 0 ? 2 : n;
        int n3 = this.maxChecks = n2 <= 0 ? 1 : n2;
        if (d2 < 1.0E-4 || d2 > 0.9999) {
            this.stabilityReduction = 0.5;
            return;
        }
        this.stabilityReduction = d2;
    }

    public void setControlFactors(double d2, double d3, double d4, double d5) {
        this.stepControl1 = d2 < 1.0E-4 || d2 > 0.9999 ? 0.65 : d2;
        this.stepControl2 = d3 < 1.0E-4 || d3 > 0.9999 ? 0.94 : d3;
        this.stepControl3 = d4 < 1.0E-4 || d4 > 0.9999 ? 0.02 : d4;
        if (d5 < 1.0001 || d5 > 999.9) {
            this.stepControl4 = 4.0;
            return;
        }
        this.stepControl4 = d5;
    }

    public void setOrderControl(int n, double d2, double d3) {
        if (n <= 6 || n % 2 != 0) {
            this.maxOrder = 18;
        }
        this.orderControl1 = d2 < 1.0E-4 || d2 > 0.9999 ? 0.8 : d2;
        this.orderControl2 = d3 < 1.0E-4 || d3 > 0.9999 ? 0.9 : d3;
        this.initializeArrays();
    }

    public void addStepHandler(StepHandler stepHandler) {
        super.addStepHandler(stepHandler);
        this.initializeArrays();
    }

    public void addEventHandler(EventHandler eventHandler, double d2, double d3, int n, UnivariateSolver univariateSolver) {
        super.addEventHandler(eventHandler, d2, d3, n, univariateSolver);
        this.initializeArrays();
    }

    private void initializeArrays() {
        int n;
        int n2 = this.maxOrder / 2;
        if (this.sequence == null || this.sequence.length != n2) {
            this.sequence = new int[n2];
            this.costPerStep = new int[n2];
            this.coeff = new double[n2][];
            this.costPerTimeUnit = new double[n2];
            this.optimalStep = new double[n2];
        }
        for (n = 0; n < n2; ++n) {
            this.sequence[n] = 4 * n + 2;
        }
        this.costPerStep[0] = this.sequence[0] + 1;
        for (n = 1; n < n2; ++n) {
            this.costPerStep[n] = this.costPerStep[n - 1] + this.sequence[n];
        }
        for (n = 0; n < n2; ++n) {
            int n3 = n;
            this.coeff[n3] = n3 > 0 ? new double[n] : null;
            for (int i2 = 0; i2 < n; ++i2) {
                double d2;
                double d3 = d2 = (double)this.sequence[n] / (double)this.sequence[n - i2 - 1];
                this.coeff[n][i2] = 1.0 / (d3 * d3 - 1.0);
            }
        }
    }

    public void setInterpolationControl(boolean bl, int n) {
        this.useInterpolationError = bl;
        if (n <= 0 || n >= 7) {
            this.mudif = 4;
            return;
        }
        this.mudif = n;
    }

    private void rescale(double[] dArray, double[] dArray2, double[] dArray3) {
        if (this.vecAbsoluteTolerance == null) {
            for (int i2 = 0; i2 < dArray3.length; ++i2) {
                double d2 = FastMath.max(FastMath.abs(dArray[i2]), FastMath.abs(dArray2[i2]));
                dArray3[i2] = this.scalAbsoluteTolerance + this.scalRelativeTolerance * d2;
            }
            return;
        }
        for (int i3 = 0; i3 < dArray3.length; ++i3) {
            double d3 = FastMath.max(FastMath.abs(dArray[i3]), FastMath.abs(dArray2[i3]));
            dArray3[i3] = this.vecAbsoluteTolerance[i3] + this.vecRelativeTolerance[i3] * d3;
        }
    }

    private boolean tryStep(double d2, double[] dArray, double d3, int n, double[] dArray2, double[][] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) {
        int n2;
        int n3 = this.sequence[n];
        double d4 = d3 / (double)n3;
        double d5 = d4 * 2.0;
        double d6 = d2 + d4;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray6[n2] = dArray[n2];
            dArray5[n2] = dArray[n2] + d4 * dArray3[0][n2];
        }
        this.computeDerivatives(d6, dArray5, dArray3[1]);
        for (n2 = 1; n2 < n3; ++n2) {
            if (2 * n2 == n3) {
                System.arraycopy(dArray5, 0, dArray4, 0, dArray.length);
            }
            d6 += d4;
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                double d7 = dArray5[i2];
                dArray5[i2] = dArray6[i2] + d5 * dArray3[n2][i2];
                dArray6[i2] = d7;
            }
            this.computeDerivatives(d6, dArray5, dArray3[n2 + 1]);
            if (!this.performTest || n2 > this.maxChecks || n >= this.maxIter) continue;
            double d8 = 0.0;
            for (int i3 = 0; i3 < dArray2.length; ++i3) {
                double d9;
                double d10 = d9 = dArray3[0][i3] / dArray2[i3];
                d8 += d10 * d10;
            }
            double d11 = 0.0;
            for (int i4 = 0; i4 < dArray2.length; ++i4) {
                double d12;
                double d13 = d12 = (dArray3[n2 + 1][i4] - dArray3[0][i4]) / dArray2[i4];
                d11 += d13 * d13;
            }
            if (!(d11 > 4.0 * FastMath.max(1.0E-15, d8))) continue;
            return false;
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray5[n2] = 0.5 * (dArray6[n2] + dArray5[n2] + d4 * dArray3[n3][n2]);
        }
        return true;
    }

    private void extrapolate(int n, int n2, double[][] dArray, double[] dArray2) {
        int n3;
        for (n3 = 1; n3 < n2; ++n3) {
            for (int i2 = 0; i2 < dArray2.length; ++i2) {
                dArray[n2 - n3 - 1][i2] = dArray[n2 - n3][i2] + this.coeff[n2 + n][n3 - 1] * (dArray[n2 - n3][i2] - dArray[n2 - n3 - 1][i2]);
            }
        }
        for (n3 = 0; n3 < dArray2.length; ++n3) {
            dArray2[n3] = dArray[0][n3] + this.coeff[n2 + n][n2 - 1] * (dArray[0][n3] - dArray2[n3]);
        }
    }

    public void integrate(ExpandableStatefulODE expandableStatefulODE, double d2) {
        this.sanityChecks(expandableStatefulODE, d2);
        this.setEquations(expandableStatefulODE);
        boolean bl = d2 > expandableStatefulODE.getTime();
        double[] dArray = expandableStatefulODE.getCompleteState();
        double[] dArray2 = (double[])dArray.clone();
        double[] dArray3 = new double[dArray2.length];
        double[] dArray4 = new double[dArray2.length];
        double[] dArray5 = new double[dArray2.length];
        double[] dArray6 = new double[dArray2.length];
        double[][] dArrayArray = new double[this.sequence.length - 1][];
        double[][] dArrayArray2 = new double[this.sequence.length - 1][];
        for (int i2 = 0; i2 < this.sequence.length - 1; ++i2) {
            dArrayArray[i2] = new double[dArray2.length];
            dArrayArray2[i2] = new double[dArray2.length];
        }
        double[][][] dArrayArray3 = new double[this.sequence.length][][];
        for (int i3 = 0; i3 < this.sequence.length; ++i3) {
            dArrayArray3[i3] = new double[this.sequence[i3] + 1][];
            dArrayArray3[i3][0] = dArray3;
            for (int i4 = 0; i4 < this.sequence[i3]; ++i4) {
                dArrayArray3[i3][i4 + 1] = new double[dArray.length];
            }
        }
        if (dArray2 != dArray) {
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        }
        double[] dArray7 = new double[dArray.length];
        double[][] dArray8 = new double[1 + 2 * this.sequence.length][dArray.length];
        double[] dArray9 = new double[this.mainSetDimension];
        this.rescale(dArray2, dArray2, dArray9);
        double d3 = this.vecRelativeTolerance == null ? this.scalRelativeTolerance : this.vecRelativeTolerance[0];
        double d4 = FastMath.log10(FastMath.max(1.0E-10, d3));
        int n = FastMath.max(1, FastMath.min(this.sequence.length - 2, (int)FastMath.floor(0.5 - d4 * 0.6)));
        GraggBulirschStoerStepInterpolator graggBulirschStoerStepInterpolator = new GraggBulirschStoerStepInterpolator(dArray2, dArray3, dArray4, dArray7, dArray8, bl, expandableStatefulODE.getPrimaryMapper(), expandableStatefulODE.getSecondaryMappers());
        graggBulirschStoerStepInterpolator.storeTime(expandableStatefulODE.getTime());
        this.stepStart = expandableStatefulODE.getTime();
        double d5 = 0.0;
        double d6 = Double.MAX_VALUE;
        boolean bl2 = false;
        int n2 = 1;
        boolean bl3 = true;
        boolean bl4 = false;
        this.initIntegration(expandableStatefulODE.getTime(), dArray, d2);
        this.costPerTimeUnit[0] = 0.0;
        this.isLastStep = false;
        do {
            double d7;
            boolean bl5 = false;
            if (bl3) {
                graggBulirschStoerStepInterpolator.shift();
                if (!bl4) {
                    GraggBulirschStoerIntegrator graggBulirschStoerIntegrator = this;
                    graggBulirschStoerIntegrator.computeDerivatives(graggBulirschStoerIntegrator.stepStart, dArray2, dArray3);
                }
                if (n2 != 0) {
                    d5 = this.initializeStep(bl, 2 * n + 1, dArray9, this.stepStart, dArray2, dArray3, dArray5, dArray6);
                }
                bl3 = false;
            }
            this.stepSize = d5;
            if (bl && this.stepStart + this.stepSize > d2 || !bl && this.stepStart + this.stepSize < d2) {
                this.stepSize = d2 - this.stepStart;
            }
            double d8 = this.stepStart + this.stepSize;
            this.isLastStep = bl ? d8 >= d2 : d8 <= d2;
            int n3 = -1;
            boolean bl6 = true;
            block9: while (bl6) {
                GraggBulirschStoerIntegrator graggBulirschStoerIntegrator = this;
                if (!graggBulirschStoerIntegrator.tryStep(graggBulirschStoerIntegrator.stepStart, dArray2, this.stepSize, n3, dArray9, dArrayArray3[++n3], n3 == 0 ? dArray8[0] : dArrayArray[n3 - 1], n3 == 0 ? dArray4 : dArrayArray2[n3 - 1], dArray5)) {
                    GraggBulirschStoerIntegrator graggBulirschStoerIntegrator2 = this;
                    d5 = FastMath.abs(graggBulirschStoerIntegrator2.filterStep(graggBulirschStoerIntegrator2.stepSize * this.stabilityReduction, bl, false));
                    bl5 = true;
                    bl6 = false;
                    continue;
                }
                if (n3 <= 0) continue;
                this.extrapolate(0, n3, dArrayArray2, dArray4);
                this.rescale(dArray2, dArray4, dArray9);
                double d9 = 0.0;
                for (int i5 = 0; i5 < this.mainSetDimension; ++i5) {
                    double d10;
                    double d11 = d10 = FastMath.abs(dArray4[i5] - dArrayArray2[0][i5]) / dArray9[i5];
                    d9 += d11 * d11;
                }
                if ((d9 = FastMath.sqrt(d9 / (double)this.mainSetDimension)) > 1.0E15 || n3 > 1 && d9 > d6) {
                    GraggBulirschStoerIntegrator graggBulirschStoerIntegrator3 = this;
                    d5 = FastMath.abs(graggBulirschStoerIntegrator3.filterStep(graggBulirschStoerIntegrator3.stepSize * this.stabilityReduction, bl, false));
                    bl5 = true;
                    bl6 = false;
                    continue;
                }
                d6 = FastMath.max(d9 * 4.0, 1.0);
                double d12 = 1.0 / (double)(2 * n3 + 1);
                double d13 = this.stepControl2 / FastMath.pow(d9 / this.stepControl1, d12);
                d7 = FastMath.pow(this.stepControl3, d12);
                d13 = FastMath.max(d7 / this.stepControl4, FastMath.min(1.0 / d7, d13));
                GraggBulirschStoerIntegrator graggBulirschStoerIntegrator4 = this;
                this.optimalStep[n3] = FastMath.abs(graggBulirschStoerIntegrator4.filterStep(graggBulirschStoerIntegrator4.stepSize * d13, bl, true));
                this.costPerTimeUnit[n3] = (double)this.costPerStep[n3] / this.optimalStep[n3];
                switch (n3 - n) {
                    case -1: {
                        double d14;
                        if (n <= 1 || bl2) continue block9;
                        if (d9 <= 1.0) {
                            bl6 = false;
                            continue block9;
                        }
                        double d15 = d14 = (double)this.sequence[n] * (double)this.sequence[n + 1] / (double)(this.sequence[0] * this.sequence[0]);
                        if (!(d9 > d15 * d15)) continue block9;
                        bl5 = true;
                        bl6 = false;
                        n = n3;
                        if (n > 1 && this.costPerTimeUnit[n - 1] < this.orderControl1 * this.costPerTimeUnit[n]) {
                            --n;
                        }
                        d5 = this.optimalStep[n];
                        continue block9;
                    }
                    case 0: {
                        double d14;
                        if (d9 <= 1.0) {
                            bl6 = false;
                            continue block9;
                        }
                        double d16 = d14 = (double)this.sequence[n3 + 1] / (double)this.sequence[0];
                        if (!(d9 > d16 * d16)) continue block9;
                        bl5 = true;
                        bl6 = false;
                        if (n > 1 && this.costPerTimeUnit[n - 1] < this.orderControl1 * this.costPerTimeUnit[n]) {
                            --n;
                        }
                        d5 = this.optimalStep[n];
                        continue block9;
                    }
                    case 1: {
                        if (d9 > 1.0) {
                            bl5 = true;
                            if (n > 1 && this.costPerTimeUnit[n - 1] < this.orderControl1 * this.costPerTimeUnit[n]) {
                                --n;
                            }
                            d5 = this.optimalStep[n];
                        }
                        bl6 = false;
                        continue block9;
                    }
                }
                if (n2 == 0 && !this.isLastStep || !(d9 <= 1.0)) continue;
                bl6 = false;
            }
            if (!bl5) {
                GraggBulirschStoerIntegrator graggBulirschStoerIntegrator = this;
                graggBulirschStoerIntegrator.computeDerivatives(graggBulirschStoerIntegrator.stepStart + this.stepSize, dArray4, dArray7);
            }
            double d17 = this.getMaxStep();
            if (!bl5) {
                int n4;
                for (n4 = 1; n4 <= n3; ++n4) {
                    this.extrapolate(0, n4, dArrayArray, dArray8[0]);
                }
                n4 = 2 * n3 - this.mudif + 3;
                for (int i6 = 0; i6 < n4; ++i6) {
                    int n5;
                    int n6 = i6 / 2;
                    d7 = FastMath.pow(0.5 * (double)this.sequence[n6], i6);
                    int n7 = dArrayArray3[n6].length / 2;
                    for (n5 = 0; n5 < dArray.length; ++n5) {
                        dArray8[i6 + 1][n5] = d7 * dArrayArray3[n6][n7 + i6][n5];
                    }
                    for (n5 = 1; n5 <= n3 - n6; ++n5) {
                        d7 = FastMath.pow(0.5 * (double)this.sequence[n5 + n6], i6);
                        n7 = dArrayArray3[n6 + n5].length / 2;
                        for (n2 = 0; n2 < dArray.length; ++n2) {
                            dArrayArray[n5 - 1][n2] = d7 * dArrayArray3[n6 + n5][n7 + i6][n2];
                        }
                        this.extrapolate(n6, n5, dArrayArray, dArray8[i6 + 1]);
                    }
                    n5 = 0;
                    while (n5 < dArray.length) {
                        double[] dArray10 = dArray8[i6 + 1];
                        int n8 = n5++;
                        dArray10[n8] = dArray10[n8] * this.stepSize;
                    }
                    for (n5 = (i6 + 1) / 2; n5 <= n3; ++n5) {
                        for (n2 = dArrayArray3[n5].length - 1; n2 >= 2 * (i6 + 1); --n2) {
                            for (int i7 = 0; i7 < dArray.length; ++i7) {
                                double[] dArray11 = dArrayArray3[n5][n2];
                                int n9 = i7;
                                dArray11[n9] = dArray11[n9] - dArrayArray3[n5][n2 - 2][i7];
                            }
                        }
                    }
                }
                if (n4 >= 0) {
                    GraggBulirschStoerStepInterpolator graggBulirschStoerStepInterpolator2 = graggBulirschStoerStepInterpolator;
                    graggBulirschStoerStepInterpolator2.computeCoefficients(n4, this.stepSize);
                    if (this.useInterpolationError) {
                        double d18 = graggBulirschStoerStepInterpolator2.estimateError(dArray9);
                        d17 = FastMath.abs(this.stepSize / FastMath.max(FastMath.pow(d18, 1.0 / (double)(n4 + 4)), 0.01));
                        if (d18 > 10.0) {
                            d5 = d17;
                            bl5 = true;
                        }
                    }
                }
            }
            if (!bl5) {
                int n10;
                graggBulirschStoerStepInterpolator.storeTime(this.stepStart + this.stepSize);
                this.stepStart = this.acceptStep(graggBulirschStoerStepInterpolator, dArray4, dArray7, d2);
                graggBulirschStoerStepInterpolator.storeTime(this.stepStart);
                System.arraycopy(dArray4, 0, dArray2, 0, dArray.length);
                System.arraycopy(dArray7, 0, dArray3, 0, dArray.length);
                bl4 = true;
                if (n3 == 1) {
                    n10 = 2;
                    if (bl2) {
                        n10 = 1;
                    }
                } else if (n3 <= n) {
                    n10 = n3;
                    if (this.costPerTimeUnit[n3 - 1] < this.orderControl1 * this.costPerTimeUnit[n3]) {
                        n10 = n3 - 1;
                    } else if (this.costPerTimeUnit[n3] < this.orderControl2 * this.costPerTimeUnit[n3 - 1]) {
                        n10 = FastMath.min(n3 + 1, this.sequence.length - 2);
                    }
                } else {
                    n10 = n3 - 1;
                    if (n3 > 2 && this.costPerTimeUnit[n3 - 2] < this.orderControl1 * this.costPerTimeUnit[n3 - 1]) {
                        n10 = n3 - 2;
                    }
                    if (this.costPerTimeUnit[n3] < this.orderControl2 * this.costPerTimeUnit[n10]) {
                        n10 = FastMath.min(n3, this.sequence.length - 2);
                    }
                }
                if (bl2) {
                    n = FastMath.min(n10, n3);
                    d5 = FastMath.min(FastMath.abs(this.stepSize), this.optimalStep[n]);
                } else {
                    if (n10 <= n3) {
                        d5 = this.optimalStep[n10];
                    } else if (n3 < n && this.costPerTimeUnit[n3] < this.orderControl2 * this.costPerTimeUnit[n3 - 1]) {
                        GraggBulirschStoerIntegrator graggBulirschStoerIntegrator = this;
                        d5 = graggBulirschStoerIntegrator.filterStep(graggBulirschStoerIntegrator.optimalStep[n3] * (double)this.costPerStep[n10 + 1] / (double)this.costPerStep[n3], bl, false);
                    } else {
                        GraggBulirschStoerIntegrator graggBulirschStoerIntegrator = this;
                        d5 = graggBulirschStoerIntegrator.filterStep(graggBulirschStoerIntegrator.optimalStep[n3] * (double)this.costPerStep[n10] / (double)this.costPerStep[n3], bl, false);
                    }
                    n = n10;
                }
                bl3 = true;
            }
            d5 = FastMath.min(d5, d17);
            if (!bl) {
                d5 = -d5;
            }
            n2 = 0;
            if (bl5) {
                this.isLastStep = false;
                bl2 = true;
                continue;
            }
            bl2 = false;
        } while (!this.isLastStep);
        expandableStatefulODE.setTime(this.stepStart);
        expandableStatefulODE.setCompleteState(dArray2);
        this.resetInternalState();
    }
}

