/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.StepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

class GillStepInterpolator
extends RungeKuttaStepInterpolator {
    private static final double ONE_MINUS_INV_SQRT_2 = 1.0 - FastMath.sqrt(0.5);
    private static final double ONE_PLUS_INV_SQRT_2 = 1.0 + FastMath.sqrt(0.5);
    private static final long serialVersionUID = 20111120L;

    public GillStepInterpolator() {
    }

    GillStepInterpolator(GillStepInterpolator gillStepInterpolator) {
        super(gillStepInterpolator);
    }

    protected StepInterpolator doCopy() {
        return new GillStepInterpolator(this);
    }

    protected void computeInterpolatedStateAndDerivatives(double d2, double d3) {
        double d4 = d2 * 2.0;
        double d5 = d4 * d4;
        double d6 = d2 * (d4 - 3.0) + 1.0;
        double d7 = d4 * (1.0 - d2);
        double d8 = d7 * ONE_MINUS_INV_SQRT_2;
        double d9 = d7 * ONE_PLUS_INV_SQRT_2;
        double d10 = d2 * (d4 - 1.0);
        if (this.previousState != null && d2 <= 0.5) {
            double d11 = d2 * this.h / 6.0;
            double d12 = d11 * (d2 * 6.0 - d5);
            double d13 = d11 * (6.0 - d2 * 9.0 + d5);
            double d14 = d12 * ONE_MINUS_INV_SQRT_2;
            double d15 = d12 * ONE_PLUS_INV_SQRT_2;
            double d16 = d11 * (d2 * -3.0 + d5);
            for (int i2 = 0; i2 < this.interpolatedState.length; ++i2) {
                double d17 = this.yDotK[0][i2];
                double d18 = this.yDotK[1][i2];
                double d19 = this.yDotK[2][i2];
                double d20 = this.yDotK[3][i2];
                this.interpolatedState[i2] = this.previousState[i2] + d13 * d17 + d14 * d18 + d15 * d19 + d16 * d20;
                this.interpolatedDerivatives[i2] = d6 * d17 + d8 * d18 + d9 * d19 + d10 * d20;
            }
            return;
        }
        double d21 = d3 / 6.0;
        double d22 = d21 * (d4 + 2.0 - d5);
        double d23 = d21 * (1.0 - d2 * 5.0 + d5);
        double d24 = d22 * ONE_MINUS_INV_SQRT_2;
        double d25 = d22 * ONE_PLUS_INV_SQRT_2;
        double d26 = d21 * (d2 + 1.0 + d5);
        for (int i3 = 0; i3 < this.interpolatedState.length; ++i3) {
            double d27 = this.yDotK[0][i3];
            double d28 = this.yDotK[1][i3];
            double d29 = this.yDotK[2][i3];
            double d30 = this.yDotK[3][i3];
            this.interpolatedState[i3] = this.currentState[i3] - d23 * d27 - d24 * d28 - d25 * d29 - d26 * d30;
            this.interpolatedDerivatives[i3] = d6 * d27 + d8 * d28 + d9 * d29 + d10 * d30;
        }
    }
}

