/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldEquationsMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldExpandableODE;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEState;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEStateAndDerivative;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.AdaptiveStepsizeFieldIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.FieldButcherArrayProvider;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.RungeKuttaFieldStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EmbeddedRungeKuttaFieldIntegrator<T extends RealFieldElement<T>>
extends AdaptiveStepsizeFieldIntegrator<T>
implements FieldButcherArrayProvider<T> {
    private final int fsal;
    private final T[] c;
    private final T[][] a;
    private final T[] b;
    private final T exp;
    private T safety;
    private T minReduction;
    private T maxGrowth;

    protected EmbeddedRungeKuttaFieldIntegrator(Field<T> field, String string, int n, double d2, double d3, double d4, double d5) {
        super(field, string, d2, d3, d4, d5);
        this.fsal = n;
        this.c = this.getC();
        this.a = this.getA();
        this.b = this.getB();
        this.exp = (RealFieldElement)((RealFieldElement)field.getOne()).divide(-this.getOrder());
        this.setSafety((RealFieldElement)((RealFieldElement)field.getZero()).add(0.9));
        this.setMinReduction((RealFieldElement)((RealFieldElement)field.getZero()).add(0.2));
        this.setMaxGrowth((RealFieldElement)((RealFieldElement)field.getZero()).add(10.0));
    }

    protected EmbeddedRungeKuttaFieldIntegrator(Field<T> field, String string, int n, double d2, double d3, double[] dArray, double[] dArray2) {
        super(field, string, d2, d3, dArray, dArray2);
        this.fsal = n;
        this.c = this.getC();
        this.a = this.getA();
        this.b = this.getB();
        this.exp = (RealFieldElement)((RealFieldElement)field.getOne()).divide(-this.getOrder());
        this.setSafety((RealFieldElement)((RealFieldElement)field.getZero()).add(0.9));
        this.setMinReduction((RealFieldElement)((RealFieldElement)field.getZero()).add(0.2));
        this.setMaxGrowth((RealFieldElement)((RealFieldElement)field.getZero()).add(10.0));
    }

    protected T fraction(int n, int n2) {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.getField().getOne()).multiply(n)).divide(n2));
    }

    protected T fraction(double d2, double d3) {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.getField().getOne()).multiply(d2)).divide(d3));
    }

    protected abstract RungeKuttaFieldStepInterpolator<T> createInterpolator(boolean var1, T[][] var2, FieldODEStateAndDerivative<T> var3, FieldODEStateAndDerivative<T> var4, FieldEquationsMapper<T> var5);

    public abstract int getOrder();

    public T getSafety() {
        return this.safety;
    }

    public void setSafety(T t) {
        this.safety = t;
    }

    @Override
    public FieldODEStateAndDerivative<T> integrate(FieldExpandableODE<T> fieldExpandableODE, FieldODEState<T> fieldODEState, T t) {
        Object object;
        this.sanityChecks(fieldODEState, t);
        T t2 = fieldODEState.getTime();
        RealFieldElement[] realFieldElementArray = fieldExpandableODE.getMapper().mapState(fieldODEState);
        EmbeddedRungeKuttaFieldIntegrator embeddedRungeKuttaFieldIntegrator = this;
        embeddedRungeKuttaFieldIntegrator.setStepStart(embeddedRungeKuttaFieldIntegrator.initIntegration(fieldExpandableODE, (RealFieldElement)t2, realFieldElementArray, (RealFieldElement)t));
        boolean bl = ((RealFieldElement)t.subtract(fieldODEState.getTime())).getReal() > 0.0;
        int n = this.c.length + 1;
        RealFieldElement[] realFieldElementArray2 = realFieldElementArray;
        RealFieldElement[][] realFieldElementArray3 = (RealFieldElement[][])MathArrays.buildArray(this.getField(), n, -1);
        RealFieldElement[] realFieldElementArray4 = (RealFieldElement[])MathArrays.buildArray(this.getField(), realFieldElementArray.length);
        RealFieldElement realFieldElement = (RealFieldElement)this.getField().getZero();
        boolean bl2 = true;
        this.setIsLastStep(false);
        do {
            boolean bl3;
            object = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(10.0);
            while (((RealFieldElement)object.subtract(1.0)).getReal() >= 0.0) {
                RealFieldElement realFieldElement2;
                int n2;
                int n3;
                realFieldElementArray2 = fieldExpandableODE.getMapper().mapState(this.getStepStart());
                realFieldElementArray3[0] = fieldExpandableODE.getMapper().mapDerivative(this.getStepStart());
                if (bl2) {
                    RealFieldElement[] realFieldElementArray5 = (RealFieldElement[])MathArrays.buildArray(this.getField(), this.mainSetDimension);
                    if (this.vecAbsoluteTolerance == null) {
                        for (n3 = 0; n3 < realFieldElementArray5.length; ++n3) {
                            realFieldElementArray5[n3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElementArray2[n3].abs()).multiply(this.scalRelativeTolerance)).add(this.scalAbsoluteTolerance);
                        }
                    } else {
                        for (n3 = 0; n3 < realFieldElementArray5.length; ++n3) {
                            realFieldElementArray5[n3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElementArray2[n3].abs()).multiply(this.vecRelativeTolerance[n3])).add(this.vecAbsoluteTolerance[n3]);
                        }
                    }
                    realFieldElement = this.initializeStep(bl, this.getOrder(), realFieldElementArray5, this.getStepStart(), fieldExpandableODE.getMapper());
                    bl2 = false;
                }
                this.setStepSize(realFieldElement);
                if (bl) {
                    if (((RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize())).subtract(t)).getReal() >= 0.0) {
                        this.setStepSize((RealFieldElement)t.subtract(this.getStepStart().getTime()));
                    }
                } else if (((RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize())).subtract(t)).getReal() <= 0.0) {
                    this.setStepSize((RealFieldElement)t.subtract(this.getStepStart().getTime()));
                }
                for (n2 = 1; n2 < n; ++n2) {
                    for (n3 = 0; n3 < realFieldElementArray.length; ++n3) {
                        RealFieldElement realFieldElement3 = (RealFieldElement)realFieldElementArray3[0][n3].multiply(this.a[n2 - 1][0]);
                        for (int i2 = 1; i2 < n2; ++i2) {
                            realFieldElement3 = (RealFieldElement)realFieldElement3.add(realFieldElementArray3[i2][n3].multiply(this.a[n2 - 1][i2]));
                        }
                        realFieldElementArray4[n3] = realFieldElementArray2[n3].add(this.getStepSize().multiply((RealFieldElement)realFieldElement3));
                    }
                    EmbeddedRungeKuttaFieldIntegrator embeddedRungeKuttaFieldIntegrator2 = this;
                    realFieldElementArray3[n2] = embeddedRungeKuttaFieldIntegrator2.computeDerivatives((RealFieldElement)embeddedRungeKuttaFieldIntegrator2.getStepStart().getTime().add(this.getStepSize().multiply(this.c[n2 - 1])), realFieldElementArray4);
                }
                for (n2 = 0; n2 < realFieldElementArray.length; ++n2) {
                    RealFieldElement realFieldElement4 = (RealFieldElement)realFieldElementArray3[0][n2].multiply(this.b[0]);
                    for (int i3 = 1; i3 < n; ++i3) {
                        realFieldElement4 = (RealFieldElement)realFieldElement4.add(realFieldElementArray3[i3][n2].multiply(this.b[i3]));
                    }
                    realFieldElementArray4[n2] = realFieldElementArray2[n2].add(this.getStepSize().multiply((RealFieldElement)realFieldElement4));
                }
                object = this.estimateError(realFieldElementArray3, realFieldElementArray2, realFieldElementArray4, (RealFieldElement)this.getStepSize());
                if (!(((RealFieldElement)realFieldElement2.subtract(1.0)).getReal() >= 0.0)) continue;
                RealFieldElement realFieldElement5 = MathUtils.min(this.maxGrowth, MathUtils.max(this.minReduction, (RealFieldElement)this.safety.multiply(object.pow(this.exp))));
                EmbeddedRungeKuttaFieldIntegrator embeddedRungeKuttaFieldIntegrator3 = this;
                realFieldElement = embeddedRungeKuttaFieldIntegrator3.filterStep(embeddedRungeKuttaFieldIntegrator3.getStepSize().multiply((RealFieldElement)realFieldElement5), bl, false);
            }
            RealFieldElement realFieldElement6 = (RealFieldElement)this.getStepStart().getTime().add(this.getStepSize());
            RealFieldElement[] realFieldElementArray6 = this.fsal >= 0 ? realFieldElementArray3[this.fsal] : this.computeDerivatives(realFieldElement6, realFieldElementArray4);
            FieldODEStateAndDerivative fieldODEStateAndDerivative = new FieldODEStateAndDerivative(realFieldElement6, realFieldElementArray4, realFieldElementArray6);
            System.arraycopy(realFieldElementArray4, 0, realFieldElementArray2, 0, realFieldElementArray.length);
            EmbeddedRungeKuttaFieldIntegrator embeddedRungeKuttaFieldIntegrator4 = this;
            embeddedRungeKuttaFieldIntegrator4.setStepStart(embeddedRungeKuttaFieldIntegrator4.acceptStep(this.createInterpolator(bl, realFieldElementArray3, this.getStepStart(), fieldODEStateAndDerivative, fieldExpandableODE.getMapper()), t));
            if (this.isLastStep()) continue;
            object = MathUtils.min(this.maxGrowth, MathUtils.max(this.minReduction, (RealFieldElement)this.safety.multiply(object.pow(this.exp))));
            realFieldElement = (RealFieldElement)this.getStepSize().multiply((Object)object);
            object = this.getStepStart().getTime().add((RealFieldElement)realFieldElement);
            boolean bl4 = bl ? ((RealFieldElement)object.subtract(t)).getReal() >= 0.0 : ((RealFieldElement)object.subtract(t)).getReal() <= 0.0;
            realFieldElement = this.filterStep(realFieldElement, bl, bl4);
            RealFieldElement realFieldElement7 = this.getStepStart().getTime().add((RealFieldElement)realFieldElement);
            boolean bl5 = bl ? ((RealFieldElement)realFieldElement7.subtract(t)).getReal() >= 0.0 : (bl3 = ((RealFieldElement)realFieldElement7.subtract(t)).getReal() <= 0.0);
            if (!bl5) continue;
            realFieldElement = (RealFieldElement)t.subtract(this.getStepStart().getTime());
        } while (!this.isLastStep());
        object = this.getStepStart();
        this.resetInternalState();
        return object;
    }

    public T getMinReduction() {
        return this.minReduction;
    }

    public void setMinReduction(T t) {
        this.minReduction = t;
    }

    public T getMaxGrowth() {
        return this.maxGrowth;
    }

    public void setMaxGrowth(T t) {
        this.maxGrowth = t;
    }

    protected abstract T estimateError(T[][] var1, T[] var2, T[] var3, T var4);
}

