/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.DormandPrince54StepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.EmbeddedRungeKuttaIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class DormandPrince54Integrator
extends EmbeddedRungeKuttaIntegrator {
    private static final String METHOD_NAME = "Dormand-Prince 5(4)";
    private static final double[] STATIC_C = new double[]{0.2, 0.3, 0.8, 0.8888888888888888, 1.0, 1.0};
    private static final double[][] STATIC_A = new double[][]{{0.2}, {0.075, 0.225}, {0.9777777777777777, -3.7333333333333334, 3.5555555555555554}, {2.9525986892242035, -11.595793324188385, 9.822892851699436, -0.2908093278463649}, {2.8462752525252526, -10.757575757575758, 8.906422717743473, 0.2784090909090909, -0.2735313036020583}, {0.09114583333333333, 0.0, 0.44923629829290207, 0.6510416666666666, -0.322376179245283, 0.13095238095238096}};
    private static final double[] STATIC_B = new double[]{0.09114583333333333, 0.0, 0.44923629829290207, 0.6510416666666666, -0.322376179245283, 0.13095238095238096, 0.0};
    private static final double E1 = 0.0012326388888888888;
    private static final double E3 = -0.0042527702905061394;
    private static final double E4 = 0.03697916666666667;
    private static final double E5 = -0.05086379716981132;
    private static final double E6 = 0.0419047619047619;
    private static final double E7 = -0.025;

    public DormandPrince54Integrator(double d2, double d3, double d4, double d5) {
        super(METHOD_NAME, true, STATIC_C, STATIC_A, STATIC_B, (RungeKuttaStepInterpolator)new DormandPrince54StepInterpolator(), d2, d3, d4, d5);
    }

    public DormandPrince54Integrator(double d2, double d3, double[] dArray, double[] dArray2) {
        super(METHOD_NAME, true, STATIC_C, STATIC_A, STATIC_B, (RungeKuttaStepInterpolator)new DormandPrince54StepInterpolator(), d2, d3, dArray, dArray2);
    }

    public int getOrder() {
        return 5;
    }

    protected double estimateError(double[][] dArray, double[] dArray2, double[] dArray3, double d2) {
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.mainSetDimension; ++i2) {
            double d4;
            double d5 = 0.0012326388888888888 * dArray[0][i2] + -0.0042527702905061394 * dArray[2][i2] + 0.03697916666666667 * dArray[3][i2] + -0.05086379716981132 * dArray[4][i2] + 0.0419047619047619 * dArray[5][i2] + -0.025 * dArray[6][i2];
            double d6 = FastMath.max(FastMath.abs(dArray2[i2]), FastMath.abs(dArray3[i2]));
            double d7 = this.vecAbsoluteTolerance == null ? this.scalAbsoluteTolerance + this.scalRelativeTolerance * d6 : this.vecAbsoluteTolerance[i2] + this.vecRelativeTolerance[i2] * d6;
            double d8 = d4 = d2 * d5 / d7;
            d3 += d8 * d8;
        }
        return FastMath.sqrt(d3 / (double)this.mainSetDimension);
    }
}

