/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldEquationsMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEStateAndDerivative;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.DormandPrince54FieldStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.EmbeddedRungeKuttaFieldIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DormandPrince54FieldIntegrator<T extends RealFieldElement<T>>
extends EmbeddedRungeKuttaFieldIntegrator<T> {
    private static final String METHOD_NAME = "Dormand-Prince 5(4)";
    private final T e1 = this.fraction(71, 57600);
    private final T e3 = this.fraction(-71, 16695);
    private final T e4 = this.fraction(71, 1920);
    private final T e5 = this.fraction(-17253, 339200);
    private final T e6 = this.fraction(22, 525);
    private final T e7 = this.fraction(-1, 40);

    public DormandPrince54FieldIntegrator(Field<T> field, double d2, double d3, double d4, double d5) {
        super(field, METHOD_NAME, 6, d2, d3, d4, d5);
    }

    public DormandPrince54FieldIntegrator(Field<T> field, double d2, double d3, double[] dArray, double[] dArray2) {
        super(field, METHOD_NAME, 6, d2, d3, dArray, dArray2);
    }

    @Override
    public T[] getC() {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(this.getField(), 6);
        RealFieldElement[] realFieldElementArray2 = realFieldElementArray;
        realFieldElementArray[0] = this.fraction(1, 5);
        realFieldElementArray2[1] = this.fraction(3, 10);
        realFieldElementArray2[2] = this.fraction(4, 5);
        realFieldElementArray2[3] = this.fraction(8, 9);
        realFieldElementArray2[4] = (RealFieldElement)this.getField().getOne();
        realFieldElementArray2[5] = (RealFieldElement)this.getField().getOne();
        return realFieldElementArray2;
    }

    @Override
    public T[][] getA() {
        RealFieldElement[][] realFieldElementArray = (RealFieldElement[][])MathArrays.buildArray(this.getField(), 6, -1);
        for (int i2 = 0; i2 < realFieldElementArray.length; ++i2) {
            realFieldElementArray[i2] = (RealFieldElement[])MathArrays.buildArray(this.getField(), i2 + 1);
        }
        realFieldElementArray[0][0] = this.fraction(1, 5);
        realFieldElementArray[1][0] = this.fraction(3, 40);
        realFieldElementArray[1][1] = this.fraction(9, 40);
        realFieldElementArray[2][0] = this.fraction(44, 45);
        realFieldElementArray[2][1] = this.fraction(-56, 15);
        realFieldElementArray[2][2] = this.fraction(32, 9);
        realFieldElementArray[3][0] = this.fraction(19372, 6561);
        realFieldElementArray[3][1] = this.fraction(-25360, 2187);
        realFieldElementArray[3][2] = this.fraction(64448, 6561);
        realFieldElementArray[3][3] = this.fraction(-212, 729);
        realFieldElementArray[4][0] = this.fraction(9017, 3168);
        realFieldElementArray[4][1] = this.fraction(-355, 33);
        realFieldElementArray[4][2] = this.fraction(46732, 5247);
        realFieldElementArray[4][3] = this.fraction(49, 176);
        realFieldElementArray[4][4] = this.fraction(-5103, 18656);
        realFieldElementArray[5][0] = this.fraction(35, 384);
        realFieldElementArray[5][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[5][2] = this.fraction(500, 1113);
        realFieldElementArray[5][3] = this.fraction(125, 192);
        realFieldElementArray[5][4] = this.fraction(-2187, 6784);
        realFieldElementArray[5][5] = this.fraction(11, 84);
        return realFieldElementArray;
    }

    @Override
    public T[] getB() {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(this.getField(), 7);
        RealFieldElement[] realFieldElementArray2 = realFieldElementArray;
        realFieldElementArray[0] = this.fraction(35, 384);
        realFieldElementArray2[1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray2[2] = this.fraction(500, 1113);
        realFieldElementArray2[3] = this.fraction(125, 192);
        realFieldElementArray2[4] = this.fraction(-2187, 6784);
        realFieldElementArray2[5] = this.fraction(11, 84);
        realFieldElementArray2[6] = (RealFieldElement)this.getField().getZero();
        return realFieldElementArray2;
    }

    @Override
    protected DormandPrince54FieldStepInterpolator<T> createInterpolator(boolean bl, T[][] TArray, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2, FieldEquationsMapper<T> fieldEquationsMapper) {
        return new DormandPrince54FieldStepInterpolator(this.getField(), bl, TArray, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldEquationsMapper);
    }

    @Override
    public int getOrder() {
        return 5;
    }

    @Override
    protected T estimateError(T[][] TArray, T[] TArray2, T[] TArray3, T realFieldElement) {
        RealFieldElement realFieldElement2 = (RealFieldElement)this.getField().getZero();
        for (int i2 = 0; i2 < this.mainSetDimension; ++i2) {
            RealFieldElement realFieldElement3 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][i2].multiply(this.e1)).add(TArray[2][i2].multiply(this.e3))).add(TArray[3][i2].multiply(this.e4))).add(TArray[4][i2].multiply(this.e5))).add(TArray[5][i2].multiply(this.e6))).add(TArray[6][i2].multiply(this.e7));
            RealFieldElement realFieldElement4 = MathUtils.max((RealFieldElement)TArray2[i2].abs(), (RealFieldElement)TArray3[i2].abs());
            realFieldElement4 = this.vecAbsoluteTolerance == null ? (RealFieldElement)((RealFieldElement)realFieldElement4.multiply(this.scalRelativeTolerance)).add(this.scalAbsoluteTolerance) : (RealFieldElement)((RealFieldElement)realFieldElement4.multiply(this.vecRelativeTolerance[i2])).add(this.vecAbsoluteTolerance[i2]);
            RealFieldElement realFieldElement5 = realFieldElement3 = realFieldElement.multiply((RealFieldElement)realFieldElement3).divide(realFieldElement4);
            realFieldElement2 = realFieldElement2.add(realFieldElement5.multiply(realFieldElement5));
        }
        return (T)((RealFieldElement)((RealFieldElement)realFieldElement2.divide(this.mainSetDimension)).sqrt());
    }
}

