/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldEquationsMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEStateAndDerivative;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.ClassicalRungeKuttaFieldStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.RungeKuttaFieldIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassicalRungeKuttaFieldIntegrator<T extends RealFieldElement<T>>
extends RungeKuttaFieldIntegrator<T> {
    public ClassicalRungeKuttaFieldIntegrator(Field<T> field, T t) {
        super(field, "classical Runge-Kutta", t);
    }

    @Override
    public T[] getC() {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(this.getField(), 3);
        RealFieldElement[] realFieldElementArray2 = realFieldElementArray;
        realFieldElementArray[0] = (RealFieldElement)((RealFieldElement)this.getField().getOne()).multiply(0.5);
        realFieldElementArray2[1] = realFieldElementArray2[0];
        realFieldElementArray2[2] = (RealFieldElement)this.getField().getOne();
        return realFieldElementArray2;
    }

    @Override
    public T[][] getA() {
        RealFieldElement[][] realFieldElementArray = (RealFieldElement[][])MathArrays.buildArray(this.getField(), 3, -1);
        for (int i2 = 0; i2 < realFieldElementArray.length; ++i2) {
            realFieldElementArray[i2] = (RealFieldElement[])MathArrays.buildArray(this.getField(), i2 + 1);
        }
        realFieldElementArray[0][0] = this.fraction(1, 2);
        realFieldElementArray[1][0] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[1][1] = realFieldElementArray[0][0];
        realFieldElementArray[2][0] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[2][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[2][2] = (RealFieldElement)this.getField().getOne();
        return realFieldElementArray;
    }

    @Override
    public T[] getB() {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(this.getField(), 4);
        RealFieldElement[] realFieldElementArray2 = realFieldElementArray;
        realFieldElementArray[0] = this.fraction(1, 6);
        realFieldElementArray2[1] = this.fraction(1, 3);
        realFieldElementArray2[2] = realFieldElementArray2[1];
        realFieldElementArray2[3] = realFieldElementArray2[0];
        return realFieldElementArray2;
    }

    @Override
    protected ClassicalRungeKuttaFieldStepInterpolator<T> createInterpolator(boolean bl, T[][] TArray, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2, FieldEquationsMapper<T> fieldEquationsMapper) {
        return new ClassicalRungeKuttaFieldStepInterpolator(this.getField(), bl, TArray, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldEquationsMapper);
    }
}

