/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.AbstractIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.ExpandableStatefulODE;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public abstract class AdaptiveStepsizeIntegrator
extends AbstractIntegrator {
    protected double scalAbsoluteTolerance;
    protected double scalRelativeTolerance;
    protected double[] vecAbsoluteTolerance;
    protected double[] vecRelativeTolerance;
    protected int mainSetDimension;
    private double initialStep;
    private double minStep;
    private double maxStep;

    public AdaptiveStepsizeIntegrator(String string, double d2, double d3, double d4, double d5) {
        super(string);
        this.setStepSizeControl(d2, d3, d4, d5);
        this.resetInternalState();
    }

    public AdaptiveStepsizeIntegrator(String string, double d2, double d3, double[] dArray, double[] dArray2) {
        super(string);
        this.setStepSizeControl(d2, d3, dArray, dArray2);
        this.resetInternalState();
    }

    public void setStepSizeControl(double d2, double d3, double d4, double d5) {
        this.minStep = FastMath.abs(d2);
        this.maxStep = FastMath.abs(d3);
        this.initialStep = -1.0;
        this.scalAbsoluteTolerance = d4;
        this.scalRelativeTolerance = d5;
        this.vecAbsoluteTolerance = null;
        this.vecRelativeTolerance = null;
    }

    public void setStepSizeControl(double d2, double d3, double[] dArray, double[] dArray2) {
        this.minStep = FastMath.abs(d2);
        this.maxStep = FastMath.abs(d3);
        this.initialStep = -1.0;
        this.scalAbsoluteTolerance = 0.0;
        this.scalRelativeTolerance = 0.0;
        this.vecAbsoluteTolerance = (double[])dArray.clone();
        this.vecRelativeTolerance = (double[])dArray2.clone();
    }

    public void setInitialStepSize(double d2) {
        if (d2 < this.minStep || d2 > this.maxStep) {
            this.initialStep = -1.0;
            return;
        }
        this.initialStep = d2;
    }

    protected void sanityChecks(ExpandableStatefulODE expandableStatefulODE, double d2) {
        super.sanityChecks(expandableStatefulODE, d2);
        this.mainSetDimension = expandableStatefulODE.getPrimaryMapper().getDimension();
        if (this.vecAbsoluteTolerance != null && this.vecAbsoluteTolerance.length != this.mainSetDimension) {
            throw new DimensionMismatchException(this.mainSetDimension, this.vecAbsoluteTolerance.length);
        }
        if (this.vecRelativeTolerance != null && this.vecRelativeTolerance.length != this.mainSetDimension) {
            throw new DimensionMismatchException(this.mainSetDimension, this.vecRelativeTolerance.length);
        }
    }

    public double initializeStep(boolean bl, int n, double[] dArray, double d2, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        double d3;
        double d4;
        double d5;
        double d6;
        if (this.initialStep > 0.0) {
            if (bl) {
                return this.initialStep;
            }
            return -this.initialStep;
        }
        double d7 = 0.0;
        double d8 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d9 = d6 = dArray2[i2] / dArray[i2];
            d7 += d9 * d9;
            double d10 = d6 = dArray3[i2] / dArray[i2];
            d8 += d10 * d10;
        }
        double d11 = d5 = d7 < 1.0E-10 || d8 < 1.0E-10 ? 1.0E-6 : 0.01 * FastMath.sqrt(d7 / d8);
        if (!bl) {
            d5 = -d5;
        }
        for (int i3 = 0; i3 < dArray2.length; ++i3) {
            dArray4[i3] = dArray2[i3] + d5 * dArray3[i3];
        }
        this.computeDerivatives(d2 + d5, dArray4, dArray5);
        double d12 = 0.0;
        for (int i4 = 0; i4 < dArray.length; ++i4) {
            double d13 = d6 = (dArray5[i4] - dArray3[i4]) / dArray[i4];
            d12 += d13 * d13;
        }
        d12 = FastMath.sqrt(d12) / d5;
        double d14 = FastMath.max(FastMath.sqrt(d8), d12);
        double d15 = d4 < 1.0E-15 ? FastMath.max(1.0E-6, 0.001 * FastMath.abs(d5)) : FastMath.pow(0.01 / d14, 1.0 / (double)n);
        d5 = FastMath.min(100.0 * FastMath.abs(d5), d15);
        d5 = FastMath.max(d5, 1.0E-12 * FastMath.abs(d2));
        if (d3 < this.getMinStep()) {
            d5 = this.getMinStep();
        }
        if (d5 > this.getMaxStep()) {
            d5 = this.getMaxStep();
        }
        if (!bl) {
            d5 = -d5;
        }
        return d5;
    }

    protected double filterStep(double d2, boolean bl, boolean bl2) {
        double d3 = d2;
        if (FastMath.abs(d2) < this.minStep) {
            if (bl2) {
                d3 = bl ? this.minStep : -this.minStep;
            } else {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.MINIMAL_STEPSIZE_REACHED_DURING_INTEGRATION, (Number)FastMath.abs(d2), this.minStep, true);
            }
        }
        if (d3 > this.maxStep) {
            d3 = this.maxStep;
        } else if (d3 < -this.maxStep) {
            d3 = -this.maxStep;
        }
        return d3;
    }

    public abstract void integrate(ExpandableStatefulODE var1, double var2);

    public double getCurrentStepStart() {
        return this.stepStart;
    }

    protected void resetInternalState() {
        this.stepStart = Double.NaN;
        this.stepSize = FastMath.sqrt(this.minStep * this.maxStep);
    }

    public double getMinStep() {
        return this.minStep;
    }

    public double getMaxStep() {
        return this.maxStep;
    }
}

