/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.AbstractFieldIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldEquationsMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEState;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEStateAndDerivative;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdaptiveStepsizeFieldIntegrator<T extends RealFieldElement<T>>
extends AbstractFieldIntegrator<T> {
    protected double scalAbsoluteTolerance;
    protected double scalRelativeTolerance;
    protected double[] vecAbsoluteTolerance;
    protected double[] vecRelativeTolerance;
    protected int mainSetDimension;
    private T initialStep;
    private T minStep;
    private T maxStep;

    public AdaptiveStepsizeFieldIntegrator(Field<T> field, String string, double d2, double d3, double d4, double d5) {
        super(field, string);
        this.setStepSizeControl(d2, d3, d4, d5);
        this.resetInternalState();
    }

    public AdaptiveStepsizeFieldIntegrator(Field<T> field, String string, double d2, double d3, double[] dArray, double[] dArray2) {
        super(field, string);
        this.setStepSizeControl(d2, d3, dArray, dArray2);
        this.resetInternalState();
    }

    public void setStepSizeControl(double d2, double d3, double d4, double d5) {
        this.minStep = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(FastMath.abs(d2));
        this.maxStep = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(FastMath.abs(d3));
        this.initialStep = (RealFieldElement)((RealFieldElement)this.getField().getOne()).negate();
        this.scalAbsoluteTolerance = d4;
        this.scalRelativeTolerance = d5;
        this.vecAbsoluteTolerance = null;
        this.vecRelativeTolerance = null;
    }

    public void setStepSizeControl(double d2, double d3, double[] dArray, double[] dArray2) {
        this.minStep = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(FastMath.abs(d2));
        this.maxStep = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(FastMath.abs(d3));
        this.initialStep = (RealFieldElement)((RealFieldElement)this.getField().getOne()).negate();
        this.scalAbsoluteTolerance = 0.0;
        this.scalRelativeTolerance = 0.0;
        this.vecAbsoluteTolerance = (double[])dArray.clone();
        this.vecRelativeTolerance = (double[])dArray2.clone();
    }

    public void setInitialStepSize(T t) {
        if (((RealFieldElement)t.subtract(this.minStep)).getReal() < 0.0 || ((RealFieldElement)t.subtract(this.maxStep)).getReal() > 0.0) {
            this.initialStep = (RealFieldElement)((RealFieldElement)this.getField().getOne()).negate();
            return;
        }
        this.initialStep = t;
    }

    @Override
    protected void sanityChecks(FieldODEState<T> fieldODEState, T t) {
        super.sanityChecks(fieldODEState, t);
        this.mainSetDimension = fieldODEState.getStateDimension();
        if (this.vecAbsoluteTolerance != null && this.vecAbsoluteTolerance.length != this.mainSetDimension) {
            throw new DimensionMismatchException(this.mainSetDimension, this.vecAbsoluteTolerance.length);
        }
        if (this.vecRelativeTolerance != null && this.vecRelativeTolerance.length != this.mainSetDimension) {
            throw new DimensionMismatchException(this.mainSetDimension, this.vecRelativeTolerance.length);
        }
    }

    public T initializeStep(boolean bl, int n, T[] TArray, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldEquationsMapper<T> realFieldElementArray) {
        Object object;
        Object object2;
        Object object3;
        if (this.initialStep.getReal() > 0.0) {
            if (bl) {
                return this.initialStep;
            }
            return (T)((RealFieldElement)this.initialStep.negate());
        }
        Object object4 = realFieldElementArray.mapState(fieldODEStateAndDerivative);
        realFieldElementArray = realFieldElementArray.mapDerivative(fieldODEStateAndDerivative);
        RealFieldElement realFieldElement = (RealFieldElement)this.getField().getZero();
        RealFieldElement realFieldElement2 = (RealFieldElement)this.getField().getZero();
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            RealFieldElement realFieldElement3;
            object3 = (RealFieldElement[])object4[i2].divide(TArray[i2]);
            realFieldElement = realFieldElement.add(object3.multiply(object3));
            RealFieldElement realFieldElement4 = realFieldElement3 = (RealFieldElement)realFieldElementArray[i2].divide(TArray[i2]);
            realFieldElement2 = realFieldElement2.add(realFieldElement4.multiply(realFieldElement4));
        }
        Object object5 = object2 = realFieldElement.getReal() < 1.0E-10 || realFieldElement2.getReal() < 1.0E-10 ? (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(1.0E-6) : (RealFieldElement)((RealFieldElement)realFieldElement.divide(realFieldElement2).sqrt()).multiply(0.01);
        if (!bl) {
            object2 = (RealFieldElement)object2.negate();
        }
        object3 = (RealFieldElement[])MathArrays.buildArray(this.getField(), ((RealFieldElement[])object4).length);
        for (int i3 = 0; i3 < ((RealFieldElement[])object4).length; ++i3) {
            object3[i3] = object4[i3].add(realFieldElementArray[i3].multiply(object2));
        }
        RealFieldElement[] realFieldElementArray2 = this.computeDerivatives(fieldODEStateAndDerivative.getTime().add((RealFieldElement)object2), (RealFieldElement[])object3);
        object4 = (RealFieldElement)this.getField().getZero();
        for (int i4 = 0; i4 < TArray.length; ++i4) {
            Object object6 = object3 = (RealFieldElement)realFieldElementArray2[i4].subtract(realFieldElementArray[i4]).divide(TArray[i4]);
            object4 = (RealFieldElement)object4.add(object6.multiply(object6));
        }
        object4 = ((RealFieldElement)object4.sqrt()).divide(object2);
        Object object7 = MathUtils.max((RealFieldElement)realFieldElement2.sqrt(), object4);
        object3 = object.getReal() < 1.0E-15 ? MathUtils.max((RealFieldElement)((RealFieldElement)this.getField().getZero()).add(1.0E-6), (RealFieldElement)((RealFieldElement)object2.abs()).multiply(0.001)) : (RealFieldElement)((RealFieldElement)((RealFieldElement)object7.multiply(100)).reciprocal()).pow(1.0 / (double)n);
        object2 = MathUtils.min((RealFieldElement)((RealFieldElement)object2.abs()).multiply(100), object3);
        object2 = MathUtils.max(object2, (RealFieldElement)((RealFieldElement)fieldODEStateAndDerivative.getTime().abs()).multiply(1.0E-12));
        object2 = MathUtils.max(this.minStep, MathUtils.min(this.maxStep, object2));
        if (!bl) {
            object2 = (RealFieldElement)object2.negate();
        }
        return (T)object2;
    }

    protected T filterStep(T t, boolean bl, boolean bl2) {
        Object object = t;
        if (((RealFieldElement)((RealFieldElement)t.abs()).subtract(this.minStep)).getReal() < 0.0) {
            if (bl2) {
                object = bl ? this.minStep : (RealFieldElement)this.minStep.negate();
            } else {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.MINIMAL_STEPSIZE_REACHED_DURING_INTEGRATION, (Number)((RealFieldElement)t.abs()).getReal(), this.minStep.getReal(), true);
            }
        }
        if (((RealFieldElement)object.subtract(this.maxStep)).getReal() > 0.0) {
            object = this.maxStep;
        } else if (((RealFieldElement)object.add(this.maxStep)).getReal() < 0.0) {
            object = (RealFieldElement)this.maxStep.negate();
        }
        return object;
    }

    protected void resetInternalState() {
        this.setStepStart(null);
        AdaptiveStepsizeFieldIntegrator adaptiveStepsizeFieldIntegrator = this;
        adaptiveStepsizeFieldIntegrator.setStepSize((RealFieldElement)((RealFieldElement)adaptiveStepsizeFieldIntegrator.minStep.multiply(this.maxStep)).sqrt());
    }

    public T getMinStep() {
        return this.minStep;
    }

    public T getMaxStep() {
        return this.maxStep;
    }
}

