/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.fraction.BigFraction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowFieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayFieldVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldDecompositionSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldLUDecomposition;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.QRDecomposition;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealLinearOperator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdamsNordsieckTransformer {
    private static final Map<Integer, AdamsNordsieckTransformer> CACHE = new HashMap<Integer, AdamsNordsieckTransformer>();
    private final Array2DRowRealMatrix update;
    private final double[] c1;

    private AdamsNordsieckTransformer(int n) {
        FieldElement[][] fieldElementArray = this.buildP(--n);
        FieldDecompositionSolver<BigFraction> fieldDecompositionSolver = new FieldLUDecomposition<BigFraction>((FieldMatrix<BigFraction>)fieldElementArray).getSolver();
        Object[] objectArray = new BigFraction[n];
        Arrays.fill(objectArray, BigFraction.ONE);
        objectArray = (BigFraction[])fieldDecompositionSolver.solve(new ArrayFieldVector((FieldElement[])objectArray, false)).toArray();
        fieldElementArray = (BigFraction[][])fieldElementArray.getData();
        for (int i2 = fieldElementArray.length - 1; i2 > 0; --i2) {
            fieldElementArray[i2] = fieldElementArray[i2 - 1];
        }
        fieldElementArray[0] = new BigFraction[n];
        Arrays.fill(fieldElementArray[0], BigFraction.ZERO);
        FieldMatrix<BigFraction> fieldMatrix = fieldDecompositionSolver.solve(new Array2DRowFieldMatrix(fieldElementArray, false));
        this.update = MatrixUtils.bigFractionMatrixToRealMatrix(fieldMatrix);
        this.c1 = new double[n];
        for (int i3 = 0; i3 < n; ++i3) {
            this.c1[i3] = ((BigFraction)objectArray[i3]).doubleValue();
        }
    }

    public static AdamsNordsieckTransformer getInstance(int n) {
        Map<Integer, AdamsNordsieckTransformer> map = CACHE;
        synchronized (map) {
            AdamsNordsieckTransformer adamsNordsieckTransformer = CACHE.get(n);
            if (adamsNordsieckTransformer == null) {
                adamsNordsieckTransformer = new AdamsNordsieckTransformer(n);
                CACHE.put(n, adamsNordsieckTransformer);
            }
            return adamsNordsieckTransformer;
        }
    }

    @Deprecated
    public int getNSteps() {
        return this.c1.length;
    }

    private FieldMatrix<BigFraction> buildP(int n) {
        int n2 = n;
        FieldElement[][] fieldElementArray = new BigFraction[n2][n2];
        for (int i2 = 1; i2 <= fieldElementArray.length; ++i2) {
            int n3;
            BigFraction[] bigFractionArray = fieldElementArray[i2 - 1];
            int n4 = n3 = -i2;
            for (int i3 = 1; i3 <= bigFractionArray.length; ++i3) {
                bigFractionArray[i3 - 1] = new BigFraction(n4 * (i3 + 1));
                n4 *= n3;
            }
        }
        return new Array2DRowFieldMatrix(fieldElementArray, false);
    }

    public Array2DRowRealMatrix initializeHighOrderDerivatives(double d2, double[] dArray, double[][] dArray2, double[][] dArray3) {
        double[][] dArray4 = new double[this.c1.length + 1][this.c1.length + 1];
        double[][] dArray5 = new double[this.c1.length + 1][dArray2[0].length];
        double[] dArray6 = dArray2[0];
        double[] dArray7 = dArray3[0];
        for (int i2 = 1; i2 < dArray2.length; ++i2) {
            double d3 = dArray[i2] - dArray[0];
            double d4 = d3 / d2;
            double d5 = 1.0 / d2;
            double[] dArray8 = dArray4[2 * i2 - 2];
            double[] dArray9 = 2 * i2 - 1 < dArray4.length ? dArray4[2 * i2 - 1] : null;
            for (int i3 = 0; i3 < dArray8.length; ++i3) {
                dArray8[i3] = d3 * (d5 *= d4);
                if (dArray9 == null) continue;
                int n = i3;
                dArray9[n] = (double)(n + 2) * d5;
            }
            double[] dArray10 = dArray2[i2];
            double[] dArray11 = dArray3[i2];
            double[] dArray12 = dArray5[2 * i2 - 2];
            double[] dArray13 = 2 * i2 - 1 < dArray5.length ? dArray5[2 * i2 - 1] : null;
            for (int i4 = 0; i4 < dArray10.length; ++i4) {
                dArray12[i4] = dArray10[i4] - dArray6[i4] - d3 * dArray7[i4];
                if (dArray13 == null) continue;
                dArray13[i4] = dArray11[i4] - dArray7[i4];
            }
        }
        QRDecomposition qRDecomposition = new QRDecomposition(new Array2DRowRealMatrix(dArray4, false));
        RealMatrix realMatrix = qRDecomposition.getSolver().solve(new Array2DRowRealMatrix(dArray5, false));
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(realMatrix.getRowDimension() - 1, realMatrix.getColumnDimension());
        for (int i5 = 0; i5 < ((RealLinearOperator)array2DRowRealMatrix).getRowDimension(); ++i5) {
            for (int i6 = 0; i6 < ((RealLinearOperator)array2DRowRealMatrix).getColumnDimension(); ++i6) {
                ((AbstractRealMatrix)array2DRowRealMatrix).setEntry(i5, i6, realMatrix.getEntry(i5, i6));
            }
        }
        return array2DRowRealMatrix;
    }

    public Array2DRowRealMatrix updateHighOrderDerivativesPhase1(Array2DRowRealMatrix array2DRowRealMatrix) {
        return this.update.multiply(array2DRowRealMatrix);
    }

    public void updateHighOrderDerivativesPhase2(double[] dArray, double[] dArray2, Array2DRowRealMatrix object) {
        object = ((Array2DRowRealMatrix)object).getDataRef();
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            Object object2 = object[i2];
            double d2 = this.c1[i2];
            for (int i3 = 0; i3 < ((Object)object2).length; ++i3) {
                Object object3 = object2;
                int n = i3;
                object3[n] = object3[n] + d2 * (dArray[i3] - dArray2[i3]);
            }
        }
    }
}

