/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.FieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowFieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.ArrayFieldVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldDecompositionSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldLUDecomposition;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdamsNordsieckFieldTransformer<T extends RealFieldElement<T>> {
    private static final Map<Integer, Map<Field<? extends RealFieldElement<?>>, AdamsNordsieckFieldTransformer<? extends RealFieldElement<?>>>> CACHE = new HashMap();
    private final Field<T> field;
    private final Array2DRowFieldMatrix<T> update;
    private final T[] c1;

    private AdamsNordsieckFieldTransformer(Field<T> field, int n) {
        this.field = field;
        FieldElement[][] fieldElementArray = this.buildP(--n);
        FieldDecompositionSolver<T> fieldDecompositionSolver = new FieldLUDecomposition<T>(fieldElementArray).getSolver();
        Object[] objectArray = (RealFieldElement[])MathArrays.buildArray(field, n);
        Arrays.fill(objectArray, field.getOne());
        this.c1 = (RealFieldElement[])fieldDecompositionSolver.solve(new ArrayFieldVector((FieldElement[])objectArray, false)).toArray();
        fieldElementArray = (RealFieldElement[][])fieldElementArray.getData();
        for (int i2 = fieldElementArray.length - 1; i2 > 0; --i2) {
            fieldElementArray[i2] = fieldElementArray[i2 - 1];
        }
        fieldElementArray[0] = (RealFieldElement[])MathArrays.buildArray(field, n);
        Arrays.fill(fieldElementArray[0], field.getZero());
        this.update = new Array2DRowFieldMatrix(fieldDecompositionSolver.solve(new Array2DRowFieldMatrix(fieldElementArray, false)).getData());
    }

    public static <T extends RealFieldElement<T>> AdamsNordsieckFieldTransformer<T> getInstance(Field<T> field, int n) {
        Map<Integer, Map<Field<? extends RealFieldElement<?>>, AdamsNordsieckFieldTransformer<? extends RealFieldElement<?>>>> map = CACHE;
        synchronized (map) {
            AdamsNordsieckFieldTransformer<RealFieldElement<Object>> adamsNordsieckFieldTransformer;
            Map<Field<RealFieldElement<?>>, AdamsNordsieckFieldTransformer<RealFieldElement<?>>> map2 = CACHE.get(n);
            if (map2 == null) {
                map2 = new HashMap();
                CACHE.put(n, map2);
            }
            if ((adamsNordsieckFieldTransformer = map2.get(field)) == null) {
                adamsNordsieckFieldTransformer = new AdamsNordsieckFieldTransformer<T>(field, n);
                map2.put(field, adamsNordsieckFieldTransformer);
            }
            return adamsNordsieckFieldTransformer;
        }
    }

    private FieldMatrix<T> buildP(int n) {
        int n2 = n;
        FieldElement[][] fieldElementArray = (RealFieldElement[][])MathArrays.buildArray(this.field, n2, n2);
        for (int i2 = 1; i2 <= fieldElementArray.length; ++i2) {
            RealFieldElement[] realFieldElementArray = fieldElementArray[i2 - 1];
            int n3 = -i2;
            RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)this.field.getZero()).add(n3);
            for (int i3 = 1; i3 <= realFieldElementArray.length; ++i3) {
                realFieldElementArray[i3 - 1] = (RealFieldElement)realFieldElement.multiply(i3 + 1);
                realFieldElement = (RealFieldElement)realFieldElement.multiply(n3);
            }
        }
        return new Array2DRowFieldMatrix(fieldElementArray, false);
    }

    public Array2DRowFieldMatrix<T> initializeHighOrderDerivatives(T t, T[] TArray, T[][] TArray2, T[][] TArray3) {
        T[] TArray4;
        Object object;
        FieldElement[][] fieldElementArray = (RealFieldElement[][])MathArrays.buildArray(this.field, this.c1.length + 1, this.c1.length + 1);
        FieldElement[][] fieldElementArray2 = (RealFieldElement[][])MathArrays.buildArray(this.field, this.c1.length + 1, TArray2[0].length);
        T[] TArray5 = TArray2[0];
        T[] TArray6 = TArray3[0];
        for (int i2 = 1; i2 < TArray2.length; ++i2) {
            object = (RealFieldElement)TArray[i2].subtract(TArray[0]);
            TArray4 = (RealFieldElement)object.divide(t);
            FieldElement[] fieldElementArray3 = (FieldElement[])t.reciprocal();
            FieldElement[] fieldElementArray4 = fieldElementArray[2 * i2 - 2];
            FieldElement[] fieldElementArray5 = 2 * i2 - 1 < fieldElementArray.length ? fieldElementArray[2 * i2 - 1] : null;
            for (int i3 = 0; i3 < fieldElementArray4.length; ++i3) {
                fieldElementArray3 = (RealFieldElement)fieldElementArray3.multiply(TArray4);
                fieldElementArray4[i3] = object.multiply(fieldElementArray3);
                if (fieldElementArray5 == null) continue;
                fieldElementArray5[i3] = (RealFieldElement)fieldElementArray3.multiply(i3 + 2);
            }
            T[] TArray7 = TArray2[i2];
            TArray4 = TArray3[i2];
            fieldElementArray3 = fieldElementArray2[2 * i2 - 2];
            fieldElementArray4 = 2 * i2 - 1 < fieldElementArray2.length ? fieldElementArray2[2 * i2 - 1] : null;
            for (int i4 = 0; i4 < TArray7.length; ++i4) {
                fieldElementArray3[i4] = (RealFieldElement)((RealFieldElement)TArray7[i4].subtract(TArray5[i4])).subtract(object.multiply(TArray6[i4]));
                if (fieldElementArray4 == null) continue;
                fieldElementArray4[i4] = (RealFieldElement)TArray4[i4].subtract(TArray6[i4]);
            }
        }
        FieldLUDecomposition fieldLUDecomposition = new FieldLUDecomposition(new Array2DRowFieldMatrix(fieldElementArray, false));
        object = fieldLUDecomposition.getSolver().solve(new Array2DRowFieldMatrix(fieldElementArray2, false));
        TArray4 = new Array2DRowFieldMatrix<T>(this.field, object.getRowDimension() - 1, object.getColumnDimension());
        for (int i5 = 0; i5 < TArray4.getRowDimension(); ++i5) {
            for (int i6 = 0; i6 < TArray4.getColumnDimension(); ++i6) {
                TArray4.setEntry(i5, i6, object.getEntry(i5, i6));
            }
        }
        return TArray4;
    }

    public Array2DRowFieldMatrix<T> updateHighOrderDerivativesPhase1(Array2DRowFieldMatrix<T> array2DRowFieldMatrix) {
        return this.update.multiply(array2DRowFieldMatrix);
    }

    public void updateHighOrderDerivativesPhase2(T[] TArray, T[] TArray2, Array2DRowFieldMatrix<T> realFieldElementArray) {
        realFieldElementArray = (RealFieldElement[][])realFieldElementArray.getDataRef();
        for (int i2 = 0; i2 < realFieldElementArray.length; ++i2) {
            RealFieldElement[] realFieldElementArray2 = realFieldElementArray[i2];
            T t = this.c1[i2];
            for (int i3 = 0; i3 < realFieldElementArray2.length; ++i3) {
                realFieldElementArray2[i3] = (RealFieldElement)realFieldElementArray2[i3].add(t.multiply(TArray[i3].subtract(TArray2[i3])));
            }
        }
    }
}

