/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.EquationsMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.ExpandableStatefulODE;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.AdamsIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.AdamsMoultonIntegrator$Corrector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.NordsieckStepInterpolator;

public class AdamsMoultonIntegrator
extends AdamsIntegrator {
    private static final String METHOD_NAME = "Adams-Moulton";

    public AdamsMoultonIntegrator(int n, double d2, double d3, double d4, double d5) {
        int n2 = n;
        super(METHOD_NAME, n2, n2 + 1, d2, d3, d4, d5);
    }

    public AdamsMoultonIntegrator(int n, double d2, double d3, double[] dArray, double[] dArray2) {
        int n2 = n;
        super(METHOD_NAME, n2, n2 + 1, d2, d3, dArray, dArray2);
    }

    public void integrate(ExpandableStatefulODE expandableStatefulODE, double d2) {
        this.sanityChecks(expandableStatefulODE, d2);
        this.setEquations(expandableStatefulODE);
        boolean bl = d2 > expandableStatefulODE.getTime();
        double[] dArray = expandableStatefulODE.getCompleteState();
        double[] dArray2 = (double[])dArray.clone();
        double[] dArray3 = new double[dArray2.length];
        double[] dArray4 = new double[dArray2.length];
        double[] dArray5 = new double[dArray2.length];
        Array2DRowRealMatrix array2DRowRealMatrix = null;
        NordsieckStepInterpolator nordsieckStepInterpolator = new NordsieckStepInterpolator();
        nordsieckStepInterpolator.reinitialize(dArray2, bl, expandableStatefulODE.getPrimaryMapper(), expandableStatefulODE.getSecondaryMappers());
        this.initIntegration(expandableStatefulODE.getTime(), dArray, d2);
        this.start(expandableStatefulODE.getTime(), dArray2, d2);
        nordsieckStepInterpolator.reinitialize(this.stepStart, this.stepSize, this.scaled, this.nordsieck);
        nordsieckStepInterpolator.storeTime(this.stepStart);
        double d3 = this.stepSize;
        nordsieckStepInterpolator.rescale(d3);
        this.isLastStep = false;
        do {
            boolean bl2;
            Object object;
            double d4;
            double d5 = 10.0;
            while (d5 >= 1.0) {
                double d6;
                this.stepSize = d3;
                d4 = this.stepStart + this.stepSize;
                nordsieckStepInterpolator.setInterpolatedTime(d4);
                ExpandableStatefulODE expandableStatefulODE2 = this.getExpandable();
                object = expandableStatefulODE2;
                EquationsMapper equationsMapper = expandableStatefulODE2.getPrimaryMapper();
                equationsMapper.insertEquationData(nordsieckStepInterpolator.getInterpolatedState(), dArray4);
                int n = 0;
                for (EquationsMapper equationsMapper2 : ((ExpandableStatefulODE)object).getSecondaryMappers()) {
                    equationsMapper2.insertEquationData(nordsieckStepInterpolator.getInterpolatedSecondaryState(n), dArray4);
                    ++n;
                }
                this.computeDerivatives(d4, dArray4, dArray3);
                for (int i2 = 0; i2 < dArray.length; ++i2) {
                    dArray5[i2] = this.stepSize * dArray3[i2];
                }
                AdamsMoultonIntegrator adamsMoultonIntegrator = this;
                array2DRowRealMatrix = adamsMoultonIntegrator.updateHighOrderDerivativesPhase1(adamsMoultonIntegrator.nordsieck);
                AdamsMoultonIntegrator adamsMoultonIntegrator2 = this;
                adamsMoultonIntegrator2.updateHighOrderDerivativesPhase2(adamsMoultonIntegrator2.scaled, dArray5, array2DRowRealMatrix);
                d5 = array2DRowRealMatrix.walkInOptimizedOrder(new AdamsMoultonIntegrator$Corrector(this, dArray2, dArray5, dArray4));
                if (!(d6 >= 1.0)) continue;
                double d7 = this.computeStepGrowShrinkFactor(d5);
                AdamsMoultonIntegrator adamsMoultonIntegrator3 = this;
                d3 = adamsMoultonIntegrator3.filterStep(adamsMoultonIntegrator3.stepSize * d7, bl, false);
                nordsieckStepInterpolator.rescale(d3);
            }
            d4 = this.stepStart + this.stepSize;
            this.computeDerivatives(d4, dArray4, dArray3);
            object = new double[dArray.length];
            for (int i3 = 0; i3 < dArray.length; ++i3) {
                object[i3] = this.stepSize * dArray3[i3];
            }
            this.updateHighOrderDerivativesPhase2(dArray5, (double[])object, array2DRowRealMatrix);
            System.arraycopy(dArray4, 0, dArray2, 0, dArray2.length);
            nordsieckStepInterpolator.reinitialize(d4, this.stepSize, (double[])object, array2DRowRealMatrix);
            nordsieckStepInterpolator.storeTime(this.stepStart);
            nordsieckStepInterpolator.shift();
            nordsieckStepInterpolator.storeTime(d4);
            this.stepStart = this.acceptStep(nordsieckStepInterpolator, dArray2, dArray3, d2);
            this.scaled = (double[])object;
            this.nordsieck = array2DRowRealMatrix;
            if (this.isLastStep) continue;
            nordsieckStepInterpolator.storeTime(this.stepStart);
            if (this.resetOccurred) {
                AdamsMoultonIntegrator adamsMoultonIntegrator = this;
                adamsMoultonIntegrator.start(adamsMoultonIntegrator.stepStart, dArray2, d2);
                nordsieckStepInterpolator.reinitialize(this.stepStart, this.stepSize, this.scaled, this.nordsieck);
            }
            double d8 = this.computeStepGrowShrinkFactor(d5);
            double d9 = this.stepSize * d8;
            double d10 = this.stepStart + d9;
            boolean bl3 = bl ? d10 >= d2 : d10 <= d2;
            d3 = this.filterStep(d9, bl, bl3);
            double d11 = this.stepStart + d3;
            boolean bl4 = bl ? d11 >= d2 : (bl2 = d11 <= d2);
            if (bl4) {
                d3 = d2 - this.stepStart;
            }
            nordsieckStepInterpolator.rescale(d3);
        } while (!this.isLastStep);
        expandableStatefulODE.setTime(this.stepStart);
        expandableStatefulODE.setCompleteState(dArray2);
        this.resetInternalState();
    }
}

