/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowFieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldExpandableODE;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEState;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEStateAndDerivative;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.AdamsFieldIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.AdamsFieldStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.AdamsMoultonFieldIntegrator$Corrector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdamsMoultonFieldIntegrator<T extends RealFieldElement<T>>
extends AdamsFieldIntegrator<T> {
    private static final String METHOD_NAME = "Adams-Moulton";

    public AdamsMoultonFieldIntegrator(Field<T> field, int n, double d2, double d3, double d4, double d5) {
        int n2 = n;
        super(field, METHOD_NAME, n2, n2 + 1, d2, d3, d4, d5);
    }

    public AdamsMoultonFieldIntegrator(Field<T> field, int n, double d2, double d3, double[] dArray, double[] dArray2) {
        int n2 = n;
        super(field, METHOD_NAME, n2, n2 + 1, d2, d3, dArray, dArray2);
    }

    @Override
    public FieldODEStateAndDerivative<T> integrate(FieldExpandableODE<T> fieldExpandableODE, FieldODEState<T> fieldODEState, T t) {
        Object object;
        this.sanityChecks(fieldODEState, t);
        Object object2 = fieldODEState.getTime();
        RealFieldElement[] realFieldElementArray = fieldExpandableODE.getMapper().mapState(fieldODEState);
        AdamsMoultonFieldIntegrator adamsMoultonFieldIntegrator = this;
        adamsMoultonFieldIntegrator.setStepStart(adamsMoultonFieldIntegrator.initIntegration(fieldExpandableODE, (RealFieldElement)object2, realFieldElementArray, (RealFieldElement)t));
        boolean bl = ((RealFieldElement)t.subtract(fieldODEState.getTime())).getReal() > 0.0;
        this.start(fieldExpandableODE, this.getStepStart(), t);
        object2 = this.getStepStart();
        object2 = AdamsFieldStepInterpolator.taylor(object2, (RealFieldElement)((RealFieldElement)((FieldODEState)object2).getTime().add(this.getStepSize())), this.getStepSize(), this.scaled, this.nordsieck);
        this.setIsLastStep(false);
        do {
            boolean bl2;
            RealFieldElement[] realFieldElementArray2;
            object = null;
            RealFieldElement[] realFieldElementArray3 = (RealFieldElement[])MathArrays.buildArray(this.getField(), realFieldElementArray.length);
            Array2DRowFieldMatrix array2DRowFieldMatrix = null;
            RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(10.0);
            while (((RealFieldElement)realFieldElement.subtract(1.0)).getReal() >= 0.0) {
                RealFieldElement realFieldElement2;
                object = object2.getState();
                realFieldElementArray2 = this.computeDerivatives((RealFieldElement)((FieldODEState)object2).getTime(), (RealFieldElement[])object);
                for (int i2 = 0; i2 < realFieldElementArray3.length; ++i2) {
                    realFieldElementArray3[i2] = this.getStepSize().multiply((RealFieldElement)realFieldElementArray2[i2]);
                }
                AdamsMoultonFieldIntegrator adamsMoultonFieldIntegrator2 = this;
                array2DRowFieldMatrix = adamsMoultonFieldIntegrator2.updateHighOrderDerivativesPhase1(adamsMoultonFieldIntegrator2.nordsieck);
                AdamsMoultonFieldIntegrator adamsMoultonFieldIntegrator3 = this;
                adamsMoultonFieldIntegrator3.updateHighOrderDerivativesPhase2((RealFieldElement[])adamsMoultonFieldIntegrator3.scaled, realFieldElementArray3, array2DRowFieldMatrix);
                realFieldElement = (RealFieldElement)array2DRowFieldMatrix.walkInOptimizedOrder(new AdamsMoultonFieldIntegrator$Corrector(this, realFieldElementArray, realFieldElementArray3, (RealFieldElement[])object));
                if (!(((RealFieldElement)realFieldElement2.subtract(1.0)).getReal() >= 0.0)) continue;
                RealFieldElement realFieldElement3 = this.computeStepGrowShrinkFactor(realFieldElement);
                AdamsMoultonFieldIntegrator adamsMoultonFieldIntegrator4 = this;
                adamsMoultonFieldIntegrator4.rescale(adamsMoultonFieldIntegrator4.filterStep(this.getStepSize().multiply((RealFieldElement)realFieldElement3), bl, false));
                object2 = AdamsFieldStepInterpolator.taylor(this.getStepStart(), (RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize())), this.getStepSize(), this.scaled, this.nordsieck);
            }
            realFieldElementArray2 = this.computeDerivatives((RealFieldElement)((FieldODEState)object2).getTime(), (RealFieldElement[])object);
            RealFieldElement[] realFieldElementArray4 = (RealFieldElement[])MathArrays.buildArray(this.getField(), realFieldElementArray.length);
            for (int i3 = 0; i3 < realFieldElementArray4.length; ++i3) {
                realFieldElementArray4[i3] = this.getStepSize().multiply((RealFieldElement)realFieldElementArray2[i3]);
            }
            this.updateHighOrderDerivativesPhase2(realFieldElementArray3, realFieldElementArray4, array2DRowFieldMatrix);
            object2 = new FieldODEStateAndDerivative(((FieldODEState)object2).getTime(), (RealFieldElement[])object, realFieldElementArray2);
            AdamsMoultonFieldIntegrator adamsMoultonFieldIntegrator5 = this;
            adamsMoultonFieldIntegrator5.setStepStart(adamsMoultonFieldIntegrator5.acceptStep(new AdamsFieldStepInterpolator(this.getStepSize(), (FieldODEStateAndDerivative)object2, realFieldElementArray4, array2DRowFieldMatrix, bl, this.getStepStart(), (FieldODEStateAndDerivative)object2, fieldExpandableODE.getMapper()), t));
            this.scaled = realFieldElementArray4;
            this.nordsieck = array2DRowFieldMatrix;
            if (this.isLastStep()) continue;
            System.arraycopy(object, 0, realFieldElementArray, 0, realFieldElementArray.length);
            if (this.resetOccurred()) {
                this.start(fieldExpandableODE, this.getStepStart(), t);
            }
            RealFieldElement realFieldElement4 = this.computeStepGrowShrinkFactor(realFieldElement);
            object2 = this.getStepSize().multiply((RealFieldElement)realFieldElement4);
            object = (RealFieldElement)this.getStepStart().getTime().add((Object)object2);
            boolean bl3 = bl ? ((RealFieldElement)object.subtract(t)).getReal() >= 0.0 : ((RealFieldElement)object.subtract(t)).getReal() <= 0.0;
            object2 = this.filterStep(object2, bl, bl3);
            RealFieldElement realFieldElement5 = (RealFieldElement)this.getStepStart().getTime().add((Object)object2);
            boolean bl4 = bl ? ((RealFieldElement)realFieldElement5.subtract(t)).getReal() >= 0.0 : (bl2 = ((RealFieldElement)realFieldElement5.subtract(t)).getReal() <= 0.0);
            if (bl4) {
                object2 = (RealFieldElement)t.subtract(this.getStepStart().getTime());
            }
            this.rescale(object2);
            object2 = AdamsFieldStepInterpolator.taylor(this.getStepStart(), (RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize())), this.getStepSize(), this.scaled, this.nordsieck);
        } while (!this.isLastStep());
        object = this.getStepStart();
        this.setStepStart(null);
        this.setStepSize(null);
        return object;
    }
}

