/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.EquationsMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.ExpandableStatefulODE;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.AdamsIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.NordsieckStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.io.Serializable;

public class AdamsBashforthIntegrator
extends AdamsIntegrator {
    private static final String METHOD_NAME = "Adams-Bashforth";

    public AdamsBashforthIntegrator(int n, double d2, double d3, double d4, double d5) {
        int n2 = n;
        super(METHOD_NAME, n2, n2, d2, d3, d4, d5);
    }

    public AdamsBashforthIntegrator(int n, double d2, double d3, double[] dArray, double[] dArray2) {
        int n2 = n;
        super(METHOD_NAME, n2, n2, d2, d3, dArray, dArray2);
    }

    private double errorEstimation(double[] dArray, double[] dArray2, double[] dArray3, RealMatrix realMatrix) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.mainSetDimension; ++i2) {
            double d3;
            double d4 = FastMath.abs(dArray2[i2]);
            double d5 = this.vecAbsoluteTolerance == null ? this.scalAbsoluteTolerance + this.scalRelativeTolerance * d4 : this.vecAbsoluteTolerance[i2] + this.vecRelativeTolerance[i2] * d4;
            double d6 = 0.0;
            int n = realMatrix.getRowDimension() % 2 == 0 ? -1 : 1;
            for (int i3 = realMatrix.getRowDimension() - 1; i3 >= 0; --i3) {
                d6 += (double)n * realMatrix.getEntry(i3, i2);
                n = -n;
            }
            double d7 = d3 = (dArray2[i2] - dArray[i2] + (d6 -= dArray3[i2])) / d5;
            d2 += d7 * d7;
        }
        return FastMath.sqrt(d2 / (double)this.mainSetDimension);
    }

    public void integrate(ExpandableStatefulODE expandableStatefulODE, double d2) {
        this.sanityChecks(expandableStatefulODE, d2);
        this.setEquations(expandableStatefulODE);
        boolean bl = d2 > expandableStatefulODE.getTime();
        double[] dArray = expandableStatefulODE.getCompleteState();
        double[] dArray2 = new double[dArray.length];
        NordsieckStepInterpolator nordsieckStepInterpolator = new NordsieckStepInterpolator();
        nordsieckStepInterpolator.reinitialize(dArray, bl, expandableStatefulODE.getPrimaryMapper(), expandableStatefulODE.getSecondaryMappers());
        this.initIntegration(expandableStatefulODE.getTime(), dArray, d2);
        this.start(expandableStatefulODE.getTime(), dArray, d2);
        nordsieckStepInterpolator.reinitialize(this.stepStart, this.stepSize, this.scaled, this.nordsieck);
        nordsieckStepInterpolator.storeTime(this.stepStart);
        double d3 = this.stepSize;
        nordsieckStepInterpolator.rescale(d3);
        this.isLastStep = false;
        do {
            boolean bl2;
            double d4;
            nordsieckStepInterpolator.shift();
            double[] dArray3 = new double[dArray.length];
            double[] dArray4 = new double[dArray.length];
            Serializable serializable2 = null;
            double d5 = 10.0;
            while (d5 >= 1.0) {
                double d6;
                d4 = this.stepStart + d3;
                nordsieckStepInterpolator.storeTime(d4);
                ExpandableStatefulODE expandableStatefulODE2 = this.getExpandable();
                EquationsMapper equationsMapper = expandableStatefulODE2.getPrimaryMapper();
                equationsMapper.insertEquationData(nordsieckStepInterpolator.getInterpolatedState(), dArray3);
                int n = 0;
                for (Serializable serializable2 : expandableStatefulODE2.getSecondaryMappers()) {
                    serializable2.insertEquationData(nordsieckStepInterpolator.getInterpolatedSecondaryState(n), dArray3);
                    ++n;
                }
                this.computeDerivatives(d4, dArray3, dArray2);
                for (int i2 = 0; i2 < dArray4.length; ++i2) {
                    dArray4[i2] = d3 * dArray2[i2];
                }
                AdamsBashforthIntegrator adamsBashforthIntegrator = this;
                serializable2 = adamsBashforthIntegrator.updateHighOrderDerivativesPhase1(adamsBashforthIntegrator.nordsieck);
                AdamsBashforthIntegrator adamsBashforthIntegrator2 = this;
                adamsBashforthIntegrator2.updateHighOrderDerivativesPhase2(adamsBashforthIntegrator2.scaled, dArray4, (Array2DRowRealMatrix)serializable2);
                d5 = this.errorEstimation(dArray, dArray3, dArray4, (RealMatrix)((Object)serializable2));
                if (!(d6 >= 1.0)) continue;
                double d7 = this.computeStepGrowShrinkFactor(d5);
                d3 = this.filterStep(d3 * d7, bl, false);
                nordsieckStepInterpolator.rescale(d3);
            }
            this.stepSize = d3;
            d4 = this.stepStart + this.stepSize;
            nordsieckStepInterpolator.reinitialize(d4, this.stepSize, dArray4, (Array2DRowRealMatrix)serializable2);
            nordsieckStepInterpolator.storeTime(d4);
            System.arraycopy(dArray3, 0, dArray, 0, dArray.length);
            this.stepStart = this.acceptStep(nordsieckStepInterpolator, dArray, dArray2, d2);
            this.scaled = dArray4;
            this.nordsieck = serializable2;
            nordsieckStepInterpolator.reinitialize(d4, this.stepSize, this.scaled, this.nordsieck);
            if (this.isLastStep) continue;
            nordsieckStepInterpolator.storeTime(this.stepStart);
            if (this.resetOccurred) {
                AdamsBashforthIntegrator adamsBashforthIntegrator = this;
                adamsBashforthIntegrator.start(adamsBashforthIntegrator.stepStart, dArray, d2);
                nordsieckStepInterpolator.reinitialize(this.stepStart, this.stepSize, this.scaled, this.nordsieck);
            }
            double d8 = this.computeStepGrowShrinkFactor(d5);
            double d9 = this.stepSize * d8;
            double d10 = this.stepStart + d9;
            boolean bl3 = bl ? d10 >= d2 : d10 <= d2;
            d3 = this.filterStep(d9, bl, bl3);
            double d11 = this.stepStart + d3;
            boolean bl4 = bl ? d11 >= d2 : (bl2 = d11 <= d2);
            if (bl4) {
                d3 = d2 - this.stepStart;
            }
            nordsieckStepInterpolator.rescale(d3);
        } while (!this.isLastStep);
        expandableStatefulODE.setTime(this.stepStart);
        expandableStatefulODE.setCompleteState(dArray);
        this.resetInternalState();
    }
}

