/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowFieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.FieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldExpandableODE;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEState;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEStateAndDerivative;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.AdamsFieldIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.AdamsFieldStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdamsBashforthFieldIntegrator<T extends RealFieldElement<T>>
extends AdamsFieldIntegrator<T> {
    private static final String METHOD_NAME = "Adams-Bashforth";

    public AdamsBashforthFieldIntegrator(Field<T> field, int n, double d2, double d3, double d4, double d5) {
        int n2 = n;
        super(field, METHOD_NAME, n2, n2, d2, d3, d4, d5);
    }

    public AdamsBashforthFieldIntegrator(Field<T> field, int n, double d2, double d3, double[] dArray, double[] dArray2) {
        int n2 = n;
        super(field, METHOD_NAME, n2, n2, d2, d3, dArray, dArray2);
    }

    private T errorEstimation(T[] TArray, T[] TArray2, T[] TArray3, FieldMatrix<T> fieldMatrix) {
        RealFieldElement realFieldElement = (RealFieldElement)this.getField().getZero();
        for (int i2 = 0; i2 < this.mainSetDimension; ++i2) {
            RealFieldElement realFieldElement2;
            RealFieldElement realFieldElement3 = (RealFieldElement)TArray2[i2].abs();
            realFieldElement3 = this.vecAbsoluteTolerance == null ? (RealFieldElement)((RealFieldElement)realFieldElement3.multiply(this.scalRelativeTolerance)).add(this.scalAbsoluteTolerance) : (RealFieldElement)((RealFieldElement)realFieldElement3.multiply(this.vecRelativeTolerance[i2])).add(this.vecAbsoluteTolerance[i2]);
            RealFieldElement realFieldElement4 = (RealFieldElement)this.getField().getZero();
            int n = fieldMatrix.getRowDimension() % 2 == 0 ? -1 : 1;
            for (int i3 = fieldMatrix.getRowDimension() - 1; i3 >= 0; --i3) {
                realFieldElement4 = (RealFieldElement)realFieldElement4.add(((RealFieldElement)fieldMatrix.getEntry(i3, i2)).multiply(n));
                n = -n;
            }
            realFieldElement4 = (RealFieldElement)realFieldElement4.subtract(TArray3[i2]);
            RealFieldElement realFieldElement5 = realFieldElement2 = ((RealFieldElement)TArray2[i2].subtract(TArray[i2])).add(realFieldElement4).divide(realFieldElement3);
            realFieldElement = realFieldElement.add(realFieldElement5.multiply(realFieldElement5));
        }
        return (T)((RealFieldElement)((RealFieldElement)realFieldElement.divide(this.mainSetDimension)).sqrt());
    }

    @Override
    public FieldODEStateAndDerivative<T> integrate(FieldExpandableODE<T> fieldExpandableODE, FieldODEState<T> fieldODEState, T t) {
        Object object;
        this.sanityChecks(fieldODEState, t);
        Object object2 = fieldODEState.getTime();
        RealFieldElement[] realFieldElementArray = fieldExpandableODE.getMapper().mapState(fieldODEState);
        AdamsBashforthFieldIntegrator adamsBashforthFieldIntegrator = this;
        adamsBashforthFieldIntegrator.setStepStart(adamsBashforthFieldIntegrator.initIntegration(fieldExpandableODE, (RealFieldElement)object2, realFieldElementArray, (RealFieldElement)t));
        boolean bl = ((RealFieldElement)t.subtract(fieldODEState.getTime())).getReal() > 0.0;
        this.start(fieldExpandableODE, this.getStepStart(), t);
        object2 = this.getStepStart();
        object2 = AdamsFieldStepInterpolator.taylor(object2, (RealFieldElement)((RealFieldElement)((FieldODEState)object2).getTime().add(this.getStepSize())), this.getStepSize(), this.scaled, this.nordsieck);
        this.setIsLastStep(false);
        do {
            boolean bl2;
            object = null;
            RealFieldElement[] realFieldElementArray2 = (RealFieldElement[])MathArrays.buildArray(this.getField(), realFieldElementArray.length);
            Object object3 = null;
            RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(10.0);
            while (((RealFieldElement)realFieldElement.subtract(1.0)).getReal() >= 0.0) {
                RealFieldElement realFieldElement2;
                object = object2.getState();
                object3 = this.computeDerivatives((RealFieldElement)((FieldODEState)object2).getTime(), (RealFieldElement[])object);
                for (int i2 = 0; i2 < realFieldElementArray2.length; ++i2) {
                    realFieldElementArray2[i2] = this.getStepSize().multiply((RealFieldElement)object3[i2]);
                }
                AdamsBashforthFieldIntegrator adamsBashforthFieldIntegrator2 = this;
                object3 = adamsBashforthFieldIntegrator2.updateHighOrderDerivativesPhase1(adamsBashforthFieldIntegrator2.nordsieck);
                AdamsBashforthFieldIntegrator adamsBashforthFieldIntegrator3 = this;
                adamsBashforthFieldIntegrator3.updateHighOrderDerivativesPhase2((RealFieldElement[])adamsBashforthFieldIntegrator3.scaled, realFieldElementArray2, (Array2DRowFieldMatrix)object3);
                realFieldElement = this.errorEstimation(realFieldElementArray, (RealFieldElement[])object, realFieldElementArray2, (FieldMatrix)object3);
                if (!(((RealFieldElement)realFieldElement2.subtract(1.0)).getReal() >= 0.0)) continue;
                RealFieldElement realFieldElement3 = this.computeStepGrowShrinkFactor(realFieldElement);
                AdamsBashforthFieldIntegrator adamsBashforthFieldIntegrator4 = this;
                adamsBashforthFieldIntegrator4.rescale(adamsBashforthFieldIntegrator4.filterStep(this.getStepSize().multiply((RealFieldElement)realFieldElement3), bl, false));
                object2 = AdamsFieldStepInterpolator.taylor(this.getStepStart(), (RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize())), this.getStepSize(), this.scaled, this.nordsieck);
            }
            AdamsBashforthFieldIntegrator adamsBashforthFieldIntegrator5 = this;
            adamsBashforthFieldIntegrator5.setStepStart(adamsBashforthFieldIntegrator5.acceptStep(new AdamsFieldStepInterpolator(this.getStepSize(), (FieldODEStateAndDerivative)object2, realFieldElementArray2, (Array2DRowFieldMatrix)object3, bl, this.getStepStart(), (FieldODEStateAndDerivative)object2, fieldExpandableODE.getMapper()), t));
            this.scaled = realFieldElementArray2;
            this.nordsieck = object3;
            if (this.isLastStep()) continue;
            System.arraycopy(object, 0, realFieldElementArray, 0, realFieldElementArray.length);
            if (this.resetOccurred()) {
                this.start(fieldExpandableODE, this.getStepStart(), t);
            }
            object3 = this.computeStepGrowShrinkFactor(realFieldElement);
            RealFieldElement realFieldElement4 = (RealFieldElement)this.getStepSize().multiply((RealFieldElement[])object3);
            object2 = this.getStepStart().getTime().add((RealFieldElement)realFieldElement4);
            boolean bl3 = bl ? ((RealFieldElement)object2.subtract(t)).getReal() >= 0.0 : ((RealFieldElement)object2.subtract(t)).getReal() <= 0.0;
            object2 = this.filterStep(realFieldElement4, bl, bl3);
            object = (RealFieldElement)this.getStepStart().getTime().add((Object)object2);
            boolean bl4 = bl ? ((RealFieldElement)object.subtract(t)).getReal() >= 0.0 : (bl2 = ((RealFieldElement)object.subtract(t)).getReal() <= 0.0);
            if (bl4) {
                object2 = (RealFieldElement)t.subtract(this.getStepStart().getTime());
            }
            this.rescale(object2);
            object2 = AdamsFieldStepInterpolator.taylor(this.getStepStart(), (RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize())), this.getStepSize(), this.scaled, this.nordsieck);
        } while (!this.isLastStep());
        object = this.getStepStart();
        this.setStepStart(null);
        this.setStepSize(null);
        return object;
    }
}

