/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.AllowedSolution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.BracketedRealFieldUnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEState;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEStateAndDerivative;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events.Action;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events.FieldEventHandler;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events.FieldEventState$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.FieldStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldEventState<T extends RealFieldElement<T>> {
    private final FieldEventHandler<T> handler;
    private final double maxCheckInterval;
    private final T convergence;
    private final int maxIterationCount;
    private T t0;
    private T g0;
    private boolean g0Positive;
    private boolean pendingEvent;
    private T pendingEventTime;
    private T previousEventTime;
    private boolean forward;
    private boolean increasing;
    private Action nextAction;
    private final BracketedRealFieldUnivariateSolver<T> solver;

    public FieldEventState(FieldEventHandler<T> fieldEventHandler, double d2, T t, int n, BracketedRealFieldUnivariateSolver<T> bracketedRealFieldUnivariateSolver) {
        this.handler = fieldEventHandler;
        this.maxCheckInterval = d2;
        this.convergence = (RealFieldElement)t.abs();
        this.maxIterationCount = n;
        this.solver = bracketedRealFieldUnivariateSolver;
        this.t0 = null;
        this.g0 = null;
        this.g0Positive = true;
        this.pendingEvent = false;
        this.pendingEventTime = null;
        this.previousEventTime = null;
        this.increasing = true;
        this.nextAction = Action.CONTINUE;
    }

    public FieldEventHandler<T> getEventHandler() {
        return this.handler;
    }

    public double getMaxCheckInterval() {
        return this.maxCheckInterval;
    }

    public T getConvergence() {
        return this.convergence;
    }

    public int getMaxIterationCount() {
        return this.maxIterationCount;
    }

    public void reinitializeBegin(FieldStepInterpolator<T> fieldStepInterpolator) {
        FieldEventState fieldEventState;
        Object object = fieldStepInterpolator.getPreviousState();
        this.t0 = ((FieldODEState)object).getTime();
        this.g0 = this.handler.g((FieldODEStateAndDerivative<T>)object);
        if (this.g0.getReal() == 0.0) {
            double d2 = FastMath.max(this.solver.getAbsoluteAccuracy().getReal(), FastMath.abs(((RealFieldElement)this.solver.getRelativeAccuracy().multiply(this.t0)).getReal()));
            object = (RealFieldElement)this.t0.add(d2 * 0.5);
            this.g0 = this.handler.g(fieldStepInterpolator.getInterpolatedState(object));
        }
        this.g0Positive = fieldEventState.g0.getReal() >= 0.0;
    }

    public boolean evaluateStep(FieldStepInterpolator<T> fieldStepInterpolator) {
        RealFieldElement realFieldElement;
        this.forward = fieldStepInterpolator.isForward();
        FieldODEStateAndDerivative<T> fieldODEStateAndDerivative = fieldStepInterpolator.getCurrentState();
        fieldODEStateAndDerivative = fieldODEStateAndDerivative.getTime();
        RealFieldElement realFieldElement2 = (RealFieldElement)fieldODEStateAndDerivative.subtract(this.t0);
        if (((RealFieldElement)((RealFieldElement)realFieldElement.abs()).subtract(this.convergence)).getReal() < 0.0) {
            return false;
        }
        int n = FastMath.max(1, (int)FastMath.ceil(FastMath.abs(realFieldElement2.getReal()) / this.maxCheckInterval));
        realFieldElement2 = (RealFieldElement)realFieldElement2.divide(n);
        FieldEventState$1 fieldEventState$1 = new FieldEventState$1(this, fieldStepInterpolator);
        Object object = this.t0;
        Object object2 = this.g0;
        for (int i2 = 0; i2 < n; ++i2) {
            Object object3 = i2 == n - 1 ? fieldODEStateAndDerivative : (RealFieldElement)this.t0.add(realFieldElement2.multiply(i2 + 1));
            FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2 = this.handler.g(fieldStepInterpolator.getInterpolatedState((FieldODEStateAndDerivative<T>)object3));
            if (this.g0Positive ^ fieldODEStateAndDerivative2.getReal() >= 0.0) {
                FieldODEStateAndDerivative<T> fieldODEStateAndDerivative3;
                this.increasing = ((RealFieldElement)fieldODEStateAndDerivative2.subtract(object2)).getReal() >= 0.0;
                FieldODEStateAndDerivative<T> fieldODEStateAndDerivative4 = fieldODEStateAndDerivative3 = this.forward ? this.solver.solve(this.maxIterationCount, fieldEventState$1, (FieldODEStateAndDerivative<T>)object, (FieldODEStateAndDerivative<T>)object3, AllowedSolution.RIGHT_SIDE) : this.solver.solve(this.maxIterationCount, fieldEventState$1, (FieldODEStateAndDerivative<T>)object3, (FieldODEStateAndDerivative<T>)object, AllowedSolution.LEFT_SIDE);
                if (this.previousEventTime != null && ((RealFieldElement)((RealFieldElement)((RealFieldElement)fieldODEStateAndDerivative3.subtract(object)).abs()).subtract(this.convergence)).getReal() <= 0.0 && ((RealFieldElement)((RealFieldElement)((RealFieldElement)fieldODEStateAndDerivative3.subtract(this.previousEventTime)).abs()).subtract(this.convergence)).getReal() <= 0.0) {
                    while (this.g0Positive ^ (object2 = fieldEventState$1.value(object = this.forward ? (RealFieldElement)object.add(this.convergence) : (RealFieldElement)object.subtract(this.convergence))).getReal() >= 0.0 && this.forward ^ ((RealFieldElement)((Object)object.subtract(object3))).getReal() >= 0.0) {
                    }
                    if (this.forward ^ ((RealFieldElement)((Object)object.subtract(object3))).getReal() >= 0.0) {
                        --i2;
                        continue;
                    }
                    this.pendingEventTime = fieldODEStateAndDerivative3;
                    this.pendingEvent = true;
                    return true;
                }
                if (this.previousEventTime == null || ((RealFieldElement)((RealFieldElement)((RealFieldElement)((Object)this.previousEventTime.subtract(fieldODEStateAndDerivative3))).abs()).subtract(this.convergence)).getReal() > 0.0) {
                    this.pendingEventTime = fieldODEStateAndDerivative3;
                    this.pendingEvent = true;
                    return true;
                }
                object = object3;
                object2 = fieldODEStateAndDerivative2;
                continue;
            }
            object = object3;
            object2 = fieldODEStateAndDerivative2;
        }
        this.pendingEvent = false;
        this.pendingEventTime = null;
        return false;
    }

    public T getEventTime() {
        if (this.pendingEvent) {
            return this.pendingEventTime;
        }
        return (T)((RealFieldElement)((RealFieldElement)this.t0.getField().getZero()).add(this.forward ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY));
    }

    public void stepAccepted(FieldODEStateAndDerivative<T> fieldODEStateAndDerivative) {
        FieldEventState fieldEventState;
        this.t0 = fieldODEStateAndDerivative.getTime();
        this.g0 = this.handler.g(fieldODEStateAndDerivative);
        if (this.pendingEvent && ((RealFieldElement)((RealFieldElement)((RealFieldElement)this.pendingEventTime.subtract(fieldODEStateAndDerivative.getTime())).abs()).subtract(this.convergence)).getReal() <= 0.0) {
            this.previousEventTime = fieldODEStateAndDerivative.getTime();
            this.g0Positive = this.increasing;
            this.nextAction = this.handler.eventOccurred(fieldODEStateAndDerivative, !(this.increasing ^ this.forward));
            return;
        }
        this.g0Positive = fieldEventState.g0.getReal() >= 0.0;
        this.nextAction = Action.CONTINUE;
    }

    public boolean stop() {
        return this.nextAction == Action.STOP;
    }

    public FieldODEState<T> reset(FieldODEStateAndDerivative<T> fieldODEState) {
        if (!this.pendingEvent || !(((RealFieldElement)((RealFieldElement)((RealFieldElement)this.pendingEventTime.subtract(fieldODEState.getTime())).abs()).subtract(this.convergence)).getReal() <= 0.0)) {
            return null;
        }
        if (this.nextAction == Action.RESET_STATE) {
            fieldODEState = this.handler.resetState((FieldODEStateAndDerivative<T>)fieldODEState);
        } else if (this.nextAction != Action.RESET_DERIVATIVES) {
            fieldODEState = null;
        }
        this.pendingEvent = false;
        this.pendingEventTime = null;
        return fieldODEState;
    }

    static /* synthetic */ FieldEventHandler access$000(FieldEventState fieldEventState) {
        return fieldEventState.handler;
    }
}

