/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.AllowedSolution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.BracketedUnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.PegasusSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.UnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.UnivariateSolverUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.EquationsMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.ExpandableStatefulODE;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events.EventHandler;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events.EventHandler$Action;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events.EventState$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events.EventState$LocalMaxCountExceededException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.StepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class EventState {
    private final EventHandler handler;
    private final double maxCheckInterval;
    private final double convergence;
    private final int maxIterationCount;
    private ExpandableStatefulODE expandable;
    private double t0;
    private double g0;
    private boolean g0Positive;
    private boolean pendingEvent;
    private double pendingEventTime;
    private double previousEventTime;
    private boolean forward;
    private boolean increasing;
    private EventHandler$Action nextAction;
    private final UnivariateSolver solver;

    public EventState(EventHandler eventHandler, double d2, double d3, int n, UnivariateSolver univariateSolver) {
        this.handler = eventHandler;
        this.maxCheckInterval = d2;
        this.convergence = FastMath.abs(d3);
        this.maxIterationCount = n;
        this.solver = univariateSolver;
        this.expandable = null;
        this.t0 = Double.NaN;
        this.g0 = Double.NaN;
        this.g0Positive = true;
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        this.previousEventTime = Double.NaN;
        this.increasing = true;
        this.nextAction = EventHandler$Action.CONTINUE;
    }

    public EventHandler getEventHandler() {
        return this.handler;
    }

    public void setExpandable(ExpandableStatefulODE expandableStatefulODE) {
        this.expandable = expandableStatefulODE;
    }

    public double getMaxCheckInterval() {
        return this.maxCheckInterval;
    }

    public double getConvergence() {
        return this.convergence;
    }

    public int getMaxIterationCount() {
        return this.maxIterationCount;
    }

    public void reinitializeBegin(StepInterpolator stepInterpolator) {
        EventState eventState;
        this.t0 = stepInterpolator.getPreviousTime();
        stepInterpolator.setInterpolatedTime(this.t0);
        this.g0 = this.handler.g(this.t0, this.getCompleteState(stepInterpolator));
        if (this.g0 == 0.0) {
            double d2 = FastMath.max(this.solver.getAbsoluteAccuracy(), FastMath.abs(this.solver.getRelativeAccuracy() * this.t0));
            double d3 = this.t0 + d2 * 0.5;
            stepInterpolator.setInterpolatedTime(d3);
            this.g0 = this.handler.g(d3, this.getCompleteState(stepInterpolator));
        }
        this.g0Positive = eventState.g0 >= 0.0;
    }

    private double[] getCompleteState(StepInterpolator stepInterpolator) {
        double[] dArray = new double[this.expandable.getTotalDimension()];
        this.expandable.getPrimaryMapper().insertEquationData(stepInterpolator.getInterpolatedState(), dArray);
        int n = 0;
        for (EquationsMapper equationsMapper : this.expandable.getSecondaryMappers()) {
            equationsMapper.insertEquationData(stepInterpolator.getInterpolatedSecondaryState(n++), dArray);
        }
        return dArray;
    }

    public boolean evaluateStep(StepInterpolator stepInterpolator) {
        try {
            double d2;
            this.forward = stepInterpolator.isForward();
            double d3 = stepInterpolator.getCurrentTime();
            double d4 = d3 - this.t0;
            if (FastMath.abs(d2) < this.convergence) {
                return false;
            }
            int n = FastMath.max(1, (int)FastMath.ceil(FastMath.abs(d4) / this.maxCheckInterval));
            double d5 = d4 / (double)n;
            EventState$1 eventState$1 = new EventState$1(this, stepInterpolator);
            double d6 = this.t0;
            double d7 = this.g0;
            for (int i2 = 0; i2 < n; ++i2) {
                double d8 = i2 == n - 1 ? d3 : this.t0 + (double)(i2 + 1) * d5;
                stepInterpolator.setInterpolatedTime(d8);
                double d9 = this.handler.g(d8, this.getCompleteState(stepInterpolator));
                if (this.g0Positive ^ d9 >= 0.0) {
                    double d10;
                    boolean bl = this.increasing = d9 >= d7;
                    if (this.solver instanceof BracketedUnivariateSolver) {
                        BracketedUnivariateSolver bracketedUnivariateSolver = (BracketedUnivariateSolver)((Object)this.solver);
                        d10 = this.forward ? bracketedUnivariateSolver.solve(this.maxIterationCount, eventState$1, d6, d8, AllowedSolution.RIGHT_SIDE) : bracketedUnivariateSolver.solve(this.maxIterationCount, eventState$1, d8, d6, AllowedSolution.LEFT_SIDE);
                    } else {
                        double d11 = this.forward ? this.solver.solve(this.maxIterationCount, eventState$1, d6, d8) : this.solver.solve(this.maxIterationCount, eventState$1, d8, d6);
                        int n2 = this.maxIterationCount - this.solver.getEvaluations();
                        PegasusSolver pegasusSolver = new PegasusSolver(this.solver.getRelativeAccuracy(), this.solver.getAbsoluteAccuracy());
                        double d12 = d10 = this.forward ? UnivariateSolverUtils.forceSide(n2, eventState$1, pegasusSolver, d11, d6, d8, AllowedSolution.RIGHT_SIDE) : UnivariateSolverUtils.forceSide(n2, eventState$1, pegasusSolver, d11, d8, d6, AllowedSolution.LEFT_SIDE);
                    }
                    if (!Double.isNaN(this.previousEventTime) && FastMath.abs(d10 - d6) <= this.convergence && FastMath.abs(d10 - this.previousEventTime) <= this.convergence) {
                        while (this.g0Positive ^ (d7 = eventState$1.value(d6 = this.forward ? d6 + this.convergence : d6 - this.convergence)) >= 0.0 && this.forward ^ d6 >= d8) {
                        }
                        if (this.forward ^ d6 >= d8) {
                            --i2;
                            continue;
                        }
                        this.pendingEventTime = d10;
                        this.pendingEvent = true;
                        return true;
                    }
                    if (Double.isNaN(this.previousEventTime) || FastMath.abs(this.previousEventTime - d10) > this.convergence) {
                        this.pendingEventTime = d10;
                        this.pendingEvent = true;
                        return true;
                    }
                    d6 = d8;
                    d7 = d9;
                    continue;
                }
                d6 = d8;
                d7 = d9;
            }
            this.pendingEvent = false;
            this.pendingEventTime = Double.NaN;
            return false;
        }
        catch (EventState$LocalMaxCountExceededException eventState$LocalMaxCountExceededException) {
            EventState$LocalMaxCountExceededException eventState$LocalMaxCountExceededException2 = eventState$LocalMaxCountExceededException;
            throw eventState$LocalMaxCountExceededException.getException();
        }
    }

    public double getEventTime() {
        if (this.pendingEvent) {
            return this.pendingEventTime;
        }
        if (this.forward) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public void stepAccepted(double d2, double[] dArray) {
        EventState eventState;
        this.t0 = d2;
        this.g0 = this.handler.g(d2, dArray);
        if (this.pendingEvent && FastMath.abs(this.pendingEventTime - d2) <= this.convergence) {
            this.previousEventTime = d2;
            this.g0Positive = this.increasing;
            this.nextAction = this.handler.eventOccurred(d2, dArray, !(this.increasing ^ this.forward));
            return;
        }
        this.g0Positive = eventState.g0 >= 0.0;
        this.nextAction = EventHandler$Action.CONTINUE;
    }

    public boolean stop() {
        return this.nextAction == EventHandler$Action.STOP;
    }

    public boolean reset(double d2, double[] dArray) {
        if (!this.pendingEvent || !(FastMath.abs(this.pendingEventTime - d2) <= this.convergence)) {
            return false;
        }
        if (this.nextAction == EventHandler$Action.RESET_STATE) {
            this.handler.resetState(d2, dArray);
        }
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        return this.nextAction == EventHandler$Action.RESET_STATE || this.nextAction == EventHandler$Action.RESET_DERIVATIVES;
    }

    static /* synthetic */ double[] access$000(EventState eventState, StepInterpolator stepInterpolator) {
        return eventState.getCompleteState(stepInterpolator);
    }

    static /* synthetic */ EventHandler access$100(EventState eventState) {
        return eventState.handler;
    }
}

