/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events.EventHandler;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events.FilterType;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events.Transformer;
import java.util.Arrays;

public class EventFilter
implements EventHandler {
    private static final int HISTORY_SIZE = 100;
    private final EventHandler rawHandler;
    private final FilterType filter;
    private final Transformer[] transformers;
    private final double[] updates;
    private boolean forward;
    private double extremeT;

    public EventFilter(EventHandler eventHandler, FilterType filterType) {
        this.rawHandler = eventHandler;
        this.filter = filterType;
        this.transformers = new Transformer[100];
        this.updates = new double[100];
    }

    public void init(double d2, double[] dArray, double d3) {
        this.rawHandler.init(d2, dArray, d3);
        this.forward = d3 >= d2;
        this.extremeT = this.forward ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        Arrays.fill((Object[])this.transformers, (Object)Transformer.UNINITIALIZED);
        Arrays.fill(this.updates, this.extremeT);
    }

    public double g(double d2, double[] object) {
        double d3 = this.rawHandler.g(d2, (double[])object);
        if (this.forward) {
            int n = this.transformers.length - 1;
            if (this.extremeT < d2) {
                Transformer transformer = this.transformers[n];
                Transformer transformer2 = this.filter.selectTransformer(transformer, d3, this.forward);
                if (transformer2 != transformer) {
                    System.arraycopy(this.updates, 1, this.updates, 0, n);
                    System.arraycopy(this.transformers, 1, this.transformers, 0, n);
                    this.updates[n] = this.extremeT;
                    this.transformers[n] = transformer2;
                }
                this.extremeT = d2;
                return transformer2.transformed(d3);
            }
            for (int i2 = n; i2 > 0; --i2) {
                if (!(this.updates[i2] <= d2)) continue;
                return this.transformers[i2].transformed(d3);
            }
            return this.transformers[0].transformed(d3);
        }
        if (d2 < this.extremeT) {
            object = (Object)this.transformers[0];
            Transformer transformer = this.filter.selectTransformer((Transformer)((Object)object), d3, this.forward);
            if (transformer != object) {
                System.arraycopy(this.updates, 0, this.updates, 1, this.updates.length - 1);
                System.arraycopy(this.transformers, 0, this.transformers, 1, this.transformers.length - 1);
                this.updates[0] = this.extremeT;
                this.transformers[0] = transformer;
            }
            this.extremeT = d2;
            return transformer.transformed(d3);
        }
        for (int i3 = 0; i3 < this.updates.length - 1; ++i3) {
            if (!(d2 <= this.updates[i3])) continue;
            return this.transformers[i3].transformed(d3);
        }
        return this.transformers[this.updates.length - 1].transformed(d3);
    }

    public EventHandler.Action eventOccurred(double d2, double[] dArray, boolean bl) {
        return this.rawHandler.eventOccurred(d2, dArray, this.filter.getTriggeredIncreasing());
    }

    public void resetState(double d2, double[] dArray) {
        this.rawHandler.resetState(d2, dArray);
    }
}

