/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.ParameterConfiguration;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.ParameterJacobianProvider;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.ParameterizedODE;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParameterJacobianWrapper
implements ParameterJacobianProvider {
    private final FirstOrderDifferentialEquations fode;
    private final ParameterizedODE pode;
    private final Map<String, Double> hParam;

    ParameterJacobianWrapper(FirstOrderDifferentialEquations parameterConfigurationArray, ParameterizedODE parameterizedODE, ParameterConfiguration[] parameterConfigurationArray2) {
        this.fode = parameterConfigurationArray;
        this.pode = parameterizedODE;
        this.hParam = new HashMap<String, Double>();
        parameterConfigurationArray = parameterConfigurationArray2;
        int n = parameterConfigurationArray2.length;
        for (int i2 = 0; i2 < n; ++i2) {
            ParameterConfiguration parameterConfiguration = parameterConfigurationArray[i2];
            String string = parameterConfiguration.getParameterName();
            if (!parameterizedODE.isSupported(string)) continue;
            this.hParam.put(string, parameterConfiguration.getHP());
        }
    }

    @Override
    public Collection<String> getParametersNames() {
        return this.pode.getParametersNames();
    }

    @Override
    public boolean isSupported(String string) {
        return this.pode.isSupported(string);
    }

    @Override
    public void computeParameterJacobian(double d2, double[] dArray, double[] dArray2, String string, double[] dArray3) {
        int n = this.fode.getDimension();
        if (this.pode.isSupported(string)) {
            double[] dArray4 = new double[n];
            double d3 = this.pode.getParameter(string);
            double d4 = this.hParam.get(string);
            this.pode.setParameter(string, d3 + d4);
            this.fode.computeDerivatives(d2, dArray, dArray4);
            for (int i2 = 0; i2 < n; ++i2) {
                dArray3[i2] = (dArray4[i2] - dArray2[i2]) / d4;
            }
            this.pode.setParameter(string, d3);
            return;
        }
        Arrays.fill(dArray3, 0, n, 0.0);
    }
}

