/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.AbstractIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FirstOrderIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.MultistepIntegrator$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.MultistepIntegrator$InitializationCompletedMarkerException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.MultistepIntegrator$NordsieckInitializer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.ODEIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.AdaptiveStepsizeIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.DormandPrince853Integrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public abstract class MultistepIntegrator
extends AdaptiveStepsizeIntegrator {
    protected double[] scaled;
    protected Array2DRowRealMatrix nordsieck;
    private FirstOrderIntegrator starter;
    private final int nSteps;
    private double exp;
    private double safety;
    private double minReduction;
    private double maxGrowth;

    protected MultistepIntegrator(String string, int n, int n2, double d2, double d3, double d4, double d5) {
        super(string, d2, d3, d4, d5);
        if (n < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INTEGRATION_METHOD_NEEDS_AT_LEAST_TWO_PREVIOUS_POINTS, (Number)n, 2, true);
        }
        this.starter = new DormandPrince853Integrator(d2, d3, d4, d5);
        this.nSteps = n;
        this.exp = -1.0 / (double)n2;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(FastMath.pow(2.0, -this.exp));
    }

    protected MultistepIntegrator(String string, int n, int n2, double d2, double d3, double[] dArray, double[] dArray2) {
        super(string, d2, d3, dArray, dArray2);
        this.starter = new DormandPrince853Integrator(d2, d3, dArray, dArray2);
        this.nSteps = n;
        this.exp = -1.0 / (double)n2;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(FastMath.pow(2.0, -this.exp));
    }

    public ODEIntegrator getStarterIntegrator() {
        return this.starter;
    }

    public void setStarterIntegrator(FirstOrderIntegrator firstOrderIntegrator) {
        this.starter = firstOrderIntegrator;
    }

    protected void start(double d2, double[] dArray, double d3) {
        this.starter.clearEventHandlers();
        this.starter.clearStepHandlers();
        MultistepIntegrator multistepIntegrator = this;
        this.starter.addStepHandler(new MultistepIntegrator$NordsieckInitializer(multistepIntegrator, (multistepIntegrator.nSteps + 3) / 2, dArray.length));
        try {
            if (this.starter instanceof AbstractIntegrator) {
                ((AbstractIntegrator)this.starter).integrate(this.getExpandable(), d3);
            } else {
                this.starter.integrate(new MultistepIntegrator$1(this), d2, dArray, d3, new double[dArray.length]);
            }
            throw new MathIllegalStateException(LocalizedFormats.MULTISTEP_STARTER_STOPPED_EARLY, new Object[0]);
        }
        catch (MultistepIntegrator$InitializationCompletedMarkerException multistepIntegrator$InitializationCompletedMarkerException) {
            this.getCounter().increment(this.starter.getEvaluations());
            this.starter.clearStepHandlers();
            return;
        }
    }

    protected abstract Array2DRowRealMatrix initializeHighOrderDerivatives(double var1, double[] var3, double[][] var4, double[][] var5);

    public double getMinReduction() {
        return this.minReduction;
    }

    public void setMinReduction(double d2) {
        this.minReduction = d2;
    }

    public double getMaxGrowth() {
        return this.maxGrowth;
    }

    public void setMaxGrowth(double d2) {
        this.maxGrowth = d2;
    }

    public double getSafety() {
        return this.safety;
    }

    public void setSafety(double d2) {
        this.safety = d2;
    }

    public int getNSteps() {
        return this.nSteps;
    }

    protected double computeStepGrowShrinkFactor(double d2) {
        return FastMath.min(this.maxGrowth, FastMath.max(this.minReduction, this.safety * FastMath.pow(d2, this.exp)));
    }
}

