/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowFieldMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldExpandableODE;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEState;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FirstOrderFieldIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.MultistepFieldIntegrator$FieldNordsieckInitializer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.MultistepFieldIntegrator$InitializationCompletedMarkerException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.AdaptiveStepsizeFieldIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.nonstiff.DormandPrince853FieldIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultistepFieldIntegrator<T extends RealFieldElement<T>>
extends AdaptiveStepsizeFieldIntegrator<T> {
    protected T[] scaled;
    protected Array2DRowFieldMatrix<T> nordsieck;
    private FirstOrderFieldIntegrator<T> starter;
    private final int nSteps;
    private double exp;
    private double safety;
    private double minReduction;
    private double maxGrowth;

    protected MultistepFieldIntegrator(Field<T> field, String string, int n, int n2, double d2, double d3, double d4, double d5) {
        super(field, string, d2, d3, d4, d5);
        if (n < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INTEGRATION_METHOD_NEEDS_AT_LEAST_TWO_PREVIOUS_POINTS, (Number)n, 2, true);
        }
        this.starter = new DormandPrince853FieldIntegrator<T>(field, d2, d3, d4, d5);
        this.nSteps = n;
        this.exp = -1.0 / (double)n2;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(FastMath.pow(2.0, -this.exp));
    }

    protected MultistepFieldIntegrator(Field<T> field, String string, int n, int n2, double d2, double d3, double[] dArray, double[] dArray2) {
        super(field, string, d2, d3, dArray, dArray2);
        this.starter = new DormandPrince853FieldIntegrator<T>(field, d2, d3, dArray, dArray2);
        this.nSteps = n;
        this.exp = -1.0 / (double)n2;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(FastMath.pow(2.0, -this.exp));
    }

    public FirstOrderFieldIntegrator<T> getStarterIntegrator() {
        return this.starter;
    }

    public void setStarterIntegrator(FirstOrderFieldIntegrator<T> firstOrderFieldIntegrator) {
        this.starter = firstOrderFieldIntegrator;
    }

    protected void start(FieldExpandableODE<T> fieldExpandableODE, FieldODEState<T> fieldODEState, T t) {
        this.starter.clearEventHandlers();
        this.starter.clearStepHandlers();
        this.starter.addStepHandler(new MultistepFieldIntegrator$FieldNordsieckInitializer(this, fieldExpandableODE.getMapper(), (this.nSteps + 3) / 2));
        try {
            this.starter.integrate(fieldExpandableODE, fieldODEState, t);
            throw new MathIllegalStateException(LocalizedFormats.MULTISTEP_STARTER_STOPPED_EARLY, new Object[0]);
        }
        catch (MultistepFieldIntegrator$InitializationCompletedMarkerException multistepFieldIntegrator$InitializationCompletedMarkerException) {
            this.getEvaluationsCounter().increment(this.starter.getEvaluations());
            this.starter.clearStepHandlers();
            return;
        }
    }

    protected abstract Array2DRowFieldMatrix<T> initializeHighOrderDerivatives(T var1, T[] var2, T[][] var3, T[][] var4);

    public double getMinReduction() {
        return this.minReduction;
    }

    public void setMinReduction(double d2) {
        this.minReduction = d2;
    }

    public double getMaxGrowth() {
        return this.maxGrowth;
    }

    public void setMaxGrowth(double d2) {
        this.maxGrowth = d2;
    }

    public double getSafety() {
        return this.safety;
    }

    public void setSafety(double d2) {
        this.safety = d2;
    }

    public int getNSteps() {
        return this.nSteps;
    }

    protected void rescale(T t) {
        RealFieldElement realFieldElement = (RealFieldElement)t.divide(this.getStepSize());
        for (int i2 = 0; i2 < this.scaled.length; ++i2) {
            this.scaled[i2] = this.scaled[i2].multiply((RealFieldElement)realFieldElement);
        }
        RealFieldElement[][] realFieldElementArray = (RealFieldElement[][])this.nordsieck.getDataRef();
        RealFieldElement realFieldElement2 = realFieldElement;
        for (int i3 = 0; i3 < realFieldElementArray.length; ++i3) {
            realFieldElement2 = realFieldElement2.multiply(realFieldElement);
            RealFieldElement[] realFieldElementArray2 = realFieldElementArray[i3];
            for (int i4 = 0; i4 < realFieldElementArray2.length; ++i4) {
                realFieldElementArray2[i4] = realFieldElementArray2[i4].multiply(realFieldElement2);
            }
        }
        this.setStepSize(t);
    }

    protected T computeStepGrowShrinkFactor(T d2) {
        return (T)MathUtils.min((RealFieldElement)((RealFieldElement)d2.getField().getZero()).add(this.maxGrowth), MathUtils.max((RealFieldElement)((RealFieldElement)d2.getField().getZero()).add(this.minReduction), (RealFieldElement)((RealFieldElement)d2.pow((double)this.exp)).multiply(this.safety)));
    }
}

