/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.ExpandableStatefulODE;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.JacobianMatrices$JacobiansSecondaryEquations;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.JacobianMatrices$MainStateJacobianWrapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.JacobianMatrices$MismatchedEquations;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.MainStateJacobianProvider;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.ParameterConfiguration;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.ParameterJacobianProvider;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.ParameterizedODE;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.UnknownParameterException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class JacobianMatrices {
    private ExpandableStatefulODE efode = null;
    private int index = -1;
    private MainStateJacobianProvider jode;
    private ParameterizedODE pode;
    private int stateDim;
    private ParameterConfiguration[] selectedParameters;
    private List<ParameterJacobianProvider> jacobianProviders;
    private int paramDim;
    private boolean dirtyParameter;
    private double[] matricesData;

    public JacobianMatrices(FirstOrderDifferentialEquations firstOrderDifferentialEquations, double[] dArray, String ... stringArray) {
        this(new JacobianMatrices$MainStateJacobianWrapper(firstOrderDifferentialEquations, dArray), stringArray);
    }

    public JacobianMatrices(MainStateJacobianProvider mainStateJacobianProvider, String ... stringArray) {
        this.jode = mainStateJacobianProvider;
        this.pode = null;
        this.stateDim = mainStateJacobianProvider.getDimension();
        if (stringArray == null) {
            this.selectedParameters = null;
            this.paramDim = 0;
        } else {
            this.selectedParameters = new ParameterConfiguration[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.selectedParameters[i2] = new ParameterConfiguration(stringArray[i2], Double.NaN);
            }
            this.paramDim = stringArray.length;
        }
        this.dirtyParameter = false;
        this.jacobianProviders = new ArrayList<ParameterJacobianProvider>();
        this.matricesData = new double[(this.stateDim + this.paramDim) * this.stateDim];
        for (int i3 = 0; i3 < this.stateDim; ++i3) {
            this.matricesData[i3 * (this.stateDim + 1)] = 1.0;
        }
    }

    public void registerVariationalEquations(ExpandableStatefulODE expandableStatefulODE) {
        MainStateJacobianProvider mainStateJacobianProvider;
        FirstOrderDifferentialEquations firstOrderDifferentialEquations = mainStateJacobianProvider = this.jode instanceof JacobianMatrices$MainStateJacobianWrapper ? JacobianMatrices$MainStateJacobianWrapper.access$000((JacobianMatrices$MainStateJacobianWrapper)this.jode) : this.jode;
        if (expandableStatefulODE.getPrimary() != mainStateJacobianProvider) {
            throw new JacobianMatrices$MismatchedEquations();
        }
        this.efode = expandableStatefulODE;
        this.index = this.efode.addSecondaryEquations(new JacobianMatrices$JacobiansSecondaryEquations(this, null));
        this.efode.setSecondaryState(this.index, this.matricesData);
    }

    public void addParameterJacobianProvider(ParameterJacobianProvider parameterJacobianProvider) {
        this.jacobianProviders.add(parameterJacobianProvider);
    }

    public void setParameterizedODE(ParameterizedODE parameterizedODE) {
        this.pode = parameterizedODE;
        this.dirtyParameter = true;
    }

    public void setParameterStep(String string, double d2) {
        ParameterConfiguration[] parameterConfigurationArray = this.selectedParameters;
        int n = this.selectedParameters.length;
        for (int i2 = 0; i2 < n; ++i2) {
            ParameterConfiguration parameterConfiguration = parameterConfigurationArray[i2];
            if (!string.equals(parameterConfiguration.getParameterName())) continue;
            parameterConfiguration.setHP(d2);
            this.dirtyParameter = true;
            return;
        }
        throw new UnknownParameterException(string);
    }

    public void setInitialMainStateJacobian(double[][] dArray) {
        JacobianMatrices jacobianMatrices = this;
        jacobianMatrices.checkDimension(jacobianMatrices.stateDim, dArray);
        JacobianMatrices jacobianMatrices2 = this;
        jacobianMatrices2.checkDimension(jacobianMatrices2.stateDim, dArray[0]);
        int n = 0;
        for (double[] dArray2 : dArray) {
            System.arraycopy(dArray2, 0, this.matricesData, n, this.stateDim);
            n += this.stateDim;
        }
        if (this.efode != null) {
            this.efode.setSecondaryState(this.index, this.matricesData);
        }
    }

    public void setInitialParameterJacobian(String string, double[] dArray) {
        JacobianMatrices jacobianMatrices = this;
        jacobianMatrices.checkDimension(jacobianMatrices.stateDim, dArray);
        int n = this.stateDim * this.stateDim;
        ParameterConfiguration[] parameterConfigurationArray = this.selectedParameters;
        int n2 = this.selectedParameters.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ParameterConfiguration parameterConfiguration = parameterConfigurationArray[i2];
            if (string.equals(parameterConfiguration.getParameterName())) {
                System.arraycopy(dArray, 0, this.matricesData, n, this.stateDim);
                if (this.efode != null) {
                    this.efode.setSecondaryState(this.index, this.matricesData);
                }
                return;
            }
            n += this.stateDim;
        }
        throw new UnknownParameterException(string);
    }

    public void getCurrentMainSetJacobian(double[][] dArray) {
        double[] dArray2 = this.efode.getSecondaryState(this.index);
        int n = 0;
        for (int i2 = 0; i2 < this.stateDim; ++i2) {
            System.arraycopy(dArray2, n, dArray[i2], 0, this.stateDim);
            n += this.stateDim;
        }
    }

    public void getCurrentParameterJacobian(String string, double[] dArray) {
        double[] dArray2 = this.efode.getSecondaryState(this.index);
        int n = this.stateDim * this.stateDim;
        ParameterConfiguration[] parameterConfigurationArray = this.selectedParameters;
        int n2 = this.selectedParameters.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ParameterConfiguration parameterConfiguration = parameterConfigurationArray[i2];
            if (parameterConfiguration.getParameterName().equals(string)) {
                System.arraycopy(dArray2, n, dArray, 0, this.stateDim);
                return;
            }
            n += this.stateDim;
        }
    }

    private void checkDimension(int n, Object object) {
        int n2 = object == null ? 0 : Array.getLength(object);
        if (n2 != n) {
            throw new DimensionMismatchException(n2, n);
        }
    }

    static /* synthetic */ int access$200(JacobianMatrices jacobianMatrices) {
        return jacobianMatrices.stateDim;
    }

    static /* synthetic */ int access$300(JacobianMatrices jacobianMatrices) {
        return jacobianMatrices.paramDim;
    }

    static /* synthetic */ boolean access$400(JacobianMatrices jacobianMatrices) {
        return jacobianMatrices.dirtyParameter;
    }

    static /* synthetic */ MainStateJacobianProvider access$500(JacobianMatrices jacobianMatrices) {
        return jacobianMatrices.jode;
    }

    static /* synthetic */ ParameterizedODE access$600(JacobianMatrices jacobianMatrices) {
        return jacobianMatrices.pode;
    }

    static /* synthetic */ ParameterConfiguration[] access$700(JacobianMatrices jacobianMatrices) {
        return jacobianMatrices.selectedParameters;
    }

    static /* synthetic */ List access$800(JacobianMatrices jacobianMatrices) {
        return jacobianMatrices.jacobianProviders;
    }

    static /* synthetic */ boolean access$402(JacobianMatrices jacobianMatrices, boolean bl) {
        jacobianMatrices.dirtyParameter = bl;
        return jacobianMatrices.dirtyParameter;
    }
}

