/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.MainStateJacobianProvider;

class JacobianMatrices$MainStateJacobianWrapper
implements MainStateJacobianProvider {
    private final FirstOrderDifferentialEquations ode;
    private final double[] hY;

    JacobianMatrices$MainStateJacobianWrapper(FirstOrderDifferentialEquations firstOrderDifferentialEquations, double[] dArray) {
        this.ode = firstOrderDifferentialEquations;
        this.hY = (double[])dArray.clone();
        if (dArray.length != firstOrderDifferentialEquations.getDimension()) {
            throw new DimensionMismatchException(firstOrderDifferentialEquations.getDimension(), dArray.length);
        }
    }

    public int getDimension() {
        return this.ode.getDimension();
    }

    public void computeDerivatives(double d2, double[] dArray, double[] dArray2) {
        this.ode.computeDerivatives(d2, dArray, dArray2);
    }

    public void computeMainStateJacobian(double d2, double[] dArray, double[] dArray2, double[][] dArray3) {
        int n = this.ode.getDimension();
        double[] dArray4 = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            double d3 = dArray[i2];
            int n2 = i2;
            dArray[n2] = dArray[n2] + this.hY[i2];
            this.ode.computeDerivatives(d2, dArray, dArray4);
            for (int i3 = 0; i3 < n; ++i3) {
                dArray3[i3][i2] = (dArray4[i3] - dArray2[i3]) / this.hY[i2];
            }
            dArray[i2] = d3;
        }
    }

    static /* synthetic */ FirstOrderDifferentialEquations access$000(JacobianMatrices$MainStateJacobianWrapper jacobianMatrices$MainStateJacobianWrapper) {
        return jacobianMatrices$MainStateJacobianWrapper.ode;
    }
}

