/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldODEState<T extends RealFieldElement<T>> {
    private final T time;
    private final T[] state;
    private final T[][] secondaryState;

    public FieldODEState(T t, T[] TArray) {
        this((RealFieldElement)t, (RealFieldElement[])TArray, null);
    }

    public FieldODEState(T t, T[] TArray, T[][] TArray2) {
        this.time = t;
        this.state = (RealFieldElement[])TArray.clone();
        this.secondaryState = this.copy(t.getField(), (RealFieldElement[][])TArray2);
    }

    protected T[][] copy(Field<T> realFieldElementArray, T[][] TArray) {
        if (TArray == null) {
            return null;
        }
        realFieldElementArray = (RealFieldElement[][])MathArrays.buildArray(realFieldElementArray, TArray.length, -1);
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            realFieldElementArray[i2] = (RealFieldElement[])TArray[i2].clone();
        }
        return realFieldElementArray;
    }

    public T getTime() {
        return this.time;
    }

    public int getStateDimension() {
        return this.state.length;
    }

    public T[] getState() {
        return (RealFieldElement[])this.state.clone();
    }

    public int getNumberOfSecondaryStates() {
        if (this.secondaryState == null) {
            return 0;
        }
        return this.secondaryState.length;
    }

    public int getSecondaryStateDimension(int n) {
        if (n == 0) {
            return this.state.length;
        }
        return this.secondaryState[n - 1].length;
    }

    public T[] getSecondaryState(int n) {
        if (n == 0) {
            return (RealFieldElement[])this.state.clone();
        }
        return (RealFieldElement[])this.secondaryState[n - 1].clone();
    }
}

