/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.EquationsMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.ExpandableStatefulODE$SecondaryComponent;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.SecondaryEquations;
import java.util.ArrayList;
import java.util.List;

public class ExpandableStatefulODE {
    private final FirstOrderDifferentialEquations primary;
    private final EquationsMapper primaryMapper;
    private double time;
    private final double[] primaryState;
    private final double[] primaryStateDot;
    private List<ExpandableStatefulODE$SecondaryComponent> components;

    public ExpandableStatefulODE(FirstOrderDifferentialEquations firstOrderDifferentialEquations) {
        int n = firstOrderDifferentialEquations.getDimension();
        this.primary = firstOrderDifferentialEquations;
        this.primaryMapper = new EquationsMapper(0, n);
        this.time = Double.NaN;
        this.primaryState = new double[n];
        this.primaryStateDot = new double[n];
        this.components = new ArrayList<ExpandableStatefulODE$SecondaryComponent>();
    }

    public FirstOrderDifferentialEquations getPrimary() {
        return this.primary;
    }

    public int getTotalDimension() {
        if (this.components.isEmpty()) {
            return this.primaryMapper.getDimension();
        }
        EquationsMapper equationsMapper = ExpandableStatefulODE$SecondaryComponent.access$000(this.components.get(this.components.size() - 1));
        return equationsMapper.getFirstIndex() + equationsMapper.getDimension();
    }

    public void computeDerivatives(double d2, double[] dArray, double[] dArray2) {
        this.primaryMapper.extractEquationData(dArray, this.primaryState);
        this.primary.computeDerivatives(d2, this.primaryState, this.primaryStateDot);
        for (ExpandableStatefulODE$SecondaryComponent expandableStatefulODE$SecondaryComponent : this.components) {
            ExpandableStatefulODE$SecondaryComponent.access$000(expandableStatefulODE$SecondaryComponent).extractEquationData(dArray, ExpandableStatefulODE$SecondaryComponent.access$100(expandableStatefulODE$SecondaryComponent));
            ExpandableStatefulODE$SecondaryComponent.access$300(expandableStatefulODE$SecondaryComponent).computeDerivatives(d2, this.primaryState, this.primaryStateDot, ExpandableStatefulODE$SecondaryComponent.access$100(expandableStatefulODE$SecondaryComponent), ExpandableStatefulODE$SecondaryComponent.access$200(expandableStatefulODE$SecondaryComponent));
            ExpandableStatefulODE$SecondaryComponent.access$000(expandableStatefulODE$SecondaryComponent).insertEquationData(ExpandableStatefulODE$SecondaryComponent.access$200(expandableStatefulODE$SecondaryComponent), dArray2);
        }
        this.primaryMapper.insertEquationData(this.primaryStateDot, dArray2);
    }

    public int addSecondaryEquations(SecondaryEquations secondaryEquations) {
        int n;
        if (this.components.isEmpty()) {
            this.components = new ArrayList<ExpandableStatefulODE$SecondaryComponent>();
            n = this.primary.getDimension();
        } else {
            ExpandableStatefulODE$SecondaryComponent expandableStatefulODE$SecondaryComponent = this.components.get(this.components.size() - 1);
            n = ExpandableStatefulODE$SecondaryComponent.access$000(expandableStatefulODE$SecondaryComponent).getFirstIndex() + ExpandableStatefulODE$SecondaryComponent.access$000(expandableStatefulODE$SecondaryComponent).getDimension();
        }
        this.components.add(new ExpandableStatefulODE$SecondaryComponent(secondaryEquations, n));
        return this.components.size() - 1;
    }

    public EquationsMapper getPrimaryMapper() {
        return this.primaryMapper;
    }

    public EquationsMapper[] getSecondaryMappers() {
        EquationsMapper[] equationsMapperArray = new EquationsMapper[this.components.size()];
        for (int i2 = 0; i2 < equationsMapperArray.length; ++i2) {
            equationsMapperArray[i2] = ExpandableStatefulODE$SecondaryComponent.access$000(this.components.get(i2));
        }
        return equationsMapperArray;
    }

    public void setTime(double d2) {
        this.time = d2;
    }

    public double getTime() {
        return this.time;
    }

    public void setPrimaryState(double[] dArray) {
        if (dArray.length != this.primaryState.length) {
            throw new DimensionMismatchException(dArray.length, this.primaryState.length);
        }
        System.arraycopy(dArray, 0, this.primaryState, 0, dArray.length);
    }

    public double[] getPrimaryState() {
        return (double[])this.primaryState.clone();
    }

    public double[] getPrimaryStateDot() {
        return (double[])this.primaryStateDot.clone();
    }

    public void setSecondaryState(int n, double[] dArray) {
        double[] dArray2 = ExpandableStatefulODE$SecondaryComponent.access$100(this.components.get(n));
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
    }

    public double[] getSecondaryState(int n) {
        return (double[])ExpandableStatefulODE$SecondaryComponent.access$100(this.components.get(n)).clone();
    }

    public double[] getSecondaryStateDot(int n) {
        return (double[])ExpandableStatefulODE$SecondaryComponent.access$200(this.components.get(n)).clone();
    }

    public void setCompleteState(double[] dArray) {
        if (dArray.length != this.getTotalDimension()) {
            throw new DimensionMismatchException(dArray.length, this.getTotalDimension());
        }
        this.primaryMapper.extractEquationData(dArray, this.primaryState);
        for (ExpandableStatefulODE$SecondaryComponent expandableStatefulODE$SecondaryComponent : this.components) {
            ExpandableStatefulODE$SecondaryComponent.access$000(expandableStatefulODE$SecondaryComponent).extractEquationData(dArray, ExpandableStatefulODE$SecondaryComponent.access$100(expandableStatefulODE$SecondaryComponent));
        }
    }

    public double[] getCompleteState() {
        double[] dArray = new double[this.getTotalDimension()];
        this.primaryMapper.insertEquationData(this.primaryState, dArray);
        for (ExpandableStatefulODE$SecondaryComponent expandableStatefulODE$SecondaryComponent : this.components) {
            ExpandableStatefulODE$SecondaryComponent.access$000(expandableStatefulODE$SecondaryComponent).insertEquationData(ExpandableStatefulODE$SecondaryComponent.access$100(expandableStatefulODE$SecondaryComponent), dArray);
        }
        return dArray;
    }
}

