/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.StepHandler;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.StepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ContinuousOutputModel
implements StepHandler,
Serializable {
    private static final long serialVersionUID = -1417964919405031606L;
    private double initialTime;
    private double finalTime;
    private boolean forward = true;
    private int index = 0;
    private List<StepInterpolator> steps = new ArrayList<StepInterpolator>();

    public ContinuousOutputModel() {
        this.initialTime = Double.NaN;
        this.finalTime = Double.NaN;
    }

    public void append(ContinuousOutputModel continuousOutputModel) {
        if (continuousOutputModel.steps.size() == 0) {
            return;
        }
        if (this.steps.size() == 0) {
            this.initialTime = continuousOutputModel.initialTime;
            this.forward = continuousOutputModel.forward;
        } else {
            double d2;
            if (this.getInterpolatedState().length != continuousOutputModel.getInterpolatedState().length) {
                throw new DimensionMismatchException(continuousOutputModel.getInterpolatedState().length, this.getInterpolatedState().length);
            }
            if (this.forward ^ continuousOutputModel.forward) {
                throw new MathIllegalArgumentException(LocalizedFormats.PROPAGATION_DIRECTION_MISMATCH, new Object[0]);
            }
            StepInterpolator stepInterpolator = this.steps.get(this.index);
            double d3 = stepInterpolator.getCurrentTime();
            double d4 = stepInterpolator.getPreviousTime();
            double d5 = d3 - d4;
            double d6 = continuousOutputModel.getInitialTime() - d3;
            if (FastMath.abs(d2) > 0.001 * FastMath.abs(d5)) {
                throw new MathIllegalArgumentException(LocalizedFormats.HOLE_BETWEEN_MODELS_TIME_RANGES, FastMath.abs(d6));
            }
        }
        for (StepInterpolator stepInterpolator : continuousOutputModel.steps) {
            this.steps.add(stepInterpolator.copy());
        }
        this.index = this.steps.size() - 1;
        this.finalTime = this.steps.get(this.index).getCurrentTime();
    }

    public void init(double d2, double[] dArray, double d3) {
        this.initialTime = Double.NaN;
        this.finalTime = Double.NaN;
        this.forward = true;
        this.index = 0;
        this.steps.clear();
    }

    public void handleStep(StepInterpolator stepInterpolator, boolean bl) {
        if (this.steps.size() == 0) {
            this.initialTime = stepInterpolator.getPreviousTime();
            this.forward = stepInterpolator.isForward();
        }
        this.steps.add(stepInterpolator.copy());
        if (bl) {
            this.finalTime = stepInterpolator.getCurrentTime();
            this.index = this.steps.size() - 1;
        }
    }

    public double getInitialTime() {
        return this.initialTime;
    }

    public double getFinalTime() {
        return this.finalTime;
    }

    public double getInterpolatedTime() {
        return this.steps.get(this.index).getInterpolatedTime();
    }

    public void setInterpolatedTime(double d2) {
        int n = 0;
        StepInterpolator stepInterpolator = this.steps.get(0);
        double d3 = 0.5 * (stepInterpolator.getPreviousTime() + stepInterpolator.getCurrentTime());
        int n2 = this.steps.size() - 1;
        StepInterpolator stepInterpolator2 = this.steps.get(n2);
        double d4 = 0.5 * (stepInterpolator2.getPreviousTime() + stepInterpolator2.getCurrentTime());
        if (this.locatePoint(d2, stepInterpolator) <= 0) {
            this.index = 0;
            stepInterpolator.setInterpolatedTime(d2);
            return;
        }
        if (this.locatePoint(d2, stepInterpolator2) >= 0) {
            this.index = n2;
            stepInterpolator2.setInterpolatedTime(d2);
            return;
        }
        while (n2 - n > 5) {
            stepInterpolator = this.steps.get(this.index);
            int n3 = this.locatePoint(d2, stepInterpolator);
            if (n3 < 0) {
                n2 = this.index;
                d4 = 0.5 * (stepInterpolator.getPreviousTime() + stepInterpolator.getCurrentTime());
            } else if (n3 > 0) {
                n = this.index;
                d3 = 0.5 * (stepInterpolator.getPreviousTime() + stepInterpolator.getCurrentTime());
            } else {
                stepInterpolator.setInterpolatedTime(d2);
                return;
            }
            int n4 = (n + n2) / 2;
            stepInterpolator2 = this.steps.get(n4);
            double d5 = 0.5 * (stepInterpolator2.getPreviousTime() + stepInterpolator2.getCurrentTime());
            if (FastMath.abs(d5 - d3) < 1.0E-6 || FastMath.abs(d4 - d5) < 1.0E-6) {
                this.index = n4;
            } else {
                double d6 = d4 - d5;
                double d7 = d5 - d3;
                double d8 = d4 - d3;
                double d9 = d2 - d4;
                double d10 = d2 - d5;
                double d11 = d2 - d3;
                double d12 = (d10 * d11 * d7 * (double)n2 - d9 * d11 * d8 * (double)n4 + d9 * d10 * d6 * (double)n) / (d6 * d7 * d8);
                this.index = (int)FastMath.rint(d12);
            }
            int n5 = FastMath.max(n + 1, (n * 9 + n2) / 10);
            int n6 = FastMath.min(n2 - 1, (n + n2 * 9) / 10);
            if (this.index < n5) {
                this.index = n5;
                continue;
            }
            if (this.index <= n6) continue;
            this.index = n6;
        }
        this.index = n;
        while (this.index <= n2 && this.locatePoint(d2, this.steps.get(this.index)) > 0) {
            ++this.index;
        }
        this.steps.get(this.index).setInterpolatedTime(d2);
    }

    public double[] getInterpolatedState() {
        return this.steps.get(this.index).getInterpolatedState();
    }

    public double[] getInterpolatedDerivatives() {
        return this.steps.get(this.index).getInterpolatedDerivatives();
    }

    public double[] getInterpolatedSecondaryState(int n) {
        return this.steps.get(this.index).getInterpolatedSecondaryState(n);
    }

    public double[] getInterpolatedSecondaryDerivatives(int n) {
        return this.steps.get(this.index).getInterpolatedSecondaryDerivatives(n);
    }

    private int locatePoint(double d2, StepInterpolator stepInterpolator) {
        if (this.forward) {
            if (d2 < stepInterpolator.getPreviousTime()) {
                return -1;
            }
            if (d2 > stepInterpolator.getCurrentTime()) {
                return 1;
            }
            return 0;
        }
        if (d2 > stepInterpolator.getPreviousTime()) {
            return -1;
        }
        if (d2 < stepInterpolator.getCurrentTime()) {
            return 1;
        }
        return 0;
    }
}

