/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEState;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEStateAndDerivative;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.FieldStepHandler;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.FieldStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinuousOutputFieldModel<T extends RealFieldElement<T>>
implements FieldStepHandler<T> {
    private T initialTime = null;
    private T finalTime = null;
    private boolean forward = true;
    private int index = 0;
    private List<FieldStepInterpolator<T>> steps = new ArrayList<FieldStepInterpolator<T>>();

    public void append(ContinuousOutputFieldModel<T> continuousOutputFieldModel) {
        if (continuousOutputFieldModel.steps.size() == 0) {
            return;
        }
        if (this.steps.size() == 0) {
            this.initialTime = continuousOutputFieldModel.initialTime;
            this.forward = continuousOutputFieldModel.forward;
        } else {
            RealFieldElement realFieldElement;
            Object object = this.steps.get(0).getPreviousState();
            FieldODEStateAndDerivative<T> object2 = continuousOutputFieldModel.steps.get(0).getPreviousState();
            this.checkDimensionsEquality(((FieldODEState)object).getStateDimension(), object2.getStateDimension());
            this.checkDimensionsEquality(((FieldODEState)object).getNumberOfSecondaryStates(), object2.getNumberOfSecondaryStates());
            for (int i2 = 0; i2 < ((FieldODEState)object).getNumberOfSecondaryStates(); ++i2) {
                this.checkDimensionsEquality(((FieldODEState)object).getSecondaryStateDimension(i2), object2.getSecondaryStateDimension(i2));
            }
            if (this.forward ^ continuousOutputFieldModel.forward) {
                throw new MathIllegalArgumentException(LocalizedFormats.PROPAGATION_DIRECTION_MISMATCH, new Object[0]);
            }
            FieldStepInterpolator<T> fieldStepInterpolator = this.steps.get(this.index);
            object = fieldStepInterpolator.getCurrentState().getTime();
            Object t = fieldStepInterpolator.getPreviousState().getTime();
            RealFieldElement realFieldElement2 = (RealFieldElement)object.subtract(t);
            object = (RealFieldElement)continuousOutputFieldModel.getInitialTime().subtract((Object)object);
            if (((RealFieldElement)((RealFieldElement)realFieldElement.abs()).subtract(((RealFieldElement)realFieldElement2.abs()).multiply(0.001))).getReal() > 0.0) {
                throw new MathIllegalArgumentException(LocalizedFormats.HOLE_BETWEEN_MODELS_TIME_RANGES, ((RealFieldElement)object.abs()).getReal());
            }
        }
        for (FieldStepInterpolator fieldStepInterpolator : continuousOutputFieldModel.steps) {
            this.steps.add(fieldStepInterpolator);
        }
        this.index = this.steps.size() - 1;
        this.finalTime = this.steps.get(this.index).getCurrentState().getTime();
    }

    private void checkDimensionsEquality(int n, int n2) {
        if (n != n2) {
            throw new DimensionMismatchException(n2, n);
        }
    }

    @Override
    public void init(FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, T t) {
        this.initialTime = fieldODEStateAndDerivative.getTime();
        this.finalTime = t;
        this.forward = true;
        this.index = 0;
        this.steps.clear();
    }

    @Override
    public void handleStep(FieldStepInterpolator<T> fieldStepInterpolator, boolean bl) {
        if (this.steps.size() == 0) {
            this.initialTime = fieldStepInterpolator.getPreviousState().getTime();
            this.forward = fieldStepInterpolator.isForward();
        }
        this.steps.add(fieldStepInterpolator);
        if (bl) {
            this.finalTime = fieldStepInterpolator.getCurrentState().getTime();
            this.index = this.steps.size() - 1;
        }
    }

    public T getInitialTime() {
        return this.initialTime;
    }

    public T getFinalTime() {
        return this.finalTime;
    }

    public FieldODEStateAndDerivative<T> getInterpolatedState(T realFieldElement) {
        int n = 0;
        FieldStepInterpolator<T> fieldStepInterpolator = this.steps.get(0);
        RealFieldElement realFieldElement2 = (RealFieldElement)((RealFieldElement)fieldStepInterpolator.getPreviousState().getTime().add(fieldStepInterpolator.getCurrentState().getTime())).multiply(0.5);
        int n2 = this.steps.size() - 1;
        Object object = this.steps.get(n2);
        RealFieldElement realFieldElement3 = (RealFieldElement)((RealFieldElement)object.getPreviousState().getTime().add(object.getCurrentState().getTime())).multiply(0.5);
        if (this.locatePoint(realFieldElement, fieldStepInterpolator) <= 0) {
            this.index = 0;
            return fieldStepInterpolator.getInterpolatedState(realFieldElement);
        }
        if (this.locatePoint((T)realFieldElement, (FieldStepInterpolator<T>)object) >= 0) {
            this.index = n2;
            return object.getInterpolatedState(realFieldElement);
        }
        while (n2 - n > 5) {
            fieldStepInterpolator = this.steps.get(this.index);
            int n3 = this.locatePoint(realFieldElement, fieldStepInterpolator);
            if (n3 < 0) {
                n2 = this.index;
                realFieldElement3 = (RealFieldElement)((RealFieldElement)fieldStepInterpolator.getPreviousState().getTime().add(fieldStepInterpolator.getCurrentState().getTime())).multiply(0.5);
            } else if (n3 > 0) {
                n = this.index;
                realFieldElement2 = (RealFieldElement)((RealFieldElement)fieldStepInterpolator.getPreviousState().getTime().add(fieldStepInterpolator.getCurrentState().getTime())).multiply(0.5);
            } else {
                return fieldStepInterpolator.getInterpolatedState(realFieldElement);
            }
            int n4 = (n + n2) / 2;
            object = this.steps.get(n4);
            object = (RealFieldElement)((RealFieldElement)object.getPreviousState().getTime().add(object.getCurrentState().getTime())).multiply(0.5);
            if (((RealFieldElement)((RealFieldElement)object.subtract(realFieldElement2).abs()).subtract(1.0E-6)).getReal() < 0.0 || ((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement3.subtract(object)).abs()).subtract(1.0E-6)).getReal() < 0.0) {
                this.index = n4;
            } else {
                RealFieldElement realFieldElement4 = (RealFieldElement)realFieldElement3.subtract(object);
                RealFieldElement realFieldElement5 = object.subtract(realFieldElement2);
                RealFieldElement realFieldElement6 = realFieldElement3.subtract(realFieldElement2);
                RealFieldElement realFieldElement7 = realFieldElement.subtract((RealFieldElement)realFieldElement3);
                object = (RealFieldElement)realFieldElement.subtract((Object)object);
                RealFieldElement realFieldElement8 = realFieldElement.subtract((RealFieldElement)realFieldElement2);
                RealFieldElement realFieldElement9 = ((RealFieldElement)((RealFieldElement)((RealFieldElement)object.multiply(realFieldElement8).multiply(realFieldElement5).multiply(n2)).subtract(realFieldElement7.multiply(realFieldElement8).multiply(realFieldElement6).multiply(n4))).add(((RealFieldElement)realFieldElement7.multiply(object)).multiply(realFieldElement4).multiply(n))).divide(realFieldElement4.multiply(realFieldElement5).multiply(realFieldElement6));
                this.index = (int)FastMath.rint(realFieldElement9.getReal());
            }
            int n5 = FastMath.max(n + 1, (n * 9 + n2) / 10);
            int n6 = FastMath.min(n2 - 1, (n + n2 * 9) / 10);
            if (this.index < n5) {
                this.index = n5;
                continue;
            }
            if (this.index <= n6) continue;
            this.index = n6;
        }
        this.index = n;
        while (this.index <= n2 && this.locatePoint(realFieldElement, this.steps.get(this.index)) > 0) {
            ++this.index;
        }
        return this.steps.get(this.index).getInterpolatedState(realFieldElement);
    }

    private int locatePoint(T t, FieldStepInterpolator<T> fieldStepInterpolator) {
        if (this.forward) {
            if (((RealFieldElement)t.subtract(fieldStepInterpolator.getPreviousState().getTime())).getReal() < 0.0) {
                return -1;
            }
            if (((RealFieldElement)t.subtract(fieldStepInterpolator.getCurrentState().getTime())).getReal() > 0.0) {
                return 1;
            }
            return 0;
        }
        if (((RealFieldElement)t.subtract(fieldStepInterpolator.getPreviousState().getTime())).getReal() > 0.0) {
            return -1;
        }
        if (((RealFieldElement)t.subtract(fieldStepInterpolator.getCurrentState().getTime())).getReal() < 0.0) {
            return 1;
        }
        return 0;
    }
}

