/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.BracketingNthOrderBrentSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.UnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.AbstractIntegrator$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.EquationsMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.ExpandableStatefulODE;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FirstOrderIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events.EventHandler;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events.EventState;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.AbstractStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.StepHandler;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Incrementor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.IntegerSequence$Incrementor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntegrator
implements FirstOrderIntegrator {
    protected Collection<StepHandler> stepHandlers;
    protected double stepStart;
    protected double stepSize;
    protected boolean isLastStep;
    protected boolean resetOccurred;
    private Collection<EventState> eventsStates;
    private boolean statesInitialized;
    private final String name;
    private IntegerSequence$Incrementor evaluations;
    private transient ExpandableStatefulODE expandable;

    public AbstractIntegrator(String string) {
        this.name = string;
        this.stepHandlers = new ArrayList<StepHandler>();
        this.stepStart = Double.NaN;
        this.stepSize = Double.NaN;
        this.eventsStates = new ArrayList<EventState>();
        this.statesInitialized = false;
        this.evaluations = IntegerSequence$Incrementor.create().withMaximalCount(Integer.MAX_VALUE);
    }

    protected AbstractIntegrator() {
        this(null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addStepHandler(StepHandler stepHandler) {
        this.stepHandlers.add(stepHandler);
    }

    @Override
    public Collection<StepHandler> getStepHandlers() {
        return Collections.unmodifiableCollection(this.stepHandlers);
    }

    @Override
    public void clearStepHandlers() {
        this.stepHandlers.clear();
    }

    @Override
    public void addEventHandler(EventHandler eventHandler, double d2, double d3, int n) {
        this.addEventHandler(eventHandler, d2, d3, n, new BracketingNthOrderBrentSolver(d3, 5));
    }

    @Override
    public void addEventHandler(EventHandler eventHandler, double d2, double d3, int n, UnivariateSolver univariateSolver) {
        this.eventsStates.add(new EventState(eventHandler, d2, d3, n, univariateSolver));
    }

    @Override
    public Collection<EventHandler> getEventHandlers() {
        ArrayList<EventHandler> arrayList = new ArrayList<EventHandler>(this.eventsStates.size());
        for (EventState eventState : this.eventsStates) {
            arrayList.add(eventState.getEventHandler());
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    public void clearEventHandlers() {
        this.eventsStates.clear();
    }

    @Override
    public double getCurrentStepStart() {
        return this.stepStart;
    }

    @Override
    public double getCurrentSignedStepsize() {
        return this.stepSize;
    }

    @Override
    public void setMaxEvaluations(int n) {
        this.evaluations = this.evaluations.withMaximalCount(n < 0 ? Integer.MAX_VALUE : n);
    }

    @Override
    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    protected void initIntegration(double d2, double[] dArray, double d3) {
        this.evaluations = this.evaluations.withStart(0);
        for (EventState object : this.eventsStates) {
            object.setExpandable(this.expandable);
            object.getEventHandler().init(d2, dArray, d3);
        }
        for (StepHandler stepHandler : this.stepHandlers) {
            stepHandler.init(d2, dArray, d3);
        }
        this.setStateInitialized(false);
    }

    protected void setEquations(ExpandableStatefulODE expandableStatefulODE) {
        this.expandable = expandableStatefulODE;
    }

    protected ExpandableStatefulODE getExpandable() {
        return this.expandable;
    }

    @Deprecated
    protected Incrementor getEvaluationsCounter() {
        return Incrementor.wrap(this.evaluations);
    }

    protected IntegerSequence$Incrementor getCounter() {
        return this.evaluations;
    }

    @Override
    public double integrate(FirstOrderDifferentialEquations object, double d2, double[] dArray, double d3, double[] dArray2) {
        if (dArray.length != object.getDimension()) {
            throw new DimensionMismatchException(dArray.length, object.getDimension());
        }
        if (dArray2.length != object.getDimension()) {
            throw new DimensionMismatchException(dArray2.length, object.getDimension());
        }
        object = new ExpandableStatefulODE((FirstOrderDifferentialEquations)object);
        ((ExpandableStatefulODE)object).setTime(d2);
        ((ExpandableStatefulODE)object).setPrimaryState(dArray);
        this.integrate((ExpandableStatefulODE)object, d3);
        System.arraycopy(((ExpandableStatefulODE)object).getPrimaryState(), 0, dArray2, 0, dArray2.length);
        return ((ExpandableStatefulODE)object).getTime();
    }

    public abstract void integrate(ExpandableStatefulODE var1, double var2);

    public void computeDerivatives(double d2, double[] dArray, double[] dArray2) {
        this.evaluations.increment();
        this.expandable.computeDerivatives(d2, dArray, dArray2);
    }

    protected void setStateInitialized(boolean bl) {
        this.statesInitialized = bl;
    }

    protected double acceptStep(AbstractStepInterpolator abstractStepInterpolator, double[] dArray, double[] dArray2, double d2) {
        double d3 = abstractStepInterpolator.getGlobalPreviousTime();
        double d4 = abstractStepInterpolator.getGlobalCurrentTime();
        if (!this.statesInitialized) {
            for (EventState object2 : this.eventsStates) {
                object2.reinitializeBegin(abstractStepInterpolator);
            }
            this.statesInitialized = true;
        }
        int n = abstractStepInterpolator.isForward() ? 1 : -1;
        TreeSet<EventState> treeSet = new TreeSet<EventState>(new AbstractIntegrator$1(this, n));
        for (EventState n3 : this.eventsStates) {
            if (!n3.evaluateStep(abstractStepInterpolator)) continue;
            treeSet.add(n3);
        }
        while (!treeSet.isEmpty()) {
            EventState n3;
            EquationsMapper[] equationsMapperArray = treeSet.iterator();
            n3 = (EventState)equationsMapperArray.next();
            equationsMapperArray.remove();
            double d5 = n3.getEventTime();
            abstractStepInterpolator.setSoftPreviousTime(d3);
            abstractStepInterpolator.setSoftCurrentTime(d5);
            abstractStepInterpolator.setInterpolatedTime(d5);
            double[] dArray3 = new double[dArray.length];
            this.expandable.getPrimaryMapper().insertEquationData(abstractStepInterpolator.getInterpolatedState(), dArray3);
            int n2 = 0;
            for (EquationsMapper equationsMapper : this.expandable.getSecondaryMappers()) {
                equationsMapper.insertEquationData(abstractStepInterpolator.getInterpolatedSecondaryState(n2++), dArray3);
            }
            for (EventState stepHandler : this.eventsStates) {
                stepHandler.stepAccepted(d5, dArray3);
                this.isLastStep = this.isLastStep || stepHandler.stop();
            }
            for (StepHandler stepHandler : this.stepHandlers) {
                stepHandler.handleStep(abstractStepInterpolator, this.isLastStep);
            }
            if (this.isLastStep) {
                System.arraycopy(dArray3, 0, dArray, 0, dArray.length);
                return d5;
            }
            this.resetOccurred = false;
            boolean bl = n3.reset(d5, dArray3);
            if (bl) {
                abstractStepInterpolator.setInterpolatedTime(d5);
                System.arraycopy(dArray3, 0, dArray, 0, dArray.length);
                this.computeDerivatives(d5, dArray, dArray2);
                this.resetOccurred = true;
                return d5;
            }
            d3 = d5;
            abstractStepInterpolator.setSoftPreviousTime(d5);
            abstractStepInterpolator.setSoftCurrentTime(d4);
            if (!n3.evaluateStep(abstractStepInterpolator)) continue;
            treeSet.add(n3);
        }
        abstractStepInterpolator.setInterpolatedTime(d4);
        double[] dArray4 = new double[dArray.length];
        this.expandable.getPrimaryMapper().insertEquationData(abstractStepInterpolator.getInterpolatedState(), dArray4);
        int n3 = 0;
        for (EquationsMapper equationsMapper : this.expandable.getSecondaryMappers()) {
            equationsMapper.insertEquationData(abstractStepInterpolator.getInterpolatedSecondaryState(n3++), dArray4);
        }
        for (EventState stepHandler : this.eventsStates) {
            stepHandler.stepAccepted(d4, dArray4);
            this.isLastStep = this.isLastStep || stepHandler.stop();
        }
        this.isLastStep = this.isLastStep || Precision.equals(d4, d2, 1);
        for (StepHandler stepHandler : this.stepHandlers) {
            stepHandler.handleStep(abstractStepInterpolator, this.isLastStep);
        }
        return d4;
    }

    protected void sanityChecks(ExpandableStatefulODE expandableStatefulODE, double d2) {
        double d3;
        double d4 = 1000.0 * FastMath.ulp(FastMath.max(FastMath.abs(expandableStatefulODE.getTime()), FastMath.abs(d2)));
        double d5 = FastMath.abs(expandableStatefulODE.getTime() - d2);
        if (d3 <= d4) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.TOO_SMALL_INTEGRATION_INTERVAL, (Number)d5, d4, false);
        }
    }
}

