/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ode;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.BracketedRealFieldUnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.FieldBracketingNthOrderBrentSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.AbstractFieldIntegrator$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldExpandableODE;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEState;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FieldODEStateAndDerivative;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.FirstOrderFieldIntegrator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events.FieldEventHandler;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.events.FieldEventState;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.AbstractFieldStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.FieldStepHandler;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ode.sampling.FieldStepInterpolator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.IntegerSequence$Incrementor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFieldIntegrator<T extends RealFieldElement<T>>
implements FirstOrderFieldIntegrator<T> {
    private static final double DEFAULT_RELATIVE_ACCURACY = 1.0E-14;
    private static final double DEFAULT_FUNCTION_VALUE_ACCURACY = 1.0E-15;
    private Collection<FieldStepHandler<T>> stepHandlers;
    private FieldODEStateAndDerivative<T> stepStart;
    private T stepSize;
    private boolean isLastStep;
    private boolean resetOccurred;
    private final Field<T> field;
    private Collection<FieldEventState<T>> eventsStates;
    private boolean statesInitialized;
    private final String name;
    private IntegerSequence$Incrementor evaluations;
    private transient FieldExpandableODE<T> equations;

    protected AbstractFieldIntegrator(Field<T> field, String string) {
        this.field = field;
        this.name = string;
        this.stepHandlers = new ArrayList<FieldStepHandler<T>>();
        this.stepStart = null;
        this.stepSize = null;
        this.eventsStates = new ArrayList<FieldEventState<T>>();
        this.statesInitialized = false;
        this.evaluations = IntegerSequence$Incrementor.create().withMaximalCount(Integer.MAX_VALUE);
    }

    public Field<T> getField() {
        return this.field;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addStepHandler(FieldStepHandler<T> fieldStepHandler) {
        this.stepHandlers.add(fieldStepHandler);
    }

    @Override
    public Collection<FieldStepHandler<T>> getStepHandlers() {
        return Collections.unmodifiableCollection(this.stepHandlers);
    }

    @Override
    public void clearStepHandlers() {
        this.stepHandlers.clear();
    }

    @Override
    public void addEventHandler(FieldEventHandler<T> fieldEventHandler, double d2, double d3, int n) {
        this.addEventHandler(fieldEventHandler, d2, d3, n, new FieldBracketingNthOrderBrentSolver<RealFieldElement>((RealFieldElement)((RealFieldElement)this.field.getZero()).add(1.0E-14), (RealFieldElement)((RealFieldElement)this.field.getZero()).add(d3), (RealFieldElement)((RealFieldElement)this.field.getZero()).add(1.0E-15), 5));
    }

    @Override
    public void addEventHandler(FieldEventHandler<T> fieldEventHandler, double d2, double d3, int n, BracketedRealFieldUnivariateSolver<T> bracketedRealFieldUnivariateSolver) {
        this.eventsStates.add(new FieldEventState<RealFieldElement>(fieldEventHandler, d2, (RealFieldElement)((RealFieldElement)this.field.getZero()).add(d3), n, bracketedRealFieldUnivariateSolver));
    }

    @Override
    public Collection<FieldEventHandler<T>> getEventHandlers() {
        ArrayList<FieldEventHandler<T>> arrayList = new ArrayList<FieldEventHandler<T>>(this.eventsStates.size());
        for (FieldEventState<T> fieldEventState : this.eventsStates) {
            arrayList.add(fieldEventState.getEventHandler());
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    public void clearEventHandlers() {
        this.eventsStates.clear();
    }

    @Override
    public FieldODEStateAndDerivative<T> getCurrentStepStart() {
        return this.stepStart;
    }

    @Override
    public T getCurrentSignedStepsize() {
        return this.stepSize;
    }

    @Override
    public void setMaxEvaluations(int n) {
        this.evaluations = this.evaluations.withMaximalCount(n < 0 ? Integer.MAX_VALUE : n);
    }

    @Override
    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    /*
     * WARNING - void declaration
     */
    protected FieldODEStateAndDerivative<T> initIntegration(FieldExpandableODE<T> object, T object2, T[] object32, T t) {
        void var4_8;
        this.equations = object;
        this.evaluations = this.evaluations.withStart(0);
        object.init((RealFieldElement)object2, (RealFieldElement[])object32, (RealFieldElement)var4_8);
        object = this.computeDerivatives((RealFieldElement)object2, (RealFieldElement[])object32);
        object = new FieldODEStateAndDerivative((RealFieldElement)object2, (RealFieldElement[])object32, (RealFieldElement[])object);
        for (FieldEventState fieldEventState : this.eventsStates) {
            fieldEventState.getEventHandler().init((FieldODEStateAndDerivative<void>)object, var4_8);
        }
        for (FieldStepHandler fieldStepHandler : this.stepHandlers) {
            fieldStepHandler.init(object, var4_8);
        }
        this.setStateInitialized(false);
        return object;
    }

    protected FieldExpandableODE<T> getEquations() {
        return this.equations;
    }

    protected IntegerSequence$Incrementor getEvaluationsCounter() {
        return this.evaluations;
    }

    public T[] computeDerivatives(T t, T[] TArray) {
        this.evaluations.increment();
        return this.equations.computeDerivatives((RealFieldElement)t, (RealFieldElement[])TArray);
    }

    protected void setStateInitialized(boolean bl) {
        this.statesInitialized = bl;
    }

    protected FieldODEStateAndDerivative<T> acceptStep(AbstractFieldStepInterpolator<T> realFieldElementArray2, T object) {
        RealFieldElement[] realFieldElementArray;
        Object object22 = realFieldElementArray2.getGlobalPreviousState();
        FieldODEStateAndDerivative fieldODEStateAndDerivative = realFieldElementArray2.getGlobalCurrentState();
        if (!this.statesInitialized) {
            for (FieldEventState<T> fieldEventState : this.eventsStates) {
                fieldEventState.reinitializeBegin((FieldStepInterpolator<T>)realFieldElementArray2);
            }
            this.statesInitialized = true;
        }
        int n = realFieldElementArray2.isForward() ? 1 : -1;
        TreeSet<FieldEventState> treeSet = new TreeSet<FieldEventState>(new AbstractFieldIntegrator$1(this, n));
        for (FieldEventState<T> fieldEventState : this.eventsStates) {
            if (!fieldEventState.evaluateStep((FieldStepInterpolator<T>)realFieldElementArray2)) continue;
            treeSet.add(fieldEventState);
        }
        Object object3 = realFieldElementArray2;
        while (!treeSet.isEmpty()) {
            Iterator iterator = treeSet.iterator();
            FieldEventState fieldEventState = (FieldEventState)iterator.next();
            iterator.remove();
            FieldODEStateAndDerivative fieldODEStateAndDerivative2 = ((AbstractFieldStepInterpolator)object3).getInterpolatedState(fieldEventState.getEventTime());
            object3 = ((AbstractFieldStepInterpolator)object3).restrictStep(object22, fieldODEStateAndDerivative2);
            for (FieldEventState fieldEventState2 : this.eventsStates) {
                fieldEventState2.stepAccepted(fieldODEStateAndDerivative2);
                this.isLastStep = this.isLastStep || fieldEventState2.stop();
            }
            for (FieldStepHandler<T> fieldStepHandler : this.stepHandlers) {
                fieldStepHandler.handleStep((FieldStepInterpolator<T>)object3, this.isLastStep);
            }
            if (this.isLastStep) {
                return fieldODEStateAndDerivative2;
            }
            this.resetOccurred = false;
            for (Object object22 : this.eventsStates) {
                if ((object22 = ((FieldEventState)object22).reset(fieldODEStateAndDerivative2)) == null) continue;
                RealFieldElement[] realFieldElementArray3 = this.equations.getMapper().mapState((FieldODEState)object22);
                realFieldElementArray = this.computeDerivatives((RealFieldElement)((FieldODEState)object22).getTime(), realFieldElementArray3);
                this.resetOccurred = true;
                return this.equations.getMapper().mapStateAndDerivative((RealFieldElement)((FieldODEState)object22).getTime(), realFieldElementArray3, realFieldElementArray);
            }
            object22 = fieldODEStateAndDerivative2;
            if (!fieldEventState.evaluateStep(object3 = ((AbstractFieldStepInterpolator)object3).restrictStep(fieldODEStateAndDerivative2, fieldODEStateAndDerivative))) continue;
            treeSet.add(fieldEventState);
        }
        for (FieldEventState fieldEventState : this.eventsStates) {
            fieldEventState.stepAccepted(fieldODEStateAndDerivative);
            this.isLastStep = this.isLastStep || fieldEventState.stop();
        }
        this.isLastStep = this.isLastStep || ((RealFieldElement)((RealFieldElement)fieldODEStateAndDerivative.getTime().subtract((void)realFieldElementArray)).abs()).getReal() <= FastMath.ulp(realFieldElementArray.getReal());
        for (FieldStepHandler<T> fieldStepHandler : this.stepHandlers) {
            fieldStepHandler.handleStep((FieldStepInterpolator<T>)object3, this.isLastStep);
        }
        return fieldODEStateAndDerivative;
    }

    protected void sanityChecks(FieldODEState<T> fieldODEState, T t) {
        double d2;
        double d3 = 1000.0 * FastMath.ulp(FastMath.max(FastMath.abs(fieldODEState.getTime().getReal()), FastMath.abs(t.getReal())));
        double d4 = ((RealFieldElement)((RealFieldElement)fieldODEState.getTime().subtract(t)).abs()).getReal();
        if (d2 <= d3) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.TOO_SMALL_INTEGRATION_INTERVAL, (Number)d4, d3, false);
        }
    }

    protected boolean resetOccurred() {
        return this.resetOccurred;
    }

    protected void setStepSize(T t) {
        this.stepSize = t;
    }

    protected T getStepSize() {
        return this.stepSize;
    }

    protected void setStepStart(FieldODEStateAndDerivative<T> fieldODEStateAndDerivative) {
        this.stepStart = fieldODEStateAndDerivative;
    }

    protected FieldODEStateAndDerivative<T> getStepStart() {
        return this.stepStart;
    }

    protected void setIsLastStep(boolean bl) {
        this.isLastStep = bl;
    }

    protected boolean isLastStep() {
        return this.isLastStep;
    }
}

