/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.distance.DistanceMeasure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.Network;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.Neuron;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D$HorizontalDirection;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D$VerticalDirection;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.util.MapVisualization;

public class UnifiedDistanceMatrix
implements MapVisualization {
    private final boolean individualDistances;
    private final DistanceMeasure distance;

    public UnifiedDistanceMatrix(boolean bl, DistanceMeasure distanceMeasure) {
        this.individualDistances = bl;
        this.distance = distanceMeasure;
    }

    public double[][] computeImage(NeuronSquareMesh2D neuronSquareMesh2D) {
        if (this.individualDistances) {
            return this.individualDistances(neuronSquareMesh2D);
        }
        return this.averageDistances(neuronSquareMesh2D);
    }

    private double[][] individualDistances(NeuronSquareMesh2D neuronSquareMesh2D) {
        Neuron neuron;
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = neuronSquareMesh2D.getNumberOfRows();
        int n6 = neuronSquareMesh2D.getNumberOfColumns();
        double[][] dArray = new double[(n5 << 1) + 1][(n6 << 1) + 1];
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = 2 * n4 + 1;
            for (n2 = 0; n2 < n6; ++n2) {
                n = 2 * n2 + 1;
                object = neuronSquareMesh2D.getNeuron(n4, n2).getFeatures();
                neuron = neuronSquareMesh2D.getNeuron(n4, n2, NeuronSquareMesh2D$HorizontalDirection.RIGHT, NeuronSquareMesh2D$VerticalDirection.CENTER);
                if (neuron != null) {
                    dArray[n3][n + 1] = this.distance.compute((double[])object, neuron.getFeatures());
                }
                if ((neuron = neuronSquareMesh2D.getNeuron(n4, n2, NeuronSquareMesh2D$HorizontalDirection.CENTER, NeuronSquareMesh2D$VerticalDirection.DOWN)) == null) continue;
                dArray[n3 + 1][n] = this.distance.compute((double[])object, neuron.getFeatures());
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = 2 * n4 + 1;
            for (n2 = 0; n2 < n6; ++n2) {
                n = 2 * n2 + 1;
                object = neuronSquareMesh2D.getNeuron(n4, n2);
                neuron = neuronSquareMesh2D.getNeuron(n4, n2, NeuronSquareMesh2D$HorizontalDirection.RIGHT, NeuronSquareMesh2D$VerticalDirection.CENTER);
                Neuron neuron2 = neuronSquareMesh2D.getNeuron(n4, n2, NeuronSquareMesh2D$HorizontalDirection.CENTER, NeuronSquareMesh2D$VerticalDirection.DOWN);
                Neuron neuron3 = neuronSquareMesh2D.getNeuron(n4, n2, NeuronSquareMesh2D$HorizontalDirection.RIGHT, NeuronSquareMesh2D$VerticalDirection.DOWN);
                double d2 = neuron3 == null ? 0.0 : this.distance.compute(((Neuron)object).getFeatures(), neuron3.getFeatures());
                double d3 = neuron == null || neuron2 == null ? 0.0 : this.distance.compute(neuron.getFeatures(), neuron2.getFeatures());
                dArray[n3 + 1][n + 1] = 0.5 * (d2 + d3);
            }
        }
        n4 = dArray.length - 1;
        dArray[0] = dArray[n4];
        n3 = dArray[0].length - 1;
        for (n2 = 0; n2 < n4; ++n2) {
            dArray[n2][0] = dArray[n2][n3];
        }
        return dArray;
    }

    private double[][] averageDistances(NeuronSquareMesh2D neuronSquareMesh2D) {
        int n = neuronSquareMesh2D.getNumberOfRows();
        int n2 = neuronSquareMesh2D.getNumberOfColumns();
        double[][] dArray = new double[n][n2];
        Network network = neuronSquareMesh2D.getNetwork();
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                Object object = neuronSquareMesh2D.getNeuron(i2, i3);
                Object object2 = network.getNeighbours((Neuron)object);
                object = ((Neuron)object).getFeatures();
                double d2 = 0.0;
                int n3 = 0;
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    Neuron neuron = (Neuron)object2.next();
                    ++n3;
                    d2 += this.distance.compute((double[])object, neuron.getFeatures());
                }
                dArray[i2][i3] = d2 / (double)n3;
            }
        }
        return dArray;
    }
}

