/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.distance.DistanceMeasure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.MapUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.Network;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.Neuron;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.util.LocationFinder;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.util.LocationFinder$Location;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.util.MapDataVisualization;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopographicErrorHistogram
implements MapDataVisualization {
    private final DistanceMeasure distance;
    private final boolean relativeCount;

    public TopographicErrorHistogram(boolean bl, DistanceMeasure distanceMeasure) {
        this.relativeCount = bl;
        this.distance = distanceMeasure;
    }

    @Override
    public double[][] computeImage(NeuronSquareMesh2D neuronSquareMesh2D, Iterable<double[]> object) {
        int n = neuronSquareMesh2D.getNumberOfRows();
        int n2 = neuronSquareMesh2D.getNumberOfColumns();
        Network network = neuronSquareMesh2D.getNetwork();
        LocationFinder locationFinder = new LocationFinder(neuronSquareMesh2D);
        int[][] nArray = new int[n][n2];
        double[][] dArray = new double[n][n2];
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (double[])object.next();
            Pair<Neuron, Neuron> pair = MapUtils.findBestAndSecondBest((double[])object2, neuronSquareMesh2D, this.distance);
            object2 = pair;
            Neuron neuron = pair.getFirst();
            LocationFinder$Location locationFinder$Location = locationFinder.getLocation(neuron);
            int n3 = locationFinder$Location.getRow();
            int n4 = locationFinder$Location.getColumn();
            int[] nArray2 = nArray[n3];
            int n5 = n4;
            nArray2[n5] = nArray2[n5] + 1;
            if (network.getNeighbours(neuron).contains(((Pair)object2).getSecond())) continue;
            double[] dArray2 = dArray[n3];
            int n6 = n4;
            dArray2[n6] = dArray2[n6] + 1.0;
        }
        if (this.relativeCount) {
            for (int i2 = 0; i2 < n; ++i2) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    double[] dArray3 = dArray[i2];
                    int n7 = i3;
                    dArray3[n7] = dArray3[n7] / (double)nArray[i2][i3];
                }
            }
        }
        return dArray;
    }
}

