/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.util;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.distance.DistanceMeasure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.MapUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.Neuron;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.util.LocationFinder;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.util.LocationFinder$Location;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.ml.neuralnet.twod.util.MapDataVisualization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmoothedDataHistogram
implements MapDataVisualization {
    private final int smoothingBins;
    private final DistanceMeasure distance;
    private final double membershipNormalization;

    public SmoothedDataHistogram(int n, DistanceMeasure distanceMeasure) {
        this.smoothingBins = n;
        this.distance = distanceMeasure;
        double d2 = 0.0;
        for (int i2 = 0; i2 < n; ++i2) {
            d2 += (double)(n - i2);
        }
        this.membershipNormalization = 1.0 / d2;
    }

    @Override
    public double[][] computeImage(NeuronSquareMesh2D neuronSquareMesh2D, Iterable<double[]> object) {
        int n;
        int n2 = neuronSquareMesh2D.getNumberOfRows();
        int n3 = n2 * (n = neuronSquareMesh2D.getNumberOfColumns());
        if (n3 < this.smoothingBins) {
            throw new NumberIsTooSmallException(n3, (Number)this.smoothingBins, true);
        }
        LocationFinder locationFinder = new LocationFinder(neuronSquareMesh2D);
        double[][] dArray = new double[n2][n];
        object = object.iterator();
        while (object.hasNext()) {
            Object[] objectArray = (double[])object.next();
            objectArray = MapUtils.sort(objectArray, neuronSquareMesh2D.getNetwork(), this.distance);
            for (int i2 = 0; i2 < this.smoothingBins; ++i2) {
                LocationFinder$Location locationFinder$Location = locationFinder.getLocation((Neuron)objectArray[i2]);
                int n4 = locationFinder$Location.getRow();
                int n5 = locationFinder$Location.getColumn();
                double[] dArray2 = dArray[n4];
                int n6 = n5;
                dArray2[n6] = dArray2[n6] + (double)(this.smoothingBins - i2) * this.membershipNormalization;
            }
        }
        return dArray;
    }
}

